/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.manager;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.file.services.FileStorageException;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.ActivityProcessor;
import org.exoplatform.social.core.BaseActivityProcessorPlugin;
import org.exoplatform.social.core.activity.ActivitiesRealtimeListAccess;
import org.exoplatform.social.core.activity.ActivityLifeCycle;
import org.exoplatform.social.core.activity.ActivityListener;
import org.exoplatform.social.core.activity.ActivityListenerPlugin;
import org.exoplatform.social.core.activity.CommentsRealtimeListAccess;
import org.exoplatform.social.core.activity.model.ActivityFile;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.ActivityStorageException;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;

public class ActivityManagerImpl
implements ActivityManager {
    private static final Log LOG = ExoLogger.getLogger(ActivityManagerImpl.class);
    protected ActivityStorage activityStorage;
    protected IdentityManager identityManager;
    private UserACL userACL;
    protected SpaceService spaceService;
    private FileService fileService;
    private UploadService uploadService;
    private RepositoryService repositoryService;
    private NodeHierarchyCreator nodeHierarchyCreator;
    protected ActivityLifeCycle activityLifeCycle = new ActivityLifeCycle();
    private static final int DEFAULT_LIMIT = 20;
    private static Map<String, Boolean> activityTypesRegistry = new HashMap<String, Boolean>();
    private static final String ACTIVITY_TYPE_PROPERTY_PATTERN = "exo\\.activity-type\\..*\\.enabled";
    private static final String PREFIX = "exo.activity-type.";
    private static final String SUFFIX = ".enabled";
    public static final String ENABLE_EDIT_ACTIVITY = "exo.edit.activity.enabled";
    public static final String ENABLE_EDIT_COMMENT = "exo.edit.comment.enabled";
    public static final String ENABLE_MANAGER_EDIT_ACTIVITY = "exo.manager.edit.activity.enabled";
    public static final String ENABLE_MANAGER_EDIT_COMMENT = "exo.manager.edit.comment.enabled";
    private int maxUploadSize = 10;
    private boolean enableEditActivity = true;
    private boolean enableEditComment = true;
    private boolean enableManagerEditActivity = true;
    private boolean enableManagerEditComment = true;
    public static final List<String> AUTOMATIC_EDIT_TITLE_ACTIVITIES = Arrays.asList("has_joined", "space_avatar_edited", "space_description_edited", "space_renamed", "manager_role_revoked", "manager_role_granted");
    public static final String FILE_STORAGE_JCR = "jcr";
    private static final String USER_FOLDER_PUBLIC_ALIAS = "userPublic";
    private static final String ACTIVITY_FOLDER_UPLOAD_NAME = "Activity Stream Documents";
    public static final String TEMPLATE_PARAMS_SEPARATOR = "|@|";
    public static final String SEPARATOR_REGEX = "\\|@\\|";
    public static final String ID = "id";
    public static final String STORAGE = "storage";
    public static final String FILE = "file";

    public ActivityManagerImpl(ActivityStorage activityStorage, IdentityManager identityManager, UserACL userACL, FileService fileService, UploadService uploadService, RepositoryService repositoryService, NodeHierarchyCreator nodeHierarchyCreator, InitParams params) {
        this.activityStorage = activityStorage;
        this.identityManager = identityManager;
        this.userACL = userACL;
        this.fileService = fileService;
        this.uploadService = uploadService;
        this.repositoryService = repositoryService;
        this.nodeHierarchyCreator = nodeHierarchyCreator;
        this.initActivityTypes();
        if (params != null) {
            if (params.containsKey((Object)"upload.limit.size") && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)params.getValueParam("upload.limit.size").getValue())) {
                this.maxUploadSize = Integer.parseInt(params.getValueParam("upload.limit.size").getValue());
            }
            if (params.containsKey((Object)ENABLE_EDIT_ACTIVITY)) {
                this.enableEditActivity = Boolean.parseBoolean(params.getValueParam(ENABLE_EDIT_ACTIVITY).getValue());
            }
            if (params.containsKey((Object)ENABLE_EDIT_COMMENT)) {
                this.enableEditComment = Boolean.parseBoolean(params.getValueParam(ENABLE_EDIT_COMMENT).getValue());
            }
            if (params.containsKey((Object)ENABLE_MANAGER_EDIT_ACTIVITY)) {
                this.enableManagerEditActivity = Boolean.parseBoolean(params.getValueParam(ENABLE_MANAGER_EDIT_ACTIVITY).getValue());
            }
            if (params.containsKey((Object)ENABLE_MANAGER_EDIT_COMMENT)) {
                this.enableManagerEditComment = Boolean.parseBoolean(params.getValueParam(ENABLE_MANAGER_EDIT_COMMENT).getValue());
            }
        } else {
            String maxUploadString = System.getProperty("wcm.connector.drives.uploadLimit");
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)maxUploadString)) {
                this.maxUploadSize = Integer.parseInt(maxUploadString);
            }
        }
    }

    @Override
    public void saveActivityNoReturn(org.exoplatform.social.core.identity.model.Identity streamOwner, ExoSocialActivity newActivity) {
        if (!streamOwner.isEnable()) {
            LOG.warn((Object)"Activity could not be saved. Owner has been disabled.");
            return;
        }
        if (newActivity.getType() != null && activityTypesRegistry.get(newActivity.getType()) != null && !activityTypesRegistry.get(newActivity.getType()).booleanValue()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Activity could not be saved. Activity Type {} has been disabled.", new Object[]{newActivity.getType()});
            }
            return;
        }
        try {
            if (CollectionUtils.isNotEmpty(newActivity.getFiles())) {
                for (ActivityFile activityFile : newActivity.getFiles()) {
                    if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)activityFile.getStorage()) && activityFile.getStorage().equals(FILE_STORAGE_JCR)) {
                        newActivity = this.storeFileInJCR(newActivity, streamOwner, activityFile);
                        continue;
                    }
                    newActivity = this.storeFile(newActivity, activityFile);
                }
                newActivity.getTemplateParams().put("MESSAGE", newActivity.getTitle());
            }
            this.activityStorage.saveActivity(streamOwner, newActivity);
            this.activityLifeCycle.saveActivity(newActivity);
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot save activity", (Throwable)e);
        }
    }

    private ExoSocialActivity storeFile(ExoSocialActivity activity, ActivityFile file) throws Exception {
        FileItem fileItem;
        UploadResource uploadedResource = this.uploadService.getUploadResource(file.getUploadId());
        if (uploadedResource == null) {
            throw new Exception("Cannot attach uploaded file " + file.getUploadId() + ", it may not exist");
        }
        String fileDiskLocation = uploadedResource.getStoreLocation();
        try (FileInputStream inputStream = new FileInputStream(fileDiskLocation);){
            fileItem = this.fileService.writeFile(new FileItem(null, uploadedResource.getFileName(), uploadedResource.getMimeType(), "social", Double.doubleToLongBits(uploadedResource.getUploadedSize()), new Date(), activity.getPosterId(), false, (InputStream)inputStream));
        }
        if (fileItem != null) {
            if (activity.getTemplateParams() == null) {
                activity.setTemplateParams(new HashMap<String, String>());
            }
            this.concatenateParam(activity.getTemplateParams(), STORAGE, FILE);
            this.concatenateParam(activity.getTemplateParams(), ID, String.valueOf(fileItem.getFileInfo().getId()));
        }
        this.uploadService.removeUploadResource(file.getUploadId());
        return activity;
    }

    private ExoSocialActivity storeFileInJCR(ExoSocialActivity activity, org.exoplatform.social.core.identity.model.Identity streamOwner, ActivityFile file) throws Exception {
        Node parentNode;
        UploadResource uploadedResource = this.uploadService.getUploadResource(file.getUploadId());
        if (uploadedResource == null) {
            throw new Exception("Cannot attach uploaded file " + file.getUploadId() + ", it may not exist");
        }
        SessionProvider sessionProvider = CommonsUtils.getSystemSessionProvider();
        ManageableRepository currentRepository = this.repositoryService.getCurrentRepository();
        String workspaceName = currentRepository.getConfiguration().getDefaultWorkspaceName();
        Session session = sessionProvider.getSession(workspaceName, currentRepository);
        if (streamOwner.getProviderId().equals("space")) {
            Space space = this.spaceService.getSpaceById(streamOwner.getId());
            String groupPath = this.nodeHierarchyCreator.getJcrPath("groupsPath");
            String spaceParentPath = groupPath + space.getGroupId() + "/Documents";
            if (!session.itemExists(spaceParentPath)) {
                throw new IllegalStateException("Root node of space '" + spaceParentPath + "' doesn't exist");
            }
            parentNode = (Node)session.getItem(spaceParentPath);
        } else {
            String remoteUser = ConversationState.getCurrent().getIdentity().getUserId();
            if (StringUtils.isBlank((String)remoteUser)) {
                throw new IllegalStateException("Remote user is empty");
            }
            Node userNode = this.nodeHierarchyCreator.getUserNode(sessionProvider, remoteUser);
            String publicPath = this.nodeHierarchyCreator.getJcrPath(USER_FOLDER_PUBLIC_ALIAS);
            if (userNode == null || !userNode.hasNode(publicPath)) {
                throw new IllegalStateException("User '" + remoteUser + "' hasn't public folder");
            }
            parentNode = userNode.getNode(publicPath);
            if (!parentNode.hasNode(ACTIVITY_FOLDER_UPLOAD_NAME)) {
                parentNode.addNode(ACTIVITY_FOLDER_UPLOAD_NAME);
                session.save();
            }
        }
        Node parentUploadNode = parentNode.getNode(ACTIVITY_FOLDER_UPLOAD_NAME);
        Node node = parentUploadNode.addNode(uploadedResource.getFileName(), "nt:file");
        node.setProperty("exo:title", uploadedResource.getFileName());
        Node resourceNode = node.addNode("jcr:content", "nt:resource");
        resourceNode.setProperty("jcr:mimeType", uploadedResource.getMimeType());
        resourceNode.setProperty("jcr:lastModified", Calendar.getInstance());
        String fileDiskLocation = uploadedResource.getStoreLocation();
        try (FileInputStream inputStream = new FileInputStream(fileDiskLocation);){
            resourceNode.setProperty("jcr:data", (InputStream)inputStream);
            session.save();
            node = (Node)session.getItem(node.getPath());
        }
        if (activity.getTemplateParams() == null) {
            activity.setTemplateParams(new HashMap<String, String>());
        }
        this.concatenateParam(activity.getTemplateParams(), "REPOSITORY", "repository");
        this.concatenateParam(activity.getTemplateParams(), "WORKSPACE", "collaboration");
        this.concatenateParam(activity.getTemplateParams(), "DOCPATH", node.getPath());
        this.concatenateParam(activity.getTemplateParams(), ID, node.isNodeType("mix:referenceable") ? node.getUUID() : "");
        this.uploadService.removeUploadResource(file.getUploadId());
        return activity;
    }

    public void concatenateParam(Map<String, String> activityParams, String paramName, String paramValue) {
        String oldParamValue = activityParams.get(paramName);
        if (oldParamValue == null) {
            activityParams.put(paramName, paramValue);
        } else {
            activityParams.put(paramName, oldParamValue + TEMPLATE_PARAMS_SEPARATOR + paramValue);
        }
    }

    @Override
    public void saveActivityNoReturn(ExoSocialActivity newActivity) {
        org.exoplatform.social.core.identity.model.Identity owner = this.getStreamOwner(newActivity);
        this.saveActivityNoReturn(owner, newActivity);
    }

    @Override
    public void saveActivity(org.exoplatform.social.core.identity.model.Identity streamOwner, String activityType, String activityTitle) {
        if (activityType != null && activityTypesRegistry.get(activityType) != null && !activityTypesRegistry.get(activityType).booleanValue()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Activity could not be saved. Activity Type {} has been disabled.", new Object[]{activityType});
            }
            return;
        }
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setType(activityType);
        activity.setTitle(activityTitle);
        this.saveActivity(streamOwner, activity);
    }

    @Override
    public ExoSocialActivity getActivity(String activityId) {
        return this.activityStorage.getActivity(activityId);
    }

    @Override
    public ExoSocialActivity getParentActivity(ExoSocialActivity comment) {
        return this.activityStorage.getParentActivity(comment);
    }

    @Override
    public List<ExoSocialActivity> getSubComments(ExoSocialActivity comment) {
        return this.activityStorage.getSubComments(comment);
    }

    @Override
    public void updateActivity(ExoSocialActivity existingActivity) {
        this.updateActivity(existingActivity, true);
    }

    @Override
    public void updateActivity(ExoSocialActivity existingActivity, boolean broadcast) {
        String activityId = existingActivity.getId();
        CharSequence[] previousMentions = this.getActivity(activityId).getMentionedIds();
        this.activityStorage.updateActivity(existingActivity);
        if (previousMentions.length > 0) {
            String mentions = String.join((CharSequence)",", previousMentions);
            HashMap<String, String> mentionsTemplateParams = existingActivity.getTemplateParams() != null ? existingActivity.getTemplateParams() : new HashMap<String, String>();
            mentionsTemplateParams.put("PreviousMentions", mentions);
            existingActivity.setTemplateParams(mentionsTemplateParams);
        }
        if (broadcast) {
            this.activityLifeCycle.updateActivity(existingActivity);
        }
    }

    @Override
    public void deleteActivity(ExoSocialActivity existingActivity) {
        Validate.notNull((Object)existingActivity.getId(), (String)"existingActivity.getId() must not be null!");
        this.deleteActivity(existingActivity.getId());
    }

    @Override
    public void deleteActivity(String activityId) {
        this.activityStorage.deleteActivity(activityId);
    }

    @Override
    public void saveComment(ExoSocialActivity existingActivity, ExoSocialActivity newComment) {
        boolean activityTypeDisabled;
        if (existingActivity == null) {
            throw new ActivityStorageException(ActivityStorageException.Type.FAILED_TO_SAVE_COMMENT, "Activity cannot be NULL");
        }
        if (existingActivity.getId() == null) {
            LOG.debug((Object)"Comment could not be saved because activity id is null.");
            return;
        }
        String activityType = existingActivity.getType();
        String commentActivityType = newComment.getType();
        String commentId = newComment.getId();
        boolean commentActivityTypeDisabled = commentActivityType != null && activityTypesRegistry.containsKey(commentActivityType) && activityTypesRegistry.get(commentActivityType) == Boolean.FALSE;
        boolean bl = activityTypeDisabled = activityType != null && activityTypesRegistry.containsKey(activityType) && activityTypesRegistry.get(activityType) == Boolean.FALSE;
        if (commentActivityTypeDisabled || activityTypeDisabled) {
            if (LOG.isDebugEnabled()) {
                if (activityTypeDisabled) {
                    LOG.debug("Comment could not be saved. Activity Type {} is disabled.", new Object[]{activityType});
                }
                if (commentActivityTypeDisabled) {
                    LOG.debug("Comment could not be saved. Comment activity Type {} is disabled.", new Object[]{commentActivityType});
                }
            }
            return;
        }
        CharSequence[] previousMentions = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)commentId) ? new String[]{} : this.getActivity(commentId).getMentionedIds();
        this.activityStorage.saveComment(existingActivity, newComment);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)commentId)) {
            this.activityLifeCycle.saveComment(newComment);
        } else {
            if (previousMentions.length > 0) {
                String mentions = String.join((CharSequence)",", previousMentions);
                HashMap<String, String> mentionsTemplateParams = newComment.getTemplateParams() != null ? newComment.getTemplateParams() : new HashMap<String, String>();
                mentionsTemplateParams.put("PreviousMentions", mentions);
                newComment.setTemplateParams(mentionsTemplateParams);
            }
            this.activityLifeCycle.updateComment(newComment);
        }
    }

    @Override
    public RealtimeListAccess<ExoSocialActivity> getCommentsWithListAccess(ExoSocialActivity existingActivity, boolean loadSubComments) {
        return new CommentsRealtimeListAccess(this.activityStorage, existingActivity, loadSubComments);
    }

    @Override
    public RealtimeListAccess<ExoSocialActivity> getCommentsWithListAccess(ExoSocialActivity existingActivity) {
        return new CommentsRealtimeListAccess(this.activityStorage, existingActivity);
    }

    @Override
    public void deleteComment(String activityId, String commentId) {
        this.activityStorage.deleteComment(activityId, commentId);
    }

    @Override
    public void deleteComment(ExoSocialActivity existingActivity, ExoSocialActivity existingComment) {
        this.deleteComment(existingActivity.getId(), existingComment.getId());
    }

    @Override
    public void saveLike(ExoSocialActivity existingActivity, org.exoplatform.social.core.identity.model.Identity identity) {
        Object[] identityIds = existingActivity.getLikeIdentityIds();
        if (ArrayUtils.contains((Object[])identityIds, (Object)identity.getId())) {
            LOG.warn((Object)("activity is already liked by identity: " + identity));
            return;
        }
        identityIds = (String[])ArrayUtils.add((Object[])identityIds, (Object)identity.getId());
        existingActivity.setLikeIdentityIds((String[])identityIds);
        this.updateActivity(existingActivity, false);
        if (existingActivity.isComment()) {
            this.activityLifeCycle.likeComment(existingActivity);
        } else {
            this.activityLifeCycle.likeActivity(existingActivity);
        }
    }

    @Override
    public void deleteLike(ExoSocialActivity activity, org.exoplatform.social.core.identity.model.Identity identity) {
        activity.setTitle(null);
        activity.setBody(null);
        activity.setTemplateParams(null);
        Object[] identityIds = activity.getLikeIdentityIds();
        if (ArrayUtils.contains((Object[])identityIds, (Object)identity.getId())) {
            identityIds = (String[])ArrayUtils.removeElement((Object[])identityIds, (Object)identity.getId());
            activity.setLikeIdentityIds((String[])identityIds);
            this.updateActivity(activity, false);
        } else {
            LOG.warn((Object)("activity is not liked by identity: " + identity));
        }
    }

    @Override
    public void addActivityEventListener(ActivityListenerPlugin activityListenerPlugin) {
        this.registerActivityListener(activityListenerPlugin);
    }

    public void registerActivityListener(ActivityListener listener) {
        this.activityLifeCycle.addListener(listener);
    }

    public void unregisterActivityListener(ActivityListener listener) {
        this.activityLifeCycle.removeListener(listener);
    }

    @Override
    public RealtimeListAccess<ExoSocialActivity> getActivitiesWithListAccess(org.exoplatform.social.core.identity.model.Identity existingIdentity) {
        return new ActivitiesRealtimeListAccess(this.activityStorage, ActivitiesRealtimeListAccess.ActivityType.USER_ACTIVITIES, existingIdentity);
    }

    @Override
    public RealtimeListAccess<ExoSocialActivity> getActivitiesWithListAccess(org.exoplatform.social.core.identity.model.Identity ownerIdentity, org.exoplatform.social.core.identity.model.Identity viewerIdentity) {
        return new ActivitiesRealtimeListAccess(this.activityStorage, ActivitiesRealtimeListAccess.ActivityType.VIEW_USER_ACTIVITIES, ownerIdentity, viewerIdentity);
    }

    @Override
    public RealtimeListAccess<ExoSocialActivity> getActivitiesOfConnectionsWithListAccess(org.exoplatform.social.core.identity.model.Identity existingIdentity) {
        return new ActivitiesRealtimeListAccess(this.activityStorage, ActivitiesRealtimeListAccess.ActivityType.CONNECTIONS_ACTIVITIES, existingIdentity);
    }

    @Override
    public RealtimeListAccess<ExoSocialActivity> getActivitiesOfUserSpacesWithListAccess(org.exoplatform.social.core.identity.model.Identity existingIdentity) {
        return new ActivitiesRealtimeListAccess(this.activityStorage, ActivitiesRealtimeListAccess.ActivityType.USER_SPACE_ACTIVITIES, existingIdentity);
    }

    @Override
    public RealtimeListAccess<ExoSocialActivity> getActivitiesOfSpaceWithListAccess(org.exoplatform.social.core.identity.model.Identity existingSpaceIdentity) {
        return new ActivitiesRealtimeListAccess(this.activityStorage, ActivitiesRealtimeListAccess.ActivityType.SPACE_ACTIVITIES, existingSpaceIdentity);
    }

    @Override
    public RealtimeListAccess<ExoSocialActivity> getActivityFeedWithListAccess(org.exoplatform.social.core.identity.model.Identity existingIdentity) {
        return new ActivitiesRealtimeListAccess(this.activityStorage, ActivitiesRealtimeListAccess.ActivityType.ACTIVITY_FEED, existingIdentity);
    }

    @Override
    public RealtimeListAccess<ExoSocialActivity> getActivitiesByPoster(org.exoplatform.social.core.identity.model.Identity posterIdentity) {
        return new ActivitiesRealtimeListAccess(this.activityStorage, ActivitiesRealtimeListAccess.ActivityType.POSTER_ACTIVITIES, posterIdentity);
    }

    @Override
    public RealtimeListAccess<ExoSocialActivity> getActivitiesByPoster(org.exoplatform.social.core.identity.model.Identity posterIdentity, String ... activityTypes) {
        return new ActivitiesRealtimeListAccess(this.activityStorage, ActivitiesRealtimeListAccess.ActivityType.POSTER_AND_TYPES_ACTIVITIES, posterIdentity, activityTypes);
    }

    @Override
    public void addProcessor(ActivityProcessor processor) {
        this.activityStorage.getActivityProcessors().add(processor);
        LOG.debug((Object)("added activity processor " + processor.getClass()));
    }

    @Override
    public void addProcessorPlugin(BaseActivityProcessorPlugin plugin) {
        this.addProcessor(plugin);
    }

    public void initActivityTypes() {
        Properties properties = PropertyManager.getPropertiesByPattern((String)ACTIVITY_TYPE_PROPERTY_PATTERN);
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String value = properties.getProperty(k.toString());
            String name = k.toString().substring(PREFIX.length(), k.toString().lastIndexOf(SUFFIX));
            if (value != null && value.equalsIgnoreCase("false")) {
                LOG.info("Activity Type key:  {},  registration status: disabled", new Object[]{name});
                activityTypesRegistry.putIfAbsent(name, false);
            } else {
                LOG.info("Activity Type key:  {},  registration status: enabled", new Object[]{name});
                activityTypesRegistry.putIfAbsent(name, true);
            }
        }));
    }

    @Override
    public ExoSocialActivity saveActivity(org.exoplatform.social.core.identity.model.Identity streamOwner, ExoSocialActivity newActivity) {
        ExoSocialActivity created = this.activityStorage.saveActivity(streamOwner, newActivity);
        this.activityLifeCycle.saveActivity(this.getActivity(created.getId()));
        return created;
    }

    @Override
    public ExoSocialActivity saveActivity(ExoSocialActivity newActivity) {
        this.saveActivityNoReturn(newActivity);
        return newActivity;
    }

    @Override
    public List<ExoSocialActivity> getActivities(org.exoplatform.social.core.identity.model.Identity identity) throws ActivityStorageException {
        List<ExoSocialActivity> activityList = Collections.emptyList();
        try {
            ExoSocialActivity[] activities = (ExoSocialActivity[])this.getActivitiesWithListAccess(identity).load(0, 20);
            activityList = Arrays.asList(activities);
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to get activities by identity: " + identity));
        }
        return activityList;
    }

    @Override
    public List<ExoSocialActivity> getActivities(org.exoplatform.social.core.identity.model.Identity identity, long start, long limit) throws ActivityStorageException {
        return this.activityStorage.getUserActivities(identity, start, limit);
    }

    @Override
    public List<ExoSocialActivity> getActivitiesOfConnections(org.exoplatform.social.core.identity.model.Identity ownerIdentity) throws ActivityStorageException {
        List<ExoSocialActivity> activityList = Collections.emptyList();
        try {
            ExoSocialActivity[] activities = (ExoSocialActivity[])this.getActivitiesOfConnectionsWithListAccess(ownerIdentity).load(0, 30);
            activityList = Arrays.asList(activities);
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to get activities of connections!");
        }
        return activityList;
    }

    @Override
    public List<ExoSocialActivity> getActivitiesOfConnections(org.exoplatform.social.core.identity.model.Identity ownerIdentity, int offset, int limit) throws ActivityStorageException {
        this.validateStartLimit(offset, limit);
        List<Object> connectionList = null;
        try {
            ListAccess<org.exoplatform.social.core.identity.model.Identity> connectionsWithListAccess = this.identityManager.getConnectionsWithListAccess(ownerIdentity);
            connectionList = Arrays.asList(connectionsWithListAccess.load(0, connectionsWithListAccess.getSize()));
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to getActivitiesOfIdentities of: " + ownerIdentity.getRemoteId()), (Throwable)e);
        }
        return this.activityStorage.getActivitiesOfIdentities(connectionList, offset, limit);
    }

    @Override
    public List<ExoSocialActivity> getActivitiesOfUserSpaces(org.exoplatform.social.core.identity.model.Identity ownerIdentity) {
        return this.getActivitiesOfUserSpacesWithListAccess(ownerIdentity).loadAsList(0, 20);
    }

    @Override
    public List<ExoSocialActivity> getActivityFeed(org.exoplatform.social.core.identity.model.Identity identity) {
        return this.getActivityFeedWithListAccess(identity).loadAsList(0, 40);
    }

    @Override
    public void removeLike(ExoSocialActivity existingActivity, org.exoplatform.social.core.identity.model.Identity existingIdentity) {
        this.deleteLike(existingActivity, existingIdentity);
    }

    @Override
    public List<ExoSocialActivity> getComments(ExoSocialActivity existingActivity) {
        return this.getCommentsWithListAccess(existingActivity).loadAsList(0, 40);
    }

    @Override
    public ExoSocialActivity recordActivity(org.exoplatform.social.core.identity.model.Identity owner, String type, String title) throws ActivityStorageException {
        ExoSocialActivityImpl newActivity = new ExoSocialActivityImpl(owner.getId(), type, title);
        this.saveActivity(owner, newActivity);
        return newActivity;
    }

    @Override
    public int getActivitiesCount(org.exoplatform.social.core.identity.model.Identity owner) throws ActivityStorageException {
        return this.activityStorage.getNumberOfUserActivities(owner);
    }

    @Override
    public void processActivitiy(ExoSocialActivity activity) {
    }

    @Override
    public ExoSocialActivity recordActivity(org.exoplatform.social.core.identity.model.Identity owner, ExoSocialActivity activity) throws Exception {
        this.saveActivity(owner, activity);
        return activity;
    }

    @Override
    public ExoSocialActivity recordActivity(org.exoplatform.social.core.identity.model.Identity owner, String type, String title, String body) throws ActivityStorageException {
        String userId = owner.getId();
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl(userId, type, title, body);
        this.saveActivity(owner, activity);
        return activity;
    }

    private void validateStartLimit(long start, long limit) {
        Validate.isTrue((limit >= start ? 1 : 0) != 0, (String)"'limit' must be greater than or equal to 'start'");
        Validate.isTrue((limit - start <= 20L ? 1 : 0) != 0, (String)"'limit - start' must be less than or equal to 20");
    }

    private org.exoplatform.social.core.identity.model.Identity getStreamOwner(ExoSocialActivity newActivity) {
        Validate.notNull((Object)newActivity.getUserId(), (String)"activity.getUserId() must not be null!");
        return this.identityManager.getIdentity(newActivity.getUserId(), false);
    }

    @Override
    public RealtimeListAccess<ExoSocialActivity> getAllActivitiesWithListAccess() {
        return new ActivitiesRealtimeListAccess(this.activityStorage, ActivitiesRealtimeListAccess.ActivityType.ALL);
    }

    @Override
    public int getMaxUploadSize() {
        return this.maxUploadSize;
    }

    @Override
    public List<ExoSocialActivity> getActivities(List<String> activityIdList) {
        return this.activityStorage.getActivities(activityIdList);
    }

    @Override
    public boolean isActivityEditable(ExoSocialActivity activity, Identity viewer) {
        if (activity != null) {
            boolean enableManagerEdit;
            boolean enableEdit;
            if (activity.isComment()) {
                enableEdit = this.enableEditComment;
                enableManagerEdit = this.enableManagerEditComment;
            } else {
                enableEdit = this.enableEditActivity;
                enableManagerEdit = this.enableManagerEditActivity;
            }
            org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateIdentity("organization", viewer.getUserId(), false);
            if (enableEdit && (identity.getId().equals(activity.getPosterId()) || enableManagerEdit && viewer.getGroups().contains(this.userACL.getAdminGroups()))) {
                return !activity.isComment() || !this.isAutomaticComment(activity);
            }
        }
        return false;
    }

    @Override
    public List<String> getActivityFilesIds(ExoSocialActivity activity) {
        ArrayList<String> values = new ArrayList<String>();
        if (activity != null) {
            String[] ids = this.getParameterValues(activity.getTemplateParams(), ID);
            String[] storages = this.getParameterValues(activity.getTemplateParams(), STORAGE);
            if (ids != null && ids.length > 0) {
                for (int i = 0; i < ids.length; ++i) {
                    if (storages == null || storages.length <= 0 || storages.length <= i || !storages[i].equals(FILE)) continue;
                    values.add(ids[i]);
                }
            }
        }
        return values;
    }

    @Override
    public ActivityFile getActivityFileById(long fileId) throws Exception {
        FileItem file = null;
        try {
            file = this.fileService.getFile(fileId);
        }
        catch (FileStorageException e) {
            LOG.error((Object)("Failed to  get the file with id : " + fileId), (Throwable)e);
        }
        return this.convertFileItemToActivityFile(file);
    }

    public boolean isAutomaticComment(ExoSocialActivity activity) {
        return activity != null && (!"exosocial:spaces".equals(activity.getType()) || "exosocial:spaces".equals(activity.getType()) && AUTOMATIC_EDIT_TITLE_ACTIVITIES.contains(activity.getTitleId()));
    }

    private String[] getParameterValues(Map<String, String> activityParams, String paramName) {
        String[] values = null;
        String value = activityParams.get(paramName);
        if (value == null) {
            value = activityParams.get(paramName.toLowerCase());
        }
        if (value != null) {
            values = value.split(SEPARATOR_REGEX);
        }
        return values;
    }

    private ActivityFile convertFileItemToActivityFile(FileItem fileItem) throws Exception {
        ActivityFile activityFile = new ActivityFile();
        activityFile.setInputStream(fileItem.getAsStream());
        activityFile.setName(fileItem.getFileInfo().getName());
        activityFile.setMimeType(fileItem.getFileInfo().getMimetype());
        long lastUpdated = fileItem.getFileInfo().getUpdatedDate() != null ? fileItem.getFileInfo().getUpdatedDate().getTime() : new Date().getTime();
        activityFile.setLastModified(lastUpdated);
        return activityFile;
    }
}

