/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.plugin.doc;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.plugin.doc.ComposerFileItem;
import org.exoplatform.social.plugin.doc.UIAbstractSelectFileComposer;
import org.exoplatform.social.plugin.doc.UIDocActivityComposer;
import org.exoplatform.social.plugin.doc.selector.UIDocumentSelector;
import org.exoplatform.social.webui.composer.UIComposer;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(lifecycle=Lifecycle.class, template="classpath:groovy/social/plugin/doc/UIDocActivityPopup.gtmpl", events={@EventConfig(listeners={SelectedFileActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UIDocActivityPopup
extends UIContainer
implements UIPopupComponent {
    private static final Log LOG = ExoLogger.getLogger(UIDocActivityPopup.class);
    protected static final String UI_DOCUMENT_SELECTOR_TAB = "UIDocumentSelectorTab";
    protected static final String CANCEL = "Cancel";
    public static final String SELECTEDFILE = "SelectedFile";
    private UIDocumentSelector uiDocumentSelector;
    private List<UIAbstractSelectFileComposer> uiFileSelectors = new ArrayList<UIAbstractSelectFileComposer>();
    private boolean maxSelectedFilesReached;
    private int maxFilesCount = 0;

    public UIDocActivityPopup() {
        try {
            ResourceBundle resourceBundle = WebuiRequestContext.getCurrentInstance().getApplicationResourceBundle();
            String documentSelectorTitle = resourceBundle.getString("UIComposerMultiUpload.label.tab.document");
            this.uiDocumentSelector = (UIDocumentSelector)this.addChild(UIDocumentSelector.class, null, UI_DOCUMENT_SELECTOR_TAB);
            this.uiDocumentSelector.setTitle(documentSelectorTitle);
            this.uiFileSelectors.add(this.uiDocumentSelector);
        }
        catch (Exception e) {
            LOG.error((Object)"An exception happens when init UIDocActivityPopup", (Throwable)e);
        }
    }

    public void activate() {
    }

    public int getMaxFilesCount() {
        return this.maxFilesCount;
    }

    public void setMaxFilesCount(int maxFilesCount) {
        this.maxFilesCount = maxFilesCount;
    }

    public boolean isLimitReached() {
        return this.maxSelectedFilesReached;
    }

    public void setLimitReached(boolean limitReached) {
        this.maxSelectedFilesReached = limitReached;
    }

    public List<UIAbstractSelectFileComposer> getUIFileSelectors() {
        return this.uiFileSelectors;
    }

    public void deActivate() {
        UIPopupWindow popup = (UIPopupWindow)this.getParent();
        popup.setUIComponent(null);
        popup.setShow(false);
        popup.setRendered(false);
        ((WebuiRequestContext)WebuiRequestContext.getCurrentInstance()).addUIComponentToUpdateByAjax(popup.getParent());
    }

    public static class SelectedFileActionListener
    extends EventListener<UIDocActivityPopup> {
        public void execute(Event<UIDocActivityPopup> event) throws Exception {
            UIDocActivityPopup uiDocActivityPopup = (UIDocActivityPopup)((Object)event.getSource());
            UIPortletApplication uiApp = (UIPortletApplication)uiDocActivityPopup.getAncestorOfType(UIPortletApplication.class);
            List<UIAbstractSelectFileComposer> uiFileSelectors = uiDocActivityPopup.getUIFileSelectors();
            HashSet<ComposerFileItem> selectedFileItems = new HashSet<ComposerFileItem>();
            for (UIAbstractSelectFileComposer uiSelectFileComposer : uiFileSelectors) {
                uiSelectFileComposer.validateSelection();
                if (!uiSelectFileComposer.isRendered() || uiSelectFileComposer.getSelectFiles() == null || uiSelectFileComposer.getSelectFiles().isEmpty()) continue;
                selectedFileItems.addAll(uiSelectFileComposer.getSelectFiles());
                uiSelectFileComposer.resetSelection();
            }
            if (!selectedFileItems.isEmpty()) {
                UIComposer uiComposer = (UIComposer)uiApp.findFirstComponentOfType(UIComposer.class);
                UIDocActivityComposer uiDocActivityComposer = (UIDocActivityComposer)uiComposer.findFirstComponentOfType(UIDocActivityComposer.class);
                uiDocActivityPopup.deActivate();
                uiDocActivityComposer.doSelect("FILE_ITEMS", selectedFileItems);
                event.getRequestContext().addUIComponentToUpdateByAjax(uiDocActivityComposer.getParent());
            }
        }
    }

    public static class CancelActionListener
    extends EventListener<UIDocActivityPopup> {
        public void execute(Event<UIDocActivityPopup> event) throws Exception {
            UIDocActivityPopup docActivityPopup = (UIDocActivityPopup)((Object)event.getSource());
            docActivityPopup.uiDocumentSelector.resetSelection();
            docActivityPopup.deActivate();
        }
    }
}

