/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.clv;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.views.ApplicationTemplateManagerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.clv.UICLVPortlet;
import org.exoplatform.wcm.webui.reader.ContentReader;
import org.exoplatform.wcm.webui.selector.content.folder.UIContentBrowsePanelFolder;
import org.exoplatform.wcm.webui.selector.content.folder.UIContentSelectorFolder;
import org.exoplatform.wcm.webui.selector.content.multi.UIContentBrowsePanelMulti;
import org.exoplatform.wcm.webui.selector.content.multi.UIContentSelectorMulti;
import org.exoplatform.wcm.webui.selector.page.UIPageSelector;
import org.exoplatform.wcm.webui.validator.ZeroNumberValidator;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormRadioBoxInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTabPane;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.ext.UIFormInputSetWithAction;
import org.exoplatform.webui.form.input.UICheckBoxInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.PositiveNumberFormatValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/ContentListViewer/UICLVConfig.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddPathActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={IncreaseActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={DecreaseActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectTargetPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectTabActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ShowAdvancedBlockActionListener.class}, phase=Event.Phase.DECODE)})
public class UICLVConfig
extends UIFormTabPane
implements UISelectable {
    public static final String CONTENT_TAB = "clvContentTab";
    public static final String DISPLAY_TAB = "clvDisplayTab";
    public static final String ADVANCED_TAB = "clvAdvancedTab";
    private static final Log LOG = ExoLogger.getLogger((String)UICLVConfig.class.getName());
    public static final String DISPLAY_MODE_FORM_RADIO_BOX_INPUT = "UICLVConfigDisplayModeFormRadioBoxInput";
    public static final String ITEM_PATH_FORM_INPUT_SET = "UICLVConfigItemPathFormInputSet";
    public static final String ITEM_PATH_FORM_STRING_INPUT = "UICLVConfigItemPathFormStringInput";
    public static final String ORDER_BY_FORM_SELECT_BOX = "UICLVConfigOrderByFormSelectBox";
    public static final String ORDER_TYPE_FORM_SELECT_BOX = "UICLVConfigOrderTypeFormSelectBox";
    public static final String ORDER_TYPE_FORM_RADIO_BOX_INPUT = "UICLVConfigOrderTypeFormRadioBoxInput";
    public static final String HEADER_FORM_STRING_INPUT = "UICLVConfigHeaderFormStringInput";
    public static final String SHOW_AUTOMATIC_DETECTION_CHECKBOX_INPUT = "UICLVConfigShowAutomaticDetectionCheckboxInput";
    public static final String DISPLAY_TEMPLATE_FORM_SELECT_BOX = "UICLVConfigDisplayTemplateFormSelectBox";
    public static final String PAGINATOR_TEMPLATE_FORM_SELECT_BOX = "UICLVConfigPaginatorTemplateFormSelectBox";
    public static final String ITEMS_PER_PAGE_FORM_STRING_INPUT = "UICLVConfigItemsPerPageFormStringInput";
    public static final String SHOW_TITLE_FORM_CHECKBOX_INPUT = "UICLVConfigShowTitleFormCheckboxInput";
    public static final String SHOW_HEADER_FORM_CHECKBOX_INPUT = "UICLVConfigShowHeaderFormCheckboxInput";
    public static final String SHOW_REFRESH_FORM_CHECKBOX_INPUT = "UICLVConfigShowRefreshFormCheckboxInput";
    public static final String SHOW_ILLUSTRATION_FORM_CHECKBOX_INPUT = "UICLVConfigShowIllustrationFormCheckboxInput";
    public static final String SHOW_DATE_CREATED_FORM_CHECKBOX_INPUT = "UICLVConfigShowDateCreatedFormCheckboxInput";
    public static final String SHOW_READMORE_FORM_CHECKBOX_INPUT = "UICLVConfigShowReadmoreFormCheckboxInput";
    public static final String SHOW_SUMMARY_FORM_CHECKBOX_INPUT = "UICLVConfigShowSummaryFormCheckboxInput";
    public static final String SHOW_LINK_FORM_CHECKBOX_INPUT = "UICLVConfigShowLinkFormCheckboxInput";
    public static final String SHOW_RSSLINK_FORM_CHECKBOX_INPUT = "UICLVConfigShowRssLinkFormCheckboxInput";
    public static final String TARGET_PAGE_FORM_INPUT_SET = "UICLVConfigTargetPageFormInputSet";
    public static final String TARGET_PAGE_FORM_STRING_INPUT = "UICLVConfigTargetPageFormStringInput";
    public static final String TARGET_PAGE_SELECTOR_POPUP_WINDOW = "UICLVConfigTargetPageSelectorPopupWindow";
    public static final String DYNAMIC_NAVIGATION_LABEL = "UICLVConfigDynamicNavigationLabel";
    public static final String CONTEXTUAL_FOLDER_RADIOBOX_INPUT = "UICLVConfigContextualFolderRadioBoxInput";
    public static final String SHOW_CLV_BY_STRING_INPUT = "UICLVConfigShowCLVByStringInput";
    public static final String SHOW_SCV_WITH_STRING_INPUT = "UICLVConfigshowSCVWithStringInput";
    public static final String PAGINATOR_TEMPLATE_CATEGORY = "paginators";
    public static final String CACHE_ENABLE_RADIOBOX_INPUT = "UICLVConfigCacheEnableRadioBoxInput";
    public static final String CONTENT_BY_QUERY_TEXT_AREA = "UICLVConfigContentByQueryTextArea";
    public static final String WORKSPACE_FORM_SELECT_BOX = "UICLVConfigWorkspaceFormSelectBox";
    public static final String CACHE_MANAGEMENT_LABEL = "UICLVConfigCacheManagementLabel";
    public static final String CONTENT_BY_QUERY_LABEL = "UICLVContentByQueryLabel";
    public static final String DISPLAY_TEMPLATE_CATEGORY = "navigation";
    public static final String DISPLAY_TEMPLATE_LIST = "list";
    public static final String TEMPLATE_STORAGE_FOLDER = "content-list-viewer";
    public static final String CONTENT_LIST_TYPE = "ContentList";
    public static final String CATEGORIES_CONTENT_TYPE = "CategoryContents";
    public static final String CATOGORIES_NAVIGATION_TYPE = "CategoryNavigation";
    public static final String ENABLE_CACHE = "ENABLE";
    public static final String DISABLE_CACHE = "DISABLE";
    private String popupId;
    private List<String> items;
    private String savedPath;
    private boolean isShowAdvancedBlock_;
    private String appType;
    private String driveName_;
    private boolean modeInternal = false;

    public void setSavedPath(String value) {
        this.savedPath = value;
    }

    public String getSavedPath() {
        return this.savedPath;
    }

    public String getAliveSavedPath() {
        if (this.savedPath != null && !this.savedPath.isEmpty()) {
            List<Object> tmpItems = new ArrayList<String>();
            StringBuffer itemsBuffer = new StringBuffer();
            if (this.savedPath.contains(";")) {
                tmpItems = Arrays.asList(this.savedPath.split(";"));
            } else {
                tmpItems.add(this.savedPath);
            }
            for (String string : tmpItems) {
                try {
                    if (this.getRealNode(string) == null) continue;
                    itemsBuffer.append(string).append(";");
                }
                catch (RepositoryException e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)e.getMessage());
                }
            }
            return itemsBuffer.toString();
        }
        return this.savedPath;
    }

    public String getPopupId() {
        return this.popupId;
    }

    public void setPopupId(String popupId) {
        this.popupId = popupId;
    }

    public void setDriveName(String value) {
        this.driveName_ = value;
    }

    public String getDriveName() {
        return this.driveName_;
    }

    public List<String> getItems() {
        String displayMode = (String)((UIFormRadioBoxInput)this.findComponentById(DISPLAY_MODE_FORM_RADIO_BOX_INPUT)).getValue();
        String itemPath = Utils.getPortletPreference((String)"folderPath");
        if (this.items == null && "ManualViewerMode".equals(displayMode) && itemPath != null && itemPath.contains(";")) {
            List<String> tmpItems = Arrays.asList(itemPath.split(";"));
            this.items = new ArrayList<String>();
            for (String item : tmpItems) {
                try {
                    Node realNode = this.getRealNode(item);
                    if (realNode == null) continue;
                    this.items.add(item);
                }
                catch (RepositoryException e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)e.getMessage());
                }
            }
        }
        return this.items;
    }

    public void setItems(List<String> items) {
        this.items = items;
    }

    public boolean isShowAdvancedBlock() {
        return this.isShowAdvancedBlock_;
    }

    public void setIsShowAdvancedBlock(boolean value) {
        this.isShowAdvancedBlock_ = value;
    }

    public UICLVConfig() throws Exception {
        super("UICLVConfig");
        String[] workspaceList;
        String itemPath;
        PortletPreferences portletPreferences = ((PortletRequestContext)WebuiRequestContext.getCurrentInstance()).getRequest().getPreferences();
        this.appType = portletPreferences.getValue("application", null);
        String displayMode = portletPreferences.getValue("mode", null);
        this.savedPath = itemPath = portletPreferences.getValue("folderPath", null);
        itemPath = this.getTitles(this.savedPath);
        this.setDriveName(portletPreferences.getValue("nodeDrive", null));
        String orderBy = portletPreferences.getValue("orderBy", null);
        String orderType = portletPreferences.getValue("orderType", null);
        String header = portletPreferences.getValue("header", null);
        String displayTemplate = portletPreferences.getValue("formViewTemplatePath", null);
        String paginatorTemplate = portletPreferences.getValue("paginatorTemplatePath", null);
        String itemsPerPage = portletPreferences.getValue("itemsPerPage", null);
        String contextualFolderMode = portletPreferences.getValue("contextualFolder", null);
        String showClvBy = portletPreferences.getValue("showClvBy", null);
        String targetPage = portletPreferences.getValue("basePath", null);
        String showScvWith = portletPreferences.getValue("showScvWith", null);
        String isCacheEnabled = portletPreferences.getValue("sharedCache", null);
        String workspace = portletPreferences.getValue("workspace", null);
        String contentByQuery = portletPreferences.getValue("query", null);
        boolean showAutomaticDetection = Boolean.parseBoolean(portletPreferences.getValue("automaticDetection", null));
        boolean showTitle = Boolean.parseBoolean(portletPreferences.getValue("showTitle", null));
        boolean showHeader = Boolean.parseBoolean(portletPreferences.getValue("showHeader", null));
        boolean showRefresh = Boolean.parseBoolean(portletPreferences.getValue("showRefreshButton", null));
        boolean showImage = Boolean.parseBoolean(portletPreferences.getValue("showThumbnailsView", null));
        boolean showDateCreated = Boolean.parseBoolean(portletPreferences.getValue("showDateCreated", null));
        boolean showReadmore = Boolean.parseBoolean(portletPreferences.getValue("showReadmore", null));
        boolean showSummary = Boolean.parseBoolean(portletPreferences.getValue("showSummary", null));
        boolean showLink = Boolean.parseBoolean(portletPreferences.getValue("showLink", null));
        boolean showRssLink = Boolean.parseBoolean(portletPreferences.getValue("showRssLink", null));
        ArrayList<SelectItemOption> displayModeOptions = new ArrayList<SelectItemOption>();
        displayModeOptions.add(new SelectItemOption("AutoViewerMode", (Object)"AutoViewerMode"));
        displayModeOptions.add(new SelectItemOption("ManualViewerMode", (Object)"ManualViewerMode"));
        UIFormRadioBoxInput displayModeRadioBoxInput = new UIFormRadioBoxInput(DISPLAY_MODE_FORM_RADIO_BOX_INPUT, DISPLAY_MODE_FORM_RADIO_BOX_INPUT, displayModeOptions);
        displayModeRadioBoxInput.setValue((Object)displayMode);
        UIFormStringInput itemPathInput = new UIFormStringInput(ITEM_PATH_FORM_STRING_INPUT, ITEM_PATH_FORM_STRING_INPUT, itemPath);
        itemPathInput.setReadOnly(true);
        itemPathInput.addValidator(MandatoryValidator.class, new Object[0]);
        UIFormInputSetWithAction itemPathInputSet = new UIFormInputSetWithAction(ITEM_PATH_FORM_INPUT_SET);
        itemPathInputSet.setActionInfo(ITEM_PATH_FORM_STRING_INPUT, new String[]{"AddPath"});
        itemPathInputSet.addUIFormInput((UIFormInput)itemPathInput);
        ArrayList<SelectItemOption> orderByOptions = new ArrayList<SelectItemOption>();
        orderByOptions.add(new SelectItemOption("OrderByTitle", (Object)"exo:title"));
        orderByOptions.add(new SelectItemOption("OrderByDateCreated", (Object)"exo:dateCreated"));
        orderByOptions.add(new SelectItemOption("OrderByDateModified", (Object)"exo:lastModifiedDate"));
        orderByOptions.add(new SelectItemOption("OrderByDatePublished", (Object)"publication:liveDate"));
        orderByOptions.add(new SelectItemOption("OrderByDateStartEvent", (Object)"exo:startEvent"));
        orderByOptions.add(new SelectItemOption("OrderByIndex", (Object)"exo:index"));
        UIFormSelectBox orderBySelectBox = new UIFormSelectBox(ORDER_BY_FORM_SELECT_BOX, ORDER_BY_FORM_SELECT_BOX, orderByOptions);
        orderBySelectBox.setValue(orderBy);
        ArrayList<SelectItemOption> orderTypeOptions = new ArrayList<SelectItemOption>();
        orderTypeOptions.add(new SelectItemOption("OrderDesc", (Object)"DESC"));
        orderTypeOptions.add(new SelectItemOption("OrderAsc", (Object)"ASC"));
        UIFormRadioBoxInput orderTypeRadioBoxInput = new UIFormRadioBoxInput(ORDER_TYPE_FORM_RADIO_BOX_INPUT, ORDER_TYPE_FORM_RADIO_BOX_INPUT, orderTypeOptions);
        UIFormSelectBox orderTypeSelectBox = new UIFormSelectBox(ORDER_TYPE_FORM_SELECT_BOX, ORDER_TYPE_FORM_SELECT_BOX, orderTypeOptions);
        orderTypeSelectBox.setValue(orderType);
        UIFormStringInput headerInput = new UIFormStringInput(HEADER_FORM_STRING_INPUT, HEADER_FORM_STRING_INPUT, header);
        UICheckBoxInput showAutomaticDetectionCheckBox = new UICheckBoxInput(SHOW_AUTOMATIC_DETECTION_CHECKBOX_INPUT, SHOW_AUTOMATIC_DETECTION_CHECKBOX_INPUT, null);
        showAutomaticDetectionCheckBox.setChecked(showAutomaticDetection);
        ArrayList formViewerTemplateList = new ArrayList();
        ArrayList<SelectItemOption<String>> viewerTemplateList = new ArrayList<SelectItemOption<String>>();
        if (this.appType.equals(CONTENT_LIST_TYPE) || this.appType.equals(CATEGORIES_CONTENT_TYPE) || this.appType.equals("ContentsByQuery")) {
            viewerTemplateList.addAll(this.getTemplateList(TEMPLATE_STORAGE_FOLDER, DISPLAY_TEMPLATE_LIST));
        }
        if (this.appType.equals(CONTENT_LIST_TYPE) || this.appType.equals(CATOGORIES_NAVIGATION_TYPE)) {
            viewerTemplateList.addAll(this.getTemplateList(TEMPLATE_STORAGE_FOLDER, DISPLAY_TEMPLATE_CATEGORY));
        }
        Collections.sort(viewerTemplateList, new TemplateNameComparator());
        formViewerTemplateList.addAll(viewerTemplateList);
        UIFormSelectBox formViewTemplateSelector = new UIFormSelectBox(DISPLAY_TEMPLATE_FORM_SELECT_BOX, DISPLAY_TEMPLATE_FORM_SELECT_BOX, formViewerTemplateList);
        formViewTemplateSelector.setValue(displayTemplate);
        List<SelectItemOption<String>> paginatorTemplateList = this.getTemplateList(TEMPLATE_STORAGE_FOLDER, PAGINATOR_TEMPLATE_CATEGORY);
        Collections.sort(paginatorTemplateList, new TemplateNameComparator());
        UIFormSelectBox paginatorTemplateSelector = new UIFormSelectBox(PAGINATOR_TEMPLATE_FORM_SELECT_BOX, PAGINATOR_TEMPLATE_FORM_SELECT_BOX, paginatorTemplateList);
        paginatorTemplateSelector.setValue(paginatorTemplate);
        UIFormStringInput itemsPerPageStringInput = new UIFormStringInput(ITEMS_PER_PAGE_FORM_STRING_INPUT, ITEMS_PER_PAGE_FORM_STRING_INPUT, itemsPerPage);
        itemsPerPageStringInput.addValidator(MandatoryValidator.class, new Object[0]);
        itemsPerPageStringInput.addValidator(ZeroNumberValidator.class, new Object[0]);
        itemsPerPageStringInput.addValidator(PositiveNumberFormatValidator.class, new Object[0]);
        itemsPerPageStringInput.setMaxLength(3);
        UICheckBoxInput showTitleCheckbox = new UICheckBoxInput(SHOW_TITLE_FORM_CHECKBOX_INPUT, SHOW_TITLE_FORM_CHECKBOX_INPUT, null);
        showTitleCheckbox.setChecked(showTitle);
        UICheckBoxInput showHeaderCheckBox = new UICheckBoxInput(SHOW_HEADER_FORM_CHECKBOX_INPUT, SHOW_HEADER_FORM_CHECKBOX_INPUT, null);
        showHeaderCheckBox.setChecked(showHeader);
        UICheckBoxInput showRefreshCheckbox = new UICheckBoxInput(SHOW_REFRESH_FORM_CHECKBOX_INPUT, SHOW_REFRESH_FORM_CHECKBOX_INPUT, null);
        showRefreshCheckbox.setChecked(showRefresh);
        UICheckBoxInput showImageCheckbox = new UICheckBoxInput(SHOW_ILLUSTRATION_FORM_CHECKBOX_INPUT, SHOW_ILLUSTRATION_FORM_CHECKBOX_INPUT, null);
        showImageCheckbox.setChecked(showImage);
        UICheckBoxInput showDateCreatedCheckbox = new UICheckBoxInput(SHOW_DATE_CREATED_FORM_CHECKBOX_INPUT, SHOW_DATE_CREATED_FORM_CHECKBOX_INPUT, null);
        showDateCreatedCheckbox.setChecked(showDateCreated);
        UICheckBoxInput showMoreLinkCheckbox = new UICheckBoxInput(SHOW_READMORE_FORM_CHECKBOX_INPUT, SHOW_READMORE_FORM_CHECKBOX_INPUT, null);
        showMoreLinkCheckbox.setChecked(showReadmore);
        UICheckBoxInput showSummaryCheckbox = new UICheckBoxInput(SHOW_SUMMARY_FORM_CHECKBOX_INPUT, SHOW_SUMMARY_FORM_CHECKBOX_INPUT, null);
        showSummaryCheckbox.setChecked(showSummary);
        UICheckBoxInput showLinkCheckbox = new UICheckBoxInput(SHOW_LINK_FORM_CHECKBOX_INPUT, SHOW_LINK_FORM_CHECKBOX_INPUT, null);
        showLinkCheckbox.setChecked(showLink);
        UICheckBoxInput showRssLinkCheckbox = new UICheckBoxInput(SHOW_RSSLINK_FORM_CHECKBOX_INPUT, SHOW_RSSLINK_FORM_CHECKBOX_INPUT, null);
        showRssLinkCheckbox.setChecked(showRssLink);
        ArrayList<SelectItemOption> contextualFolderOptions = new ArrayList<SelectItemOption>();
        contextualFolderOptions.add(new SelectItemOption("contextualEnable", (Object)"contextualEnable"));
        contextualFolderOptions.add(new SelectItemOption("contextualDisable", (Object)"contextualDisable"));
        UIFormRadioBoxInput contextualFolderRadioBoxInput = new UIFormRadioBoxInput(CONTEXTUAL_FOLDER_RADIOBOX_INPUT, CONTEXTUAL_FOLDER_RADIOBOX_INPUT, contextualFolderOptions);
        contextualFolderRadioBoxInput.setValue((Object)contextualFolderMode);
        UIFormStringInput showClvByInput = new UIFormStringInput(SHOW_CLV_BY_STRING_INPUT, SHOW_CLV_BY_STRING_INPUT, showClvBy);
        UIFormInputSetWithAction targetPageInputSet = new UIFormInputSetWithAction(TARGET_PAGE_FORM_INPUT_SET);
        UIFormStringInput basePathInput = new UIFormStringInput(TARGET_PAGE_FORM_STRING_INPUT, TARGET_PAGE_FORM_STRING_INPUT, targetPage);
        basePathInput.setValue((Object)targetPage);
        basePathInput.setReadOnly(true);
        targetPageInputSet.setActionInfo(TARGET_PAGE_FORM_STRING_INPUT, new String[]{"SelectTargetPage"});
        targetPageInputSet.addUIFormInput((UIFormInput)basePathInput);
        ArrayList<SelectItemOption> cacheOptions = new ArrayList<SelectItemOption>();
        cacheOptions.add(new SelectItemOption(ENABLE_CACHE, (Object)ENABLE_CACHE));
        cacheOptions.add(new SelectItemOption(DISABLE_CACHE, (Object)DISABLE_CACHE));
        UIFormRadioBoxInput cacheEnableRadioBoxInput = new UIFormRadioBoxInput(CACHE_ENABLE_RADIOBOX_INPUT, CACHE_ENABLE_RADIOBOX_INPUT, cacheOptions);
        cacheEnableRadioBoxInput.setValue((Object)("true".equals(isCacheEnabled) ? ENABLE_CACHE : DISABLE_CACHE));
        ArrayList<SelectItemOption> workspaceOptions = new ArrayList<SelectItemOption>();
        for (String wkspace : workspaceList = WCMCoreUtils.getRepository().getWorkspaceNames()) {
            workspaceOptions.add(new SelectItemOption(wkspace, (Object)wkspace));
        }
        UIFormSelectBox workspaceSelector = new UIFormSelectBox(WORKSPACE_FORM_SELECT_BOX, WORKSPACE_FORM_SELECT_BOX, workspaceOptions);
        workspaceSelector.setValue(workspace);
        UIFormTextAreaInput queryTextAreaInput = new UIFormTextAreaInput(CONTENT_BY_QUERY_TEXT_AREA, CONTENT_BY_QUERY_TEXT_AREA, contentByQuery);
        UIFormStringInput showScvWithInput = new UIFormStringInput(SHOW_SCV_WITH_STRING_INPUT, SHOW_SCV_WITH_STRING_INPUT, showScvWith);
        if (this.appType.equals(CATOGORIES_NAVIGATION_TYPE)) {
            displayModeRadioBoxInput.setDisabled(true);
            showAutomaticDetectionCheckBox.setDisabled(true);
            showImageCheckbox.setDisabled(true);
            showSummaryCheckbox.setDisabled(true);
            showDateCreatedCheckbox.setDisabled(true);
            showLinkCheckbox.setDisabled(true);
            showRefreshCheckbox.setDisabled(true);
            showMoreLinkCheckbox.setDisabled(true);
            showRssLinkCheckbox.setDisabled(true);
            showScvWithInput.setDisabled(true);
        }
        UIFormInputSet uiCLVContentTab = new UIFormInputSet(CONTENT_TAB);
        uiCLVContentTab.addUIFormInput((UIFormInput)displayModeRadioBoxInput);
        uiCLVContentTab.addUIFormInput((UIFormInputSet)itemPathInputSet);
        uiCLVContentTab.addUIFormInput((UIFormInput)orderBySelectBox);
        uiCLVContentTab.addUIFormInput((UIFormInput)orderTypeSelectBox);
        uiCLVContentTab.addUIFormInput((UIFormInput)orderTypeRadioBoxInput);
        this.setSelectedTab(CONTENT_TAB);
        this.addUIComponentInput((UIComponent)uiCLVContentTab);
        UIFormInputSet uiCLVDisplayTab = new UIFormInputSet(DISPLAY_TAB);
        uiCLVDisplayTab.addUIFormInput((UIFormInput)headerInput);
        uiCLVDisplayTab.addUIFormInput((UIFormInput)showAutomaticDetectionCheckBox);
        uiCLVDisplayTab.addUIFormInput((UIFormInput)formViewTemplateSelector);
        uiCLVDisplayTab.addUIFormInput((UIFormInput)paginatorTemplateSelector);
        uiCLVDisplayTab.addUIFormInput((UIFormInput)itemsPerPageStringInput);
        uiCLVDisplayTab.addUIFormInput((UIFormInput)showTitleCheckbox);
        uiCLVDisplayTab.addUIFormInput((UIFormInput)showHeaderCheckBox);
        uiCLVDisplayTab.addUIFormInput((UIFormInput)showRefreshCheckbox);
        uiCLVDisplayTab.addUIFormInput((UIFormInput)showImageCheckbox);
        uiCLVDisplayTab.addUIFormInput((UIFormInput)showDateCreatedCheckbox);
        uiCLVDisplayTab.addUIFormInput((UIFormInput)showMoreLinkCheckbox);
        uiCLVDisplayTab.addUIFormInput((UIFormInput)showSummaryCheckbox);
        uiCLVDisplayTab.addUIFormInput((UIFormInput)showLinkCheckbox);
        uiCLVDisplayTab.addUIFormInput((UIFormInput)showRssLinkCheckbox);
        this.addUIComponentInput((UIComponent)uiCLVDisplayTab);
        UIFormInputSet uiCLVAdvancedTab = new UIFormInputSet(ADVANCED_TAB);
        uiCLVAdvancedTab.addUIFormInput((UIFormInput)contextualFolderRadioBoxInput);
        uiCLVAdvancedTab.addUIFormInput((UIFormInput)showClvByInput);
        uiCLVAdvancedTab.addUIFormInput((UIFormInputSet)targetPageInputSet);
        uiCLVAdvancedTab.addUIFormInput((UIFormInput)showScvWithInput);
        uiCLVAdvancedTab.addUIFormInput((UIFormInput)cacheEnableRadioBoxInput);
        if (this.isContentListByQuery()) {
            uiCLVAdvancedTab.addUIFormInput((UIFormInput)workspaceSelector);
            uiCLVAdvancedTab.addUIFormInput((UIFormInput)queryTextAreaInput);
        }
        this.addUIComponentInput((UIComponent)uiCLVAdvancedTab);
        this.isShowAdvancedBlock_ = contextualFolderMode != null && contextualFolderMode.equals("contextualEnable") || this.isContentListByQuery();
        this.setActions(new String[]{"Save", "Cancel"});
    }

    private List<SelectItemOption<String>> getTemplateList(String portletName, String category) throws Exception {
        ArrayList<SelectItemOption<String>> templateOptionList = new ArrayList<SelectItemOption<String>>();
        ApplicationTemplateManagerService templateManagerService = (ApplicationTemplateManagerService)this.getApplicationComponent(ApplicationTemplateManagerService.class);
        List templateNodeList = templateManagerService.getTemplatesByCategory(portletName, category, WCMCoreUtils.getSystemSessionProvider());
        for (Node templateNode : templateNodeList) {
            SelectItemOption template = new SelectItemOption();
            template.setLabel(templateNode.getName());
            template.setValue((Object)templateNode.getPath());
            templateOptionList.add((SelectItemOption<String>)template);
        }
        return templateOptionList;
    }

    public boolean isCategoriesNavigation() {
        return this.appType.equals(CATOGORIES_NAVIGATION_TYPE);
    }

    public boolean isContentListByQuery() {
        return this.appType.equals("ContentsByQuery");
    }

    public void doSelect(String selectField, Object value) throws Exception {
        if (selectField != null && value != null) {
            String sValue = (String)value;
            String titles = "";
            String displayMode = (String)((UIFormRadioBoxInput)this.findComponentById(DISPLAY_MODE_FORM_RADIO_BOX_INPUT)).getValue();
            if (ITEM_PATH_FORM_STRING_INPUT.equals(selectField) && "ManualViewerMode".equals(displayMode)) {
                this.items = Arrays.asList(sValue.split(";"));
                titles = this.getTitles(sValue);
                this.savedPath = sValue;
                this.getUIStringInput(selectField).setValue((Object)titles);
            } else if (TARGET_PAGE_FORM_STRING_INPUT.equals(selectField)) {
                this.getUIStringInput(selectField).setValue((Object)sValue);
            } else {
                this.items = new ArrayList<String>();
                String[] values = sValue.split(":");
                if (values.length == 4) {
                    this.setDriveName(values[0]);
                    ManageDriveService managerDriveService = (ManageDriveService)this.getApplicationComponent(ManageDriveService.class);
                    for (DriveData data : managerDriveService.getAllDrives()) {
                        if (!data.getHomePath().equals(values[3])) continue;
                        this.setDriveName(data.getName());
                    }
                    sValue = sValue.substring(values[0].length() + 1);
                }
                titles = this.getTitle(sValue);
                this.getUIStringInput(selectField).setValue((Object)titles);
                this.savedPath = sValue;
            }
        }
        Utils.closePopupWindow((UIContainer)this, (String)this.popupId);
    }

    private String getTitles(String itemPath) throws RepositoryException {
        if (itemPath == null || itemPath.length() == 0) {
            return "";
        }
        StringBuffer titles = new StringBuffer();
        List<String> tmpItems = Arrays.asList(itemPath.split(";"));
        for (String item : tmpItems) {
            String title = this.getTitle(item);
            if (title == null) continue;
            if (titles.length() > 0) {
                titles.append(";").append(title);
                continue;
            }
            titles.append(title);
        }
        return titles.toString();
    }

    private Node getRealNode(String itemPath) throws RepositoryException {
        if (itemPath == null || itemPath.length() == 0) {
            return null;
        }
        int repoIndex = itemPath.indexOf(58);
        int wsIndex = itemPath.lastIndexOf(58);
        String strRepository = itemPath.substring(0, repoIndex);
        String strWorkspace = itemPath.substring(repoIndex + 1, wsIndex);
        String strIdentifier = itemPath.substring(wsIndex + 1);
        Node selectedNode = Utils.getRealNode((String)Text.escapeIllegalJcrChars((String)strRepository), (String)Text.escapeIllegalJcrChars((String)strWorkspace), (String)Text.escapeIllegalJcrChars((String)strIdentifier), (boolean)false);
        return selectedNode;
    }

    private String getTitle(String itemPath) throws RepositoryException {
        Node content;
        Node selectedNode = this.getRealNode(itemPath);
        if (selectedNode == null) {
            return null;
        }
        String title = null;
        if (selectedNode.hasProperty("exo:title")) {
            title = selectedNode.getProperty("exo:title").getValue().getString();
        }
        if (selectedNode.hasNode("jcr:content") && (content = selectedNode.getNode("jcr:content")).hasProperty("dc:title")) {
            try {
                title = content.getProperty("dc:title").getValues()[0].getString();
            }
            catch (PathNotFoundException e) {
                title = null;
            }
            catch (RepositoryException e) {
                title = null;
            }
            catch (IndexOutOfBoundsException e) {
                title = null;
            }
        }
        if (title == null) {
            title = selectedNode.getName();
        }
        return ContentReader.getUnescapeIllegalJcrContent((String)title);
    }

    public void setModeInternal(boolean value) {
        this.modeInternal = value;
    }

    public boolean getModeInternal() {
        return this.modeInternal;
    }

    private class TemplateNameComparator
    implements Comparator<SelectItemOption<String>> {
        private TemplateNameComparator() {
        }

        @Override
        public int compare(SelectItemOption<String> item1, SelectItemOption<String> item2) {
            String s1 = item1.getLabel().toLowerCase();
            String s2 = item2.getLabel().toLowerCase();
            return s1.compareTo(s2);
        }
    }

    public static class ShowAdvancedBlockActionListener
    extends EventListener<UICLVConfig> {
        public void execute(Event<UICLVConfig> event) throws Exception {
            UICLVConfig clvConfig = (UICLVConfig)((Object)event.getSource());
            String showValue = event.getRequestContext().getRequestParameter("objectId");
            clvConfig.isShowAdvancedBlock_ = "true".equalsIgnoreCase(showValue);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)clvConfig);
        }
    }

    public static class SelectTargetPageActionListener
    extends EventListener<UICLVConfig> {
        public void execute(Event<UICLVConfig> event) throws Exception {
            UICLVConfig viewerManagementForm = (UICLVConfig)((Object)event.getSource());
            UIPageSelector pageSelector = (UIPageSelector)viewerManagementForm.createUIComponent(UIPageSelector.class, null, null);
            pageSelector.setSourceComponent((UIComponent)viewerManagementForm, new String[]{UICLVConfig.TARGET_PAGE_FORM_STRING_INPUT});
            Utils.createPopupWindow((UIContainer)viewerManagementForm, (UIComponent)pageSelector, (String)UICLVConfig.TARGET_PAGE_SELECTOR_POPUP_WINDOW, (int)800);
            viewerManagementForm.setPopupId(UICLVConfig.TARGET_PAGE_SELECTOR_POPUP_WINDOW);
        }
    }

    public static class DecreaseActionListener
    extends EventListener<UICLVConfig> {
        public void execute(Event<UICLVConfig> event) throws Exception {
            UICLVConfig clvConfig = (UICLVConfig)((Object)event.getSource());
            List items = clvConfig.items;
            int offset = Integer.parseInt(event.getRequestContext().getRequestParameter("objectId"));
            if (offset < items.size() - 1) {
                String temp = (String)items.get(offset + 1);
                items.set(offset + 1, items.get(offset));
                items.set(offset, temp);
            }
            StringBuffer sb = new StringBuffer("");
            for (String item : items) {
                sb.append(item).append(";");
            }
            String itemPath = sb.toString();
            clvConfig.getUIStringInput(UICLVConfig.ITEM_PATH_FORM_STRING_INPUT).setValue((Object)clvConfig.getTitles(itemPath));
            clvConfig.setSavedPath(itemPath);
        }
    }

    public static class IncreaseActionListener
    extends EventListener<UICLVConfig> {
        public void execute(Event<UICLVConfig> event) throws Exception {
            UICLVConfig clvConfig = (UICLVConfig)((Object)event.getSource());
            List items = clvConfig.items;
            int offset = Integer.parseInt(event.getRequestContext().getRequestParameter("objectId"));
            if (offset > 0) {
                String temp = (String)items.get(offset - 1);
                items.set(offset - 1, items.get(offset));
                items.set(offset, temp);
            }
            StringBuffer sb = new StringBuffer("");
            for (String item : items) {
                sb.append(item).append(";");
            }
            String itemPath = sb.toString();
            clvConfig.getUIStringInput(UICLVConfig.ITEM_PATH_FORM_STRING_INPUT).setValue((Object)clvConfig.getTitles(itemPath));
            clvConfig.setSavedPath(itemPath);
        }
    }

    public static class AddPathActionListener
    extends EventListener<UICLVConfig> {
        public void execute(Event<UICLVConfig> event) throws Exception {
            UICLVConfig clvConfig = (UICLVConfig)((Object)event.getSource());
            UIFormRadioBoxInput modeBoxInput = (UIFormRadioBoxInput)clvConfig.findComponentById(UICLVConfig.DISPLAY_MODE_FORM_RADIO_BOX_INPUT);
            String mode = (String)modeBoxInput.getValue();
            if (mode.equals("AutoViewerMode")) {
                UIContentSelectorFolder contentSelector = (UIContentSelectorFolder)clvConfig.createUIComponent(UIContentSelectorFolder.class, null, null);
                UIContentBrowsePanelFolder folderContentSelector = (UIContentBrowsePanelFolder)contentSelector.getChild(UIContentBrowsePanelFolder.class);
                String location = clvConfig.getSavedPath();
                String[] locations = location == null ? null : location.split(":");
                Node node = locations != null && locations.length >= 3 ? Utils.getViewableNodeByComposer((String)locations[0], (String)locations[1], (String)locations[2]) : null;
                contentSelector.init(clvConfig.getDriveName(), this.fixPath(node == null ? "" : node.getPath(), clvConfig, locations != null && locations.length > 0 ? locations[0] : null));
                folderContentSelector.setSourceComponent((UIComponent)clvConfig, new String[]{UICLVConfig.ITEM_PATH_FORM_STRING_INPUT});
                Utils.createPopupWindow((UIContainer)clvConfig, (UIComponent)contentSelector, (String)"FolderPathSelectorPopupWindow", (int)800);
                clvConfig.setPopupId("FolderPathSelectorPopupWindow");
            } else {
                UIContentSelectorMulti contentSelector = (UIContentSelectorMulti)clvConfig.createUIComponent(UIContentSelectorMulti.class, null, null);
                UIContentBrowsePanelMulti multiContentSelector = (UIContentBrowsePanelMulti)contentSelector.getChild(UIContentBrowsePanelMulti.class);
                multiContentSelector.setSourceComponent((UIComponent)clvConfig, new String[]{UICLVConfig.ITEM_PATH_FORM_STRING_INPUT});
                String itemPath = clvConfig.getSavedPath();
                if (itemPath != null && itemPath.contains(";")) {
                    multiContentSelector.setItemPaths(itemPath);
                }
                contentSelector.init();
                Utils.createPopupWindow((UIContainer)clvConfig, (UIComponent)contentSelector, (String)"CorrectContentSelectorPopupWindow", (int)800);
                clvConfig.setPopupId("CorrectContentSelectorPopupWindow");
            }
        }

        private String fixPath(String path, UICLVConfig clvConfig, String repository) throws Exception {
            if (path == null || path.length() == 0 || repository == null || repository.length() == 0 || clvConfig.getDriveName() == null || clvConfig.getDriveName().length() == 0) {
                return "";
            }
            ManageDriveService managerDriveService = (ManageDriveService)clvConfig.getApplicationComponent(ManageDriveService.class);
            DriveData driveData = managerDriveService.getDriveByName(clvConfig.getDriveName());
            if (!path.startsWith(driveData.getHomePath())) {
                return "";
            }
            if ("/".equals(driveData.getHomePath())) {
                return path;
            }
            return path.substring(driveData.getHomePath().length());
        }
    }

    public static class SelectTabActionListener
    extends EventListener<UICLVConfig> {
        public void execute(Event<UICLVConfig> event) throws Exception {
            WebuiRequestContext context = event.getRequestContext();
            String renderTab = context.getRequestParameter("objectId");
            if (renderTab == null) {
                return;
            }
            ((UICLVConfig)((Object)event.getSource())).setSelectedTab(renderTab);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)event.getSource());
        }
    }

    public static class CancelActionListener
    extends EventListener<UICLVConfig> {
        public void execute(Event<UICLVConfig> event) throws Exception {
            UICLVConfig clvConfig = (UICLVConfig)((Object)event.getSource());
            if (!Utils.isPortalEditMode()) {
                if (clvConfig.getModeInternal()) {
                    UICLVPortlet portlet = (UICLVPortlet)clvConfig.getAncestorOfType(UICLVPortlet.class);
                    portlet.changeToViewMode();
                } else {
                    Utils.closePopupWindow((UIContainer)clvConfig, (String)"UIViewerManagementPopupWindow");
                }
            }
        }
    }

    public static class SaveActionListener
    extends EventListener<UICLVConfig> {
        public void execute(Event<UICLVConfig> event) throws Exception {
            UICLVConfig clvConfig = (UICLVConfig)((Object)event.getSource());
            String displayMode = (String)((UIFormRadioBoxInput)clvConfig.findComponentById(UICLVConfig.DISPLAY_MODE_FORM_RADIO_BOX_INPUT)).getValue();
            String itemPath = clvConfig.getSavedPath();
            if (itemPath == null || itemPath.length() == 0 || itemPath.contains(";") && displayMode.equals("AutoViewerMode") || !itemPath.contains(";") && displayMode.equals("ManualViewerMode")) {
                Utils.createPopupMessage((UIContainer)clvConfig, (String)"UICLVConfig.msg.not-valid-path", null, (int)1);
                WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
                requestContext.addUIComponentToUpdateByAjax((UIComponent)clvConfig);
                return;
            }
            String orderBy = (String)clvConfig.getUIFormSelectBox(UICLVConfig.ORDER_BY_FORM_SELECT_BOX).getValue();
            String orderType = (String)clvConfig.getUIFormSelectBox(UICLVConfig.ORDER_TYPE_FORM_SELECT_BOX).getValue();
            String header = (String)clvConfig.getUIStringInput(UICLVConfig.HEADER_FORM_STRING_INPUT).getValue();
            if (header == null) {
                header = "";
            }
            String showAutomaticDetection = clvConfig.getUICheckBoxInput(UICLVConfig.SHOW_AUTOMATIC_DETECTION_CHECKBOX_INPUT).isChecked() ? "true" : "false";
            String displayTemplate = (String)clvConfig.getUIFormSelectBox(UICLVConfig.DISPLAY_TEMPLATE_FORM_SELECT_BOX).getValue();
            String paginatorTemplate = (String)clvConfig.getUIFormSelectBox(UICLVConfig.PAGINATOR_TEMPLATE_FORM_SELECT_BOX).getValue();
            String itemsPerPage = (String)clvConfig.getUIStringInput(UICLVConfig.ITEMS_PER_PAGE_FORM_STRING_INPUT).getValue();
            String showTitle = clvConfig.getUICheckBoxInput(UICLVConfig.SHOW_TITLE_FORM_CHECKBOX_INPUT).isChecked() ? "true" : "false";
            String showHeader = clvConfig.getUICheckBoxInput(UICLVConfig.SHOW_HEADER_FORM_CHECKBOX_INPUT).isChecked() ? "true" : "false";
            String showRefresh = clvConfig.getUICheckBoxInput(UICLVConfig.SHOW_REFRESH_FORM_CHECKBOX_INPUT).isChecked() ? "true" : "false";
            String showImage = clvConfig.getUICheckBoxInput(UICLVConfig.SHOW_ILLUSTRATION_FORM_CHECKBOX_INPUT).isChecked() ? "true" : "false";
            String showDateCreated = clvConfig.getUICheckBoxInput(UICLVConfig.SHOW_DATE_CREATED_FORM_CHECKBOX_INPUT).isChecked() ? "true" : "false";
            String showMoreLink = clvConfig.getUICheckBoxInput(UICLVConfig.SHOW_READMORE_FORM_CHECKBOX_INPUT).isChecked() ? "true" : "false";
            String showSummary = clvConfig.getUICheckBoxInput(UICLVConfig.SHOW_SUMMARY_FORM_CHECKBOX_INPUT).isChecked() ? "true" : "false";
            String showLink = clvConfig.getUICheckBoxInput(UICLVConfig.SHOW_LINK_FORM_CHECKBOX_INPUT).isChecked() ? "true" : "false";
            String showRssLink = clvConfig.getUICheckBoxInput(UICLVConfig.SHOW_RSSLINK_FORM_CHECKBOX_INPUT).isChecked() ? "true" : "false";
            String contextualFolderMode = (String)((UIFormRadioBoxInput)clvConfig.findComponentById(UICLVConfig.CONTEXTUAL_FOLDER_RADIOBOX_INPUT)).getValue();
            String showClvBy = (String)clvConfig.getUIStringInput(UICLVConfig.SHOW_CLV_BY_STRING_INPUT).getValue();
            if (showClvBy == null || showClvBy.length() == 0) {
                showClvBy = "folder-id";
            }
            String targetPage = (String)clvConfig.getUIStringInput(UICLVConfig.TARGET_PAGE_FORM_STRING_INPUT).getValue();
            String showScvWith = (String)clvConfig.getUIStringInput(UICLVConfig.SHOW_SCV_WITH_STRING_INPUT).getValue();
            if (showScvWith == null || showScvWith.length() == 0) {
                showScvWith = "content-id";
            }
            String cacheEnabled = (String)((UIFormRadioBoxInput)clvConfig.findComponentById(UICLVConfig.CACHE_ENABLE_RADIOBOX_INPUT)).getValue();
            PortletRequestContext portletRequestContext = (PortletRequestContext)event.getRequestContext();
            PortletPreferences portletPreferences = portletRequestContext.getRequest().getPreferences();
            portletPreferences.setValue("mode", displayMode);
            portletPreferences.setValue("folderPath", itemPath);
            portletPreferences.setValue("nodeDrive", clvConfig.getDriveName());
            portletPreferences.setValue("orderBy", orderBy);
            portletPreferences.setValue("orderType", orderType);
            portletPreferences.setValue("header", header);
            portletPreferences.setValue("automaticDetection", showAutomaticDetection);
            portletPreferences.setValue("formViewTemplatePath", displayTemplate);
            portletPreferences.setValue("paginatorTemplatePath", paginatorTemplate);
            portletPreferences.setValue("itemsPerPage", itemsPerPage);
            portletPreferences.setValue("showTitle", showTitle);
            portletPreferences.setValue("showHeader", showHeader);
            portletPreferences.setValue("showRefreshButton", showRefresh);
            portletPreferences.setValue("showThumbnailsView", showImage);
            portletPreferences.setValue("showDateCreated", showDateCreated);
            portletPreferences.setValue("showReadmore", showMoreLink);
            portletPreferences.setValue("showSummary", showSummary);
            portletPreferences.setValue("showLink", showLink);
            portletPreferences.setValue("showRssLink", showRssLink);
            portletPreferences.setValue("contextualFolder", contextualFolderMode);
            portletPreferences.setValue("showClvBy", showClvBy);
            portletPreferences.setValue("basePath", targetPage);
            portletPreferences.setValue("showScvWith", showScvWith);
            portletPreferences.setValue("sharedCache", UICLVConfig.ENABLE_CACHE.equals(cacheEnabled) ? "true" : "false");
            String appType = portletPreferences.getValue("application", null);
            if ("ContentsByQuery".equals(appType)) {
                String workspace = (String)((UIFormSelectBox)clvConfig.findComponentById(UICLVConfig.WORKSPACE_FORM_SELECT_BOX)).getValue();
                String query = (String)((UIFormTextAreaInput)clvConfig.findComponentById(UICLVConfig.CONTENT_BY_QUERY_TEXT_AREA)).getValue();
                if (query == null) {
                    query = "";
                }
                portletPreferences.setValue("workspace", workspace);
                portletPreferences.setValue("query", query);
            }
            portletPreferences.store();
            UICLVPortlet portlet = (UICLVPortlet)clvConfig.getAncestorOfType(UICLVPortlet.class);
            if (Utils.isPortalEditMode()) {
                portlet.updatePortlet();
            } else if (clvConfig.getModeInternal()) {
                portlet.changeToViewMode();
            } else {
                Utils.closePopupWindow((UIContainer)clvConfig, (String)"UIViewerManagementPopupWindow");
                portlet.updatePortlet();
            }
        }
    }
}

