/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.FIFOSemaphore;
import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.Sync;

public class FIFOReadWriteLock
implements ReadWriteLock {
    protected final FIFOSemaphore entryLock = new FIFOSemaphore(1L);
    protected volatile int readers;
    protected int exreaders;
    protected final Sync readerSync = new ReaderSync();
    protected final Sync writerSync = new WriterSync();

    protected void acquireRead() throws InterruptedException {
        this.entryLock.acquire();
        ++this.readers;
        this.entryLock.release();
    }

    protected synchronized void releaseRead() {
        if (++this.exreaders == this.readers) {
            this.notify();
        }
    }

    protected void acquireWrite() throws InterruptedException {
        this.entryLock.acquire();
        int n = this.readers;
        try {
            FIFOReadWriteLock fIFOReadWriteLock = this;
            synchronized (fIFOReadWriteLock) {
                while (this.exreaders != n) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            this.entryLock.release();
            throw interruptedException;
        }
    }

    protected void releaseWrite() {
        this.entryLock.release();
    }

    protected boolean attemptRead(long l) throws InterruptedException {
        if (!this.entryLock.attempt(l)) {
            return false;
        }
        ++this.readers;
        this.entryLock.release();
        return true;
    }

    protected boolean attemptWrite(long l) throws InterruptedException {
        long l2;
        long l3 = l2 = l <= 0L ? 0L : System.currentTimeMillis();
        if (!this.entryLock.attempt(l)) {
            return false;
        }
        int n = this.readers;
        try {
            FIFOReadWriteLock fIFOReadWriteLock = this;
            synchronized (fIFOReadWriteLock) {
                while (this.exreaders != n) {
                    long l4;
                    long l5 = l4 = l <= 0L ? 0L : l - (System.currentTimeMillis() - l2);
                    if (l4 <= 0L) {
                        this.entryLock.release();
                        boolean bl = false;
                        return bl;
                    }
                    this.wait(l4);
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (InterruptedException interruptedException) {
            this.entryLock.release();
            throw interruptedException;
        }
    }

    public Sync writeLock() {
        return this.writerSync;
    }

    public Sync readLock() {
        return this.readerSync;
    }

    protected class WriterSync
    implements Sync {
        protected WriterSync() {
        }

        public void acquire() throws InterruptedException {
            FIFOReadWriteLock.this.acquireWrite();
        }

        public void release() {
            FIFOReadWriteLock.this.releaseWrite();
        }

        public boolean attempt(long l) throws InterruptedException {
            return FIFOReadWriteLock.this.attemptWrite(l);
        }
    }

    protected class ReaderSync
    implements Sync {
        protected ReaderSync() {
        }

        public void acquire() throws InterruptedException {
            FIFOReadWriteLock.this.acquireRead();
        }

        public void release() {
            FIFOReadWriteLock.this.releaseRead();
        }

        public boolean attempt(long l) throws InterruptedException {
            return FIFOReadWriteLock.this.attemptRead(l);
        }
    }
}

