/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.core;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.core.security.JCRRuntimePermissions;
import org.exoplatform.services.jcr.impl.WorkspaceContainer;
import org.exoplatform.services.jcr.impl.WorkspaceResumer;
import org.exoplatform.services.jcr.impl.backup.ResumeException;
import org.exoplatform.services.jcr.impl.backup.SuspendException;
import org.exoplatform.services.jcr.impl.backup.Suspendable;

public final class WorkspaceContainerFacade {
    private final String workspaceName;
    private final WorkspaceContainer container;
    private AtomicBoolean workspaceResumerInit = new AtomicBoolean();
    private WorkspaceResumer workspaceResumer;

    public WorkspaceContainerFacade(String workspaceName, WorkspaceContainer container) {
        this.workspaceName = workspaceName;
        this.container = container;
    }

    private WorkspaceResumer getWorkspaceResumer() {
        if (this.workspaceResumerInit.get()) {
            return this.workspaceResumer;
        }
        this.workspaceResumer = (WorkspaceResumer)this.container.getComponentInstanceOfType(WorkspaceResumer.class, false);
        this.workspaceResumerInit.set(true);
        return this.workspaceResumer;
    }

    public final String getWorkspaceName() {
        return this.workspaceName;
    }

    public <T> List<T> getComponentInstancesOfType(Class<T> componentType) {
        return this.container.getComponentInstancesOfType(componentType);
    }

    public Object getComponent(Object key) {
        if (key instanceof Class) {
            return this.container.getComponentInstanceOfType((Class)key);
        }
        return this.container.getComponentInstance(key);
    }

    public void addComponent(Object component) {
        if (component instanceof Class) {
            this.container.registerComponentImplementation((Class)component);
        } else {
            this.container.registerComponentInstance(component);
        }
    }

    public void addComponent(Object key, Object component) {
        this.container.registerComponentInstance(key, component);
    }

    public int getState() {
        boolean hasSuspendedComponents = false;
        boolean hasResumedComponents = false;
        List<Suspendable> suspendableComponents = this.getComponentInstancesOfType(Suspendable.class);
        for (Suspendable component : suspendableComponents) {
            if (component.isSuspended()) {
                hasSuspendedComponents = true;
                continue;
            }
            hasResumedComponents = true;
        }
        if (hasSuspendedComponents && !hasResumedComponents) {
            return 3;
        }
        if (!hasSuspendedComponents) {
            return 1;
        }
        return 4;
    }

    public void setState(final int state) throws RepositoryException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(JCRRuntimePermissions.MANAGE_REPOSITORY_PERMISSION);
        }
        try {
            SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws RepositoryException {
                    switch (state) {
                        case 1: {
                            WorkspaceContainerFacade.this.resume();
                            break;
                        }
                        case 0: {
                            WorkspaceContainerFacade.this.suspend();
                            break;
                        }
                        case 3: {
                            WorkspaceContainerFacade.this.suspend();
                            break;
                        }
                        default: {
                            return null;
                        }
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RepositoryException) {
                throw new RepositoryException(cause);
            }
            throw new RuntimeException(cause);
        }
    }

    private void suspend() throws RepositoryException {
        WorkspaceResumer workspaceResumer = this.getWorkspaceResumer();
        if (workspaceResumer != null) {
            workspaceResumer.onSuspend();
        }
        List<Suspendable> components = this.getComponentInstancesOfType(Suspendable.class);
        Comparator<Suspendable> c = new Comparator<Suspendable>(){

            @Override
            public int compare(Suspendable s1, Suspendable s2) {
                return s2.getPriority() - s1.getPriority();
            }
        };
        Collections.sort(components, c);
        for (Suspendable component : components) {
            try {
                if (component.isSuspended()) continue;
                component.suspend();
            }
            catch (SuspendException e) {
                throw new RepositoryException("Can't suspend component", (Throwable)e);
            }
        }
    }

    private void resume() throws RepositoryException {
        WorkspaceResumer workspaceResumer = this.getWorkspaceResumer();
        if (workspaceResumer != null) {
            workspaceResumer.onResume();
        }
        List<Suspendable> components = this.getComponentInstancesOfType(Suspendable.class);
        Comparator<Suspendable> c = new Comparator<Suspendable>(){

            @Override
            public int compare(Suspendable s1, Suspendable s2) {
                return s1.getPriority() - s2.getPriority();
            }
        };
        Collections.sort(components, c);
        for (Suspendable component : components) {
            try {
                if (!component.isSuspended()) continue;
                component.resume();
            }
            catch (ResumeException e) {
                throw new RepositoryException("Can't set component online", (Throwable)e);
            }
        }
    }
}

