/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.util.autodetect;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.fontbox.util.autodetect.FontDirFinder;
import org.apache.fontbox.util.autodetect.MacFontDirFinder;
import org.apache.fontbox.util.autodetect.UnixFontDirFinder;
import org.apache.fontbox.util.autodetect.WindowsFontDirFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontFileFinder {
    private FontDirFinder fontDirFinder = null;

    private FontDirFinder determineDirFinder() {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            return new WindowsFontDirFinder();
        }
        if (osName.startsWith("Mac")) {
            return new MacFontDirFinder();
        }
        return new UnixFontDirFinder();
    }

    public List<URI> find() throws IOException {
        if (this.fontDirFinder == null) {
            this.fontDirFinder = this.determineDirFinder();
        }
        List<File> fontDirs = this.fontDirFinder.find();
        ArrayList<URI> results = new ArrayList<URI>();
        for (File dir : fontDirs) {
            this.walk(dir, results);
        }
        return results;
    }

    public List<URI> find(String dir) throws IOException {
        ArrayList<URI> results = new ArrayList<URI>();
        File directory = new File(dir);
        if (directory.isDirectory()) {
            this.walk(directory, results);
        }
        return results;
    }

    public Map<String, String> getCommonTTFMapping() {
        if (this.fontDirFinder == null) {
            this.fontDirFinder = this.determineDirFinder();
        }
        return this.fontDirFinder.getCommonTTFMapping();
    }

    private void walk(File directory, List<URI> results) {
        File[] filelist;
        if (directory.isDirectory() && (filelist = directory.listFiles()) != null) {
            for (File file : filelist) {
                if (file.isDirectory()) {
                    if (file.getName().startsWith(".")) continue;
                    this.walk(file, results);
                    continue;
                }
                if (!this.checkFontfile(file)) continue;
                results.add(file.toURI());
            }
        }
    }

    private boolean checkFontfile(File file) {
        String name = file.getName().toLowerCase();
        return name.endsWith(".ttf") || name.endsWith(".otf") || name.endsWith(".pfb") || name.endsWith(".ttc");
    }
}

