/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.plugin.doc;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.ActivityTypeUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.plugin.doc.ComposerFileItem;
import org.exoplatform.social.plugin.doc.UIDocActivity;
import org.exoplatform.social.webui.composer.UIComposer;
import org.exoplatform.webui.core.UIContainer;

public abstract class UIAbstractSelectFileComposer
extends UIContainer {
    private static final Log LOG = ExoLogger.getLogger((String)UIAbstractSelectFileComposer.class.getName());
    public static final String SEPARATOR = "|@|";
    public static final String COMPOSER_SELECTION_TYPE = "FILE_ITEMS";
    public static final String COMPOSER_DESTINATION_FOLDER = "DESTINATION_FOLDER";

    public abstract Set<ComposerFileItem> getSelectFiles();

    public abstract void resetSelection();

    public abstract String getResolverType();

    public abstract Object preActivitySave(Object var1, UIComposer.PostContext var2) throws Exception;

    public void removeFile(ComposerFileItem fileItem) {
        if (fileItem.getResolverType().equals(this.getResolverType())) {
            this.removeSelectedFile(fileItem);
        }
    }

    public void putActivityParams(Object obj, Object resource, Map<String, String> activityParams) throws Exception {
        if (!(obj instanceof Node) || !(resource instanceof ComposerFileItem)) {
            LOG.warn((Object)("Selected object of type '" + obj.getClass().getName() + "' with selected resource of type '" + resource.getClass().getName() + "' is not supported"));
            return;
        }
        Node node = (Node)obj;
        String title = Utils.getTitle((Node)node);
        boolean isSymlink = node.isNodeType("exo:symlink");
        if (isSymlink) {
            node = Utils.getNodeSymLink((Node)node);
        }
        Session session = node.getSession();
        ManageableRepository repository = (ManageableRepository)session.getRepository();
        String repoName = repository.getConfiguration().getName();
        String wsName = session.getWorkspace().getName();
        this.concatenateParamName(activityParams, "docTitle", title);
        this.concatenateParamName(activityParams, "isSymlink", String.valueOf(isSymlink));
        this.concatenateParamName(activityParams, "DOCNAME", node.getName());
        this.concatenateParamName(activityParams, "DOCLINK", this.buildDocumentLink(repoName, wsName, node.getPath()));
        this.concatenateParamName(activityParams, "DOCPATH", node.getPath());
        this.concatenateParamName(activityParams, "REPOSITORY", repoName);
        this.concatenateParamName(activityParams, "WORKSPACE", wsName);
        this.concatenateParamName(activityParams, "\\|", "MESSAGE");
        if (node.getPrimaryNodeType().getName().equals("nt:file") || node.isNodeType("exo:accessibleMedia")) {
            Node contentNode;
            String activityOwnerId = UIDocActivity.getActivityOwnerId(node);
            SimpleDateFormat dateFormatter = null;
            dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            String illustrationImg = UIDocActivity.getIllustrativeImage(node);
            String strDateCreated = "";
            if (node.hasProperty("exo:dateCreated")) {
                Calendar dateCreated = node.getProperty("exo:dateCreated").getDate();
                strDateCreated = dateFormatter.format(dateCreated.getTime());
            }
            String strLastModified = "";
            if (node.hasNode("jcr:content") && (contentNode = node.getNode("jcr:content")).hasProperty("jcr:lastModified")) {
                Calendar lastModified = contentNode.getProperty("jcr:lastModified").getDate();
                strLastModified = dateFormatter.format(lastModified.getTime());
            }
            this.concatenateParamName(activityParams, "id", node.isNodeType("mix:referenceable") ? node.getUUID() : "");
            this.concatenateParamName(activityParams, "contentName", node.getName());
            this.concatenateParamName(activityParams, "author", activityOwnerId);
            this.concatenateParamName(activityParams, "dateCreated", strDateCreated);
            this.concatenateParamName(activityParams, "lastModified", strLastModified);
            this.concatenateParamName(activityParams, "contenLink", UIDocActivity.getContentLink(node));
            this.concatenateParamName(activityParams, "mimeType", UIDocActivity.getMimeType(node));
            this.concatenateParamName(activityParams, "imagePath", illustrationImg);
        }
    }

    public void postActivitySave(Object obj, UIComposer.PostContext postContext, ExoSocialActivity activity) throws Exception {
        if (activity != null && !StringUtils.isEmpty((String)activity.getId()) && obj instanceof Node) {
            Node node = (Node)obj;
            String activityId = activity.getId();
            ActivityTypeUtils.attachActivityId((Node)node, (String)activityId);
            node.save();
        }
    }

    public void concatenateParamName(Map<String, String> activityParams, String paramName, String paramValue) {
        String oldParamValue = activityParams.get(paramName);
        if (oldParamValue == null) {
            activityParams.put(paramName, paramValue);
        } else {
            activityParams.put(paramName, oldParamValue + SEPARATOR + paramValue);
        }
    }

    protected abstract void removeSelectedFile(ComposerFileItem var1);

    private String buildDocumentLink(String repoName, String wsName, String path) {
        String portalContainerName = PortalContainer.getCurrentPortalContainerName();
        String restContextName = PortalContainer.getCurrentRestContextName();
        String restService = "jcr";
        return "/" + portalContainerName + "/" + restContextName + "/" + restService + "/" + repoName + "/" + wsName + path;
    }

    public void validateSelection() {
    }
}

