/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.extensions.ui;

import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.extensions.publication.PublicationManager;
import org.exoplatform.services.wcm.extensions.publication.lifecycle.impl.LifecyclesConfig;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilterType;

public class CanValidateFilter
implements UIExtensionFilter {
    private static final Log LOG = ExoLogger.getLogger((String)CanValidateFilter.class.getName());

    public boolean accept(Map<String, Object> context) throws Exception {
        String currentState;
        Node currentNode = (Node)context.get(Node.class.getName());
        if (currentNode.hasProperty("publication:currentState") && currentNode.hasProperty("publication:lifecycle") && "draft".equals(currentState = currentNode.getProperty("publication:currentState").getString())) {
            String userId;
            try {
                userId = Util.getPortalRequestContext().getRemoteUser();
            }
            catch (Exception e) {
                userId = currentNode.getSession().getUserID();
            }
            String nodeLifecycle = currentNode.getProperty("publication:lifecycle").getString();
            PublicationManager publicationManager = (PublicationManager)WCMCoreUtils.getService(PublicationManager.class);
            List lifecycles = publicationManager.getLifecyclesFromUser(userId, "pending");
            for (LifecyclesConfig.Lifecycle lifecycle : lifecycles) {
                if (!nodeLifecycle.equals(lifecycle.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public UIExtensionFilterType getType() {
        return UIExtensionFilterType.MANDATORY;
    }

    public void onDeny(Map<String, Object> context) throws Exception {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)"You can add a category in a exo:taxonomy node only.");
        }
    }
}

