/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.nodetype;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFactory;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.core.nodetype.NodeDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionData;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.value.BaseValue;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.version.VersionHistoryDataHelper;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ItemAutocreator {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.ItemAutocreator");
    private final NodeTypeDataManager nodeTypeDataManager;
    private final ItemDataConsumer dataConsumer;
    private final ValueFactory valueFactory;
    private final boolean avoidCheckExistedChildItems;

    public ItemAutocreator(NodeTypeDataManager nodeTypeDataManager, ValueFactory valueFactory, ItemDataConsumer dataConsumer, boolean avoidCheckExistedChildItems) {
        this.nodeTypeDataManager = nodeTypeDataManager;
        this.valueFactory = valueFactory;
        this.dataConsumer = dataConsumer;
        this.avoidCheckExistedChildItems = avoidCheckExistedChildItems;
    }

    public PlainChangesLog makeAutoCreatedItems(NodeData parent, InternalQName nodeTypeName, ItemDataConsumer targetDataManager, String owner) throws RepositoryException {
        return this.makeAutoCreatedItems(parent, nodeTypeName, targetDataManager, owner, false);
    }

    private PlainChangesLog makeAutoCreatedItems(NodeData parent, InternalQName nodeTypeName, ItemDataConsumer targetDataManager, String owner, boolean addedAutoCreatedNodes) throws RepositoryException {
        PlainChangesLogImpl changes = new PlainChangesLogImpl();
        NodeTypeData type = this.nodeTypeDataManager.getNodeType(nodeTypeName);
        changes.addAll(this.makeAutoCreatedProperties(parent, nodeTypeName, this.nodeTypeDataManager.getAllPropertyDefinitions(nodeTypeName), targetDataManager, owner).getAllStates());
        changes.addAll(this.makeAutoCreatedNodes(parent, nodeTypeName, this.nodeTypeDataManager.getAllChildNodeDefinitions(nodeTypeName), targetDataManager, owner).getAllStates());
        if (this.nodeTypeDataManager.isNodeType(Constants.MIX_VERSIONABLE, type.getName())) {
            changes.addAll(this.makeMixVesionableChanges(parent).getAllStates());
        }
        return changes;
    }

    public PlainChangesLog makeAutoCreatedNodes(NodeData parent, InternalQName typeName, NodeDefinitionData[] nodeDefs, ItemDataConsumer targetDataManager, String owner) throws RepositoryException {
        return this.makeAutoCreatedNodes(parent, typeName, nodeDefs, targetDataManager, owner, false);
    }

    private PlainChangesLog makeAutoCreatedNodes(NodeData parent, InternalQName typeName, NodeDefinitionData[] nodeDefs, ItemDataConsumer targetDataManager, String owner, boolean addedAutoCreatedNodes) throws RepositoryException {
        PlainChangesLogImpl changes = new PlainChangesLogImpl();
        HashSet<InternalQName> addedNodes = new HashSet<InternalQName>();
        for (NodeDefinitionData ndef : nodeDefs) {
            ItemData pdata;
            if (!ndef.isAutoCreated()) continue;
            ItemData itemData = pdata = this.avoidCheckExistedChildItems ? null : targetDataManager.getItemData(parent, new QPathEntry(ndef.getName(), 0), ItemType.NODE, false);
            if (pdata == null && !addedNodes.contains((Object)ndef.getName()) || pdata != null && !pdata.isNode()) {
                TransientNodeData childNodeData = TransientNodeData.createNodeData(parent, ndef.getName(), ndef.getDefaultPrimaryType(), IdGenerator.generate());
                if (!addedAutoCreatedNodes) {
                    addedAutoCreatedNodes = true;
                    changes.add(ItemState.createAddedAutoCreatedNodes(parent));
                }
                changes.add(ItemState.createAddedState(childNodeData, false));
                changes.addAll(this.makeAutoCreatedItems(childNodeData, childNodeData.getPrimaryTypeName(), targetDataManager, owner, addedAutoCreatedNodes).getAllStates());
                addedNodes.add(ndef.getName());
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Skipping existed node " + (Object)((Object)ndef.getName()) + " in " + parent.getQPath().getAsString() + "   during the automatic creation of items for " + typeName.getAsString() + " nodetype or mixin type"));
        }
        return changes;
    }

    public PlainChangesLog makeAutoCreatedProperties(NodeData parent, InternalQName typeName, PropertyDefinitionData[] propDefs, ItemDataConsumer targetDataManager, String owner) throws RepositoryException {
        PlainChangesLogImpl changes = new PlainChangesLogImpl();
        HashSet<InternalQName> addedProperties = new HashSet<InternalQName>();
        for (PropertyDefinitionData pdef : propDefs) {
            ItemData pdata;
            if (!pdef.isAutoCreated()) continue;
            ItemData itemData = pdata = this.avoidCheckExistedChildItems ? null : targetDataManager.getItemData(parent, new QPathEntry(pdef.getName(), 0), ItemType.PROPERTY, false);
            if (pdata == null && !addedProperties.contains((Object)pdef.getName()) || pdata != null && pdata.isNode()) {
                List<ValueData> listAutoCreateValue = this.autoCreatedValue(parent, typeName, pdef, owner);
                if (listAutoCreateValue == null) continue;
                TransientPropertyData propertyData = TransientPropertyData.createPropertyData(parent, pdef.getName(), pdef.getRequiredType(), pdef.isMultiple(), listAutoCreateValue);
                changes.add(ItemState.createAddedState(propertyData));
                addedProperties.add(pdef.getName());
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Skipping existed property " + (Object)((Object)pdef.getName()) + " in " + parent.getQPath().getAsString() + "   during the automatic creation of items for " + typeName.getAsString() + " nodetype or mixin type"));
        }
        return changes;
    }

    public PlainChangesLog makeMixVesionableChanges(NodeData parent) throws RepositoryException {
        PlainChangesLogImpl changesLog = new PlainChangesLogImpl();
        new VersionHistoryDataHelper(parent, changesLog, this.dataConsumer, this.nodeTypeDataManager);
        return changesLog;
    }

    protected List<ValueData> autoCreatedValue(NodeData parent, InternalQName typeName, PropertyDefinitionData def, String owner) throws RepositoryException {
        ArrayList<ValueData> vals = new ArrayList<ValueData>();
        if (this.nodeTypeDataManager.isNodeType(Constants.NT_BASE, typeName) && def.getName().equals((Object)Constants.JCR_PRIMARYTYPE)) {
            vals.add(new TransientValueData(parent.getPrimaryTypeName()));
        } else if (this.nodeTypeDataManager.isNodeType(Constants.MIX_REFERENCEABLE, typeName) && def.getName().equals((Object)Constants.JCR_UUID)) {
            vals.add(new TransientValueData(parent.getIdentifier()));
        } else if (this.nodeTypeDataManager.isNodeType(Constants.NT_HIERARCHYNODE, typeName) && def.getName().equals((Object)Constants.JCR_CREATED)) {
            vals.add(new TransientValueData(Calendar.getInstance()));
        } else if (this.nodeTypeDataManager.isNodeType(Constants.NT_HIERARCHYNODE, typeName) && def.getName().equals((Object)new InternalQName("http://www.jcp.org/jcr/1.0", "createdBy"))) {
            vals.add(new TransientValueData(owner));
        } else if (this.nodeTypeDataManager.isNodeType(Constants.EXO_OWNEABLE, typeName) && def.getName().equals((Object)Constants.EXO_OWNER)) {
            vals.add(new TransientValueData(owner));
        } else if (this.nodeTypeDataManager.isNodeType(Constants.EXO_PRIVILEGEABLE, typeName) && def.getName().equals((Object)Constants.EXO_PERMISSIONS)) {
            for (AccessControlEntry ace : parent.getACL().getPermissionEntries()) {
                vals.add(new TransientValueData(ace));
            }
        } else {
            String[] propVal = def.getDefaultValues();
            if (propVal != null && propVal.length != 0) {
                for (String v : propVal) {
                    if (v != null) {
                        if (def.getRequiredType() == 0) {
                            vals.add(((BaseValue)this.valueFactory.createValue(v)).getInternalData());
                            continue;
                        }
                        vals.add(((BaseValue)this.valueFactory.createValue(v, def.getRequiredType())).getInternalData());
                        continue;
                    }
                    vals.add(null);
                }
            } else {
                return null;
            }
        }
        return vals;
    }
}

