/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.ispn;

import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.jcr.config.QueryHandlerEntry;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.impl.core.query.ChangesFilterListsWrapper;
import org.exoplatform.services.jcr.impl.core.query.IndexerChangesFilter;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoModeHandler;
import org.exoplatform.services.jcr.impl.core.query.IndexingTree;
import org.exoplatform.services.jcr.impl.core.query.LocalIndexMarker;
import org.exoplatform.services.jcr.impl.core.query.QueryHandler;
import org.exoplatform.services.jcr.impl.core.query.SearchManager;
import org.exoplatform.services.jcr.impl.core.query.ispn.ChangesKey;
import org.exoplatform.services.jcr.impl.core.query.ispn.LocalIndexCacheStore;
import org.exoplatform.services.jcr.infinispan.ISPNCacheFactory;
import org.exoplatform.services.jcr.infinispan.PrivilegedISPNCacheHelper;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.persistence.manager.PersistenceManager;

public class LocalIndexChangesFilter
extends IndexerChangesFilter
implements LocalIndexMarker {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.LocalIndexChangesFilter");
    public static final String PARAM_INFINISPAN_CACHESTORE_CLASS = "infinispan-cachestore-classname";
    private final Cache<Serializable, Object> cache;
    private final String wsId;

    public LocalIndexChangesFilter(SearchManager searchManager, SearchManager parentSearchManager, QueryHandlerEntry config, IndexingTree indexingTree, IndexingTree parentIndexingTree, QueryHandler handler, QueryHandler parentHandler, ConfigurationManager cfm) throws IOException, RepositoryException, RepositoryConfigurationException {
        super(searchManager, parentSearchManager, config, indexingTree, parentIndexingTree, handler, parentHandler, cfm);
        this.wsId = searchManager.getWsId();
        ISPNCacheFactory factory = new ISPNCacheFactory(cfm);
        config.putParameterValue(PARAM_INFINISPAN_CACHESTORE_CLASS, LocalIndexCacheStore.class.getName());
        this.cache = factory.createCache("Indexer_" + searchManager.getWsId(), config);
        PersistenceManager persistenceManager = (PersistenceManager)this.cache.getAdvancedCache().getComponentRegistry().getComponent(PersistenceManager.class);
        Set stores = persistenceManager.getStores(LocalIndexCacheStore.class);
        LocalIndexCacheStore cacheStore = null;
        if (!stores.isEmpty()) {
            cacheStore = (LocalIndexCacheStore)stores.iterator().next();
        }
        cacheStore.register(searchManager, parentSearchManager, handler, parentHandler);
        IndexerIoModeHandler modeHandler = cacheStore.getModeHandler();
        handler.setIndexerIoModeHandler(modeHandler);
        parentHandler.setIndexerIoModeHandler(modeHandler);
        if (!parentHandler.isInitialized()) {
            parentHandler.init();
        }
        if (!handler.isInitialized()) {
            handler.init();
        }
    }

    @Override
    protected Log getLogger() {
        return LOG;
    }

    @Override
    protected void doUpdateIndex(ChangesFilterListsWrapper changes) {
        ChangesKey changesKey = new ChangesKey(this.wsId, IdGenerator.generate());
        try {
            this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)changesKey, (Object)changes);
        }
        catch (Throwable throwable) {
            this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.IGNORE_RETURN_VALUES}).remove((Object)changesKey);
            throw throwable;
        }
        this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.IGNORE_RETURN_VALUES}).remove((Object)changesKey);
    }

    @Override
    public void close() {
        PrivilegedISPNCacheHelper.stop(this.cache);
        ISPNCacheFactory.releaseUniqueInstance(this.cache.getCacheManager());
    }
}

