/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.navigation;

import java.util.Locale;
import java.util.ResourceBundle;
import org.exoplatform.commons.utils.ExpressionUtil;
import org.exoplatform.portal.mop.Described;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.description.DescriptionService;
import org.exoplatform.services.resources.ResourceBundleManager;
import org.gatein.api.ApiException;
import org.gatein.api.PortalRequest;
import org.gatein.api.Util;
import org.gatein.api.site.SiteId;

public class Navigation18NResolver {
    private final DescriptionService service;
    private final ResourceBundleManager bundleManager;
    private final Locale siteLocale;
    private final SiteId siteId;

    public Navigation18NResolver(DescriptionService service, ResourceBundleManager bundleManager, Locale siteLocale, SiteId siteId) {
        this.service = service;
        this.bundleManager = bundleManager;
        this.siteLocale = siteLocale;
        this.siteId = siteId;
    }

    private ResourceBundle getResourceBundle() {
        Locale userLocale = this.getUserLocale();
        if (userLocale == null) {
            userLocale = this.siteLocale;
        }
        if (userLocale == null) {
            userLocale = Locale.getDefault();
        }
        SiteKey siteKey = Util.from(this.siteId);
        return this.bundleManager.getNavigationResourceBundle(userLocale.getLanguage(), siteKey.getTypeName(), siteKey.getName());
    }

    private Locale getUserLocale() {
        return PortalRequest.getInstance().getLocale();
    }

    public String resolveName(String string, String descriptionId, String defaultValue) {
        return this.resolve(string, descriptionId, defaultValue, true);
    }

    private String resolve(String string, String descriptionId, String defaultValue, boolean nameFlag) {
        String resolved = null;
        if (string != null) {
            resolved = ExpressionUtil.isResourceBindingExpression((String)string) ? ExpressionUtil.getExpressionValue((ResourceBundle)this.getResourceBundle(), (String)string) : string;
        } else if (descriptionId != null) {
            Described.State described;
            Locale userLocale = this.getUserLocale();
            try {
                described = userLocale != null ? this.service.resolveDescription(descriptionId, this.siteLocale, userLocale) : this.service.resolveDescription(descriptionId, this.siteLocale);
            }
            catch (Throwable t) {
                throw new ApiException("Failed to resolve description", t);
            }
            if (described != null) {
                resolved = nameFlag ? described.getName() : described.getDescription();
            }
        }
        return resolved == null ? defaultValue : resolved;
    }
}

