/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.updater;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class SpaceMemberAnyMembershipUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger(SpaceMemberAnyMembershipUpgradePlugin.class);
    private final int BUFFER = 50;
    private final int THREAD = 10;
    private PortalContainer portalContainer;
    private SpaceService spaceService;
    private OrganizationService organizationService;
    private ExecutorService executorService = Executors.newCachedThreadPool();

    public SpaceMemberAnyMembershipUpgradePlugin(PortalContainer portalContainer, OrganizationService organizationService, SpaceService spaceService, InitParams initParams) {
        super(initParams);
        this.portalContainer = portalContainer;
        this.organizationService = organizationService;
        this.spaceService = spaceService;
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        LOG.info((Object)"=== Start IDM Membership '*'  to Space Entity migration");
        long startTime = System.currentTimeMillis();
        MigrationResult migrationResult = new MigrationResult();
        RequestLifeCycle.begin((ExoContainer)this.portalContainer);
        try {
            boolean migrationSuccessfullyProceeded = this.migrate(migrationResult);
            if (!migrationSuccessfullyProceeded || migrationResult.getErrorCount() > 0) {
                throw new IllegalStateException("=== Error while checking the consistency of spaces members. " + migrationResult.getSuccessCount() + "/" + migrationResult.getTotalEntities() + " memberships has been fixed in " + (System.currentTimeMillis() - startTime) + "ms. Errors count of Memberships migration = " + migrationResult.getErrorCount() + ". Total scanned spaces count = " + migrationResult.getSpacesCount());
            }
            if (migrationResult.getTotalEntities() == 0) {
                LOG.info("=== End of consistency check of space members in {}ms. No inconsistency detected. Total scanned spaces count = {}", new Object[]{System.currentTimeMillis() - startTime, migrationResult.getSpacesCount()});
            } else {
                LOG.info("=== End of consistency check of space members in {}ms. {}/{} memberships has been fixed. Total scanned spaces count = {}", new Object[]{System.currentTimeMillis() - startTime, migrationResult.getSuccessCount(), migrationResult.getTotalEntities(), migrationResult.getSpacesCount()});
            }
        }
        catch (Exception ex) {
            LOG.error((Object)("=== Error while checking the consistency of spaces members. " + migrationResult.getSuccessCount() + "/" + migrationResult.getTotalEntities() + " memberships has been fixed in " + (System.currentTimeMillis() - startTime) + "ms. Error count of Memberships migration = " + migrationResult.getErrorCount()), (Throwable)ex);
            throw new RuntimeException("Error while checking the consistency of spaces members", ex);
        }
        finally {
            RequestLifeCycle.end();
            this.executorService.shutdown();
        }
    }

    private boolean migrate(MigrationResult migrationResult) throws Exception {
        int fromIndex;
        ListAccess allSpacesListAccess = this.spaceService.getAllSpacesWithListAccess();
        int spacesCount = allSpacesListAccess.getSize();
        if (spacesCount == 0) {
            return true;
        }
        List<Space> allSpaces = this.getAllSpaces((ListAccess<Space>)allSpacesListAccess, spacesCount);
        int numberOfThreads = (spacesCount = allSpaces.size()) >= 10 ? 10 : spacesCount;
        int numberOfSpacesPerThreads = (int)Math.ceil((double)spacesCount / (double)numberOfThreads);
        migrationResult.setSpacesCount(spacesCount);
        ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
        for (int i = 0; i < numberOfThreads && (fromIndex = numberOfSpacesPerThreads * i) <= spacesCount; ++i) {
            int n = fromIndex + numberOfSpacesPerThreads;
            n = n > spacesCount ? spacesCount : n;
            List<Space> spaces = allSpaces.subList(fromIndex, n);
            Future<Boolean> future = this.executorService.submit(new SpaceMigrationCallable(spaces, migrationResult));
            futures.add(future);
        }
        boolean migrationCompletedSuccessfully = true;
        for (Future future : futures) {
            migrationCompletedSuccessfully = migrationCompletedSuccessfully && (Boolean)future.get() != false;
        }
        return migrationCompletedSuccessfully;
    }

    private List<Space> getAllSpaces(ListAccess<Space> allSpacesListAccess, int spacesCount) throws Exception {
        ArrayList<Space> allSpaces = new ArrayList<Space>();
        int offset = 0;
        Space[] spaces = null;
        while ((spaces = (Space[])allSpacesListAccess.load(offset, 50)) != null) {
            offset += spaces.length;
            for (Space space : spaces) {
                if (space == null || StringUtils.isBlank((String)space.getGroupId())) continue;
                allSpaces.add(space);
            }
            if (offset < spacesCount || spaces.length == 0) continue;
        }
        return allSpaces;
    }

    private void migrateSpace(Space space, MigrationResult migrationResult) throws Exception {
        LOG.info("Checking members of space '{}'", new Object[]{space.getDisplayName()});
        ListAccess<Membership> memberships = this.getMembershipByGroup(space.getGroupId());
        int membershipsSize = memberships.getSize();
        int fromId = 0;
        int pageSize = membershipsSize > 50 ? 50 : membershipsSize;
        int totalMigratedMemberships = 0;
        int errorMembershipsMigration = 0;
        while (pageSize > 0) {
            RequestLifeCycle.begin((ExoContainer)this.portalContainer);
            try {
                for (Membership m : (Membership[])memberships.load(fromId, pageSize)) {
                    block19: {
                        boolean isManager;
                        String username;
                        block18: {
                            if (m == null || !"*".equalsIgnoreCase(m.getMembershipType())) continue;
                            migrationResult.incrementTotalEntities();
                            LOG.info("Start migrating {}", new Object[]{m.toString()});
                            username = m.getUserName();
                            isManager = this.spaceService.isManager(space, username);
                            boolean isMember = this.spaceService.isMember(space, username);
                            if (isManager && isMember) {
                                LOG.debug("User '{}' belongs to space's group using '*' membershipType but he's already a space member and manager of the space '{}'. No migration is needed", new Object[]{username, space.getDisplayName()});
                                continue;
                            }
                            try {
                                if (isMember) break block18;
                                this.addMember(space, username);
                            }
                            catch (Exception e) {
                                LOG.error((Object)("Error while setting user " + username + " as member of space " + space.getDisplayName()), (Throwable)e);
                                migrationResult.incrementErrorCount();
                                ++errorMembershipsMigration;
                                continue;
                            }
                        }
                        try {
                            if (isManager) break block19;
                            this.setManager(space, username);
                        }
                        catch (Exception e) {
                            LOG.error((Object)("Error while setting user " + username + " as manager of space " + space.getDisplayName()), (Throwable)e);
                            migrationResult.incrementErrorCount();
                            ++errorMembershipsMigration;
                            continue;
                        }
                    }
                    migrationResult.incrementSuccessCount();
                    ++totalMigratedMemberships;
                }
            }
            catch (Exception e) {
                migrationResult.incrementErrorCount();
                ++errorMembershipsMigration;
                LOG.error("error during migrate membership at index {}, page {}", new Object[]{fromId, pageSize});
                throw e;
            }
            finally {
                RequestLifeCycle.end();
            }
            LOG.info("Check space members is in progress, percentage = {}%", new Object[]{totalMigratedMemberships * 100 / membershipsSize});
            fromId += pageSize;
            pageSize = membershipsSize - fromId;
            pageSize = pageSize > 50 ? 50 : pageSize;
        }
        if (totalMigratedMemberships == 0) {
            if (errorMembershipsMigration > 0) {
                LOG.warn("No inconsistencies detected for space '{}'. Total checked memberships of space = {}. Memberships checks error = {} ", new Object[]{space.getDisplayName(), membershipsSize, errorMembershipsMigration});
            } else {
                LOG.info("No inconsistencies detected for space '{}'. Total checked memberships of space = {}.", new Object[]{space.getDisplayName(), membershipsSize});
            }
        } else if (errorMembershipsMigration > 0) {
            LOG.warn("{} inconsistencies has been fixed for space '{}'. Total checked memberships of space = {}. Memberships checks error = {}", new Object[]{totalMigratedMemberships, space.getDisplayName(), membershipsSize, errorMembershipsMigration});
        } else {
            LOG.info("{} inconsistencies has been fixed for space '{}'. Total checked memberships of space = {}", new Object[]{totalMigratedMemberships, space.getDisplayName(), membershipsSize});
        }
    }

    private void setManager(Space space, String userId) {
        Object[] managers = space.getManagers();
        if (!ArrayUtils.contains((Object[])managers, (Object)userId)) {
            managers = (String[])ArrayUtils.add((Object[])managers, (Object)userId);
            space.setManagers((String[])managers);
            this.spaceService.updateSpace(space);
            SpaceUtils.addUserToGroupWithManagerMembership((String)userId, (String)space.getGroupId());
        }
    }

    private void addMember(Space space, String userId) {
        Object[] members = space.getMembers();
        space = this.removeInvited(space, userId);
        space = this.removePending(space, userId);
        if (!ArrayUtils.contains((Object[])members, (Object)userId)) {
            members = (String[])ArrayUtils.add((Object[])members, (Object)userId);
            space.setMembers((String[])members);
            this.spaceService.updateSpace(space);
            SpaceUtils.addUserToGroupWithMemberMembership((String)userId, (String)space.getGroupId());
        }
    }

    private Space removePending(Space space, String userId) {
        Object[] pendingUsers = space.getPendingUsers();
        if (ArrayUtils.contains((Object[])pendingUsers, (Object)userId)) {
            pendingUsers = (String[])ArrayUtils.removeElement((Object[])pendingUsers, (Object)userId);
            space.setPendingUsers((String[])pendingUsers);
        }
        return space;
    }

    private Space removeInvited(Space space, String userId) {
        Object[] invitedUsers = space.getInvitedUsers();
        if (ArrayUtils.contains((Object[])invitedUsers, (Object)userId)) {
            invitedUsers = (String[])ArrayUtils.removeElement((Object[])invitedUsers, (Object)userId);
            space.setInvitedUsers((String[])invitedUsers);
        }
        return space;
    }

    private ListAccess<Membership> getMembershipByGroup(String groupId) throws Exception {
        Group group = this.organizationService.getGroupHandler().findGroupById(groupId);
        return this.organizationService.getMembershipHandler().findAllMembershipsByGroup(group);
    }

    public static class MigrationResult {
        int errorCount = 0;
        int successCount = 0;
        int totalEntities = 0;
        int spacesCount = 0;

        public void incrementErrorCount() {
            ++this.errorCount;
        }

        public int getErrorCount() {
            return this.errorCount;
        }

        public int getSuccessCount() {
            return this.successCount;
        }

        public void incrementSuccessCount() {
            ++this.successCount;
        }

        public void setTotalEntities(int totalEntities) {
            this.totalEntities = totalEntities;
        }

        public void incrementTotalEntities() {
            ++this.totalEntities;
        }

        public int getTotalEntities() {
            return this.totalEntities;
        }

        public int getSpacesCount() {
            return this.spacesCount;
        }

        public void setSpacesCount(int spacesCount) {
            this.spacesCount = spacesCount;
        }
    }

    public final class SpaceMigrationCallable
    implements Callable<Boolean> {
        List<Space> spaces = null;
        MigrationResult migrationResult = null;

        public SpaceMigrationCallable(List<Space> spaces, MigrationResult migrationResult) {
            this.spaces = spaces;
            this.migrationResult = migrationResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            ExoContainerContext.setCurrentContainer((ExoContainer)SpaceMemberAnyMembershipUpgradePlugin.this.portalContainer);
            boolean migrationProceededWithoutErrors = true;
            for (Space space : this.spaces) {
                if (space == null || StringUtils.isBlank((String)space.getGroupId())) continue;
                RequestLifeCycle.begin((ExoContainer)SpaceMemberAnyMembershipUpgradePlugin.this.portalContainer);
                try {
                    SpaceMemberAnyMembershipUpgradePlugin.this.migrateSpace(space, this.migrationResult);
                }
                catch (Exception ex) {
                    LOG.error((Object)("Error during migrate memberships of group " + space.getGroupId()), (Throwable)ex);
                    migrationProceededWithoutErrors = false;
                }
                finally {
                    RequestLifeCycle.end();
                }
            }
            return migrationProceededWithoutErrors;
        }
    }
}

