/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.perkstore.listener;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.perkstore.service.PerkStoreService;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;

@Asynchronous
public class EthereumWalletTransactionListener
extends Listener<Object, Map<String, Object>> {
    private ExoContainer container;
    private PerkStoreService perkStoreService;

    public EthereumWalletTransactionListener(PerkStoreService perkStoreService, ExoContainer container) {
        this.perkStoreService = perkStoreService;
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event<Object, Map<String, Object>> event) throws Exception {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            Map transactionDetails = (Map)event.getData();
            if (transactionDetails == null) {
                throw new IllegalStateException("Transaction details is mandatory");
            }
            String hash = (String)transactionDetails.get("hash");
            if (StringUtils.isBlank((CharSequence)hash)) {
                throw new IllegalStateException("Transaction hash is mandatory");
            }
            this.perkStoreService.saveOrderTransactionStatus(transactionDetails);
        }
        finally {
            RequestLifeCycle.end();
        }
    }
}

