/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.upgrade;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.transaction.TransactionService;

public class DeleteJCRFolderUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger(DeleteJCRFolderUpgradePlugin.class);
    protected static final int ONE_DAY_IN_SECONDS = 86400;
    protected static final long ONE_DAY_IN_MS = 86400000L;
    public static final String FOLDER_TO_DELETE_WORKSPACE = "workspace";
    public static final String FOLDER_TO_DELETE_PATH = "path";
    private final RepositoryService repositoryService;
    private final TransactionService transactionService;
    private final String workspace;
    private final String parentPath;
    private long defaultJCRSessionTimeout;
    private int deletedFoldersCount = 0;

    public DeleteJCRFolderUpgradePlugin(RepositoryService repositoryService, TransactionService transactionService, InitParams initParams) {
        super(initParams);
        this.repositoryService = repositoryService;
        this.transactionService = transactionService;
        if (!initParams.containsKey((Object)FOLDER_TO_DELETE_WORKSPACE)) {
            throw new IllegalStateException("Workspace is mandatory");
        }
        if (!initParams.containsKey((Object)FOLDER_TO_DELETE_PATH)) {
            throw new IllegalStateException("Path is mandatory");
        }
        this.workspace = initParams.getValueParam(FOLDER_TO_DELETE_WORKSPACE).getValue();
        this.parentPath = initParams.getValueParam(FOLDER_TO_DELETE_PATH).getValue();
    }

    @Override
    public void processUpgrade(String oldVersion, String newVersion) {
        this.increaseCurrentTransactionTimeOut();
        try {
            Session session = this.getSession(null);
            if (!session.itemExists(this.parentPath)) {
                return;
            }
            Node parentNode = (Node)session.getItem(this.parentPath);
            this.removeRecursively(parentNode);
            parentNode.remove();
            session.save();
            LOG.info("Parent folder {}:{} is removed successfully. {} folders was removed.", new Object[]{this.workspace, this.parentPath, this.deletedFoldersCount});
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while deleting JCR folder structure " + this.workspace + ":" + this.parentPath, e);
        }
        finally {
            this.restoreDefaultTransactionTimeOut();
        }
    }

    private Session getSession(Session session) throws RepositoryException {
        if (session == null || !((SessionImpl)session).isLive()) {
            try {
                session.save();
            }
            catch (Exception e) {
                LOG.trace((Object)"Error committing transaction", (Throwable)e);
            }
            session = this.repositoryService.getCurrentRepository().getSystemSession(this.workspace);
            ((SessionImpl)session).setTimeout(86400000L);
        }
        return session;
    }

    private void removeRecursively(Node parentNode) throws RepositoryException {
        if (this.deletedFoldersCount > 0 && this.deletedFoldersCount % 100 == 0) {
            parentNode.getSession().save();
            LOG.info("{} folders are removed", new Object[]{this.deletedFoldersCount});
        }
        if (parentNode.hasNodes()) {
            NodeIterator nodes = parentNode.getNodes();
            while (nodes.hasNext()) {
                ++this.deletedFoldersCount;
                Node childNode = nodes.nextNode();
                this.removeRecursively(childNode);
                childNode.remove();
            }
        }
    }

    private void increaseCurrentTransactionTimeOut() {
        try {
            this.transactionService.setTransactionTimeout(86400);
        }
        catch (Exception e) {
            LOG.warn((Object)"Cannot Change Transaction timeout", (Throwable)e);
        }
        try {
            ManageableRepository repo = this.repositoryService.getCurrentRepository();
            if (this.defaultJCRSessionTimeout == 0L) {
                this.defaultJCRSessionTimeout = repo.getConfiguration().getSessionTimeOut();
            }
            repo.getConfiguration().setSessionTimeOut(86400000L);
        }
        catch (Exception e) {
            LOG.warn((Object)"Cannot Change JCR Session timeout", (Throwable)e);
        }
    }

    private void restoreDefaultTransactionTimeOut() {
        if (this.defaultJCRSessionTimeout == 0L) {
            return;
        }
        try {
            ManageableRepository repo = this.repositoryService.getCurrentRepository();
            repo.getConfiguration().setSessionTimeOut(this.defaultJCRSessionTimeout);
        }
        catch (Exception e) {
            LOG.warn((Object)"Cannot Change JCR Session timeout", (Throwable)e);
        }
    }
}

