/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.webui;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.wiki.commons.Utils;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.PageVersion;
import org.exoplatform.wiki.rendering.RenderingService;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.utils.VersionNameComparatorDesc;
import org.exoplatform.wiki.webui.UIWikiPortlet;
import org.exoplatform.wiki.webui.WikiMode;
import org.exoplatform.wiki.webui.control.UIRelatedPagesContainer;
import org.exoplatform.wiki.webui.control.action.ShowHistoryActionListener;
import org.exoplatform.wiki.webui.control.action.ViewRevisionActionListener;
import org.exoplatform.wiki.webui.core.UIWikiContainer;
import org.xwiki.rendering.syntax.Syntax;

@ComponentConfig(template="app:/templates/wiki/webui/UIWikiPageInfo.gtmpl", events={@EventConfig(listeners={ViewRevisionActionListener.class}), @EventConfig(listeners={ShowHistoryActionListener.class})})
public class UIWikiPageInfo
extends UIWikiContainer {
    private static final Log log = ExoLogger.getLogger(UIWikiPageInfo.class);
    private static final int NUMBER_OF_SHOWN_CHANGES = 5;
    private WikiService wikiService = (WikiService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WikiService.class);

    public UIWikiPageInfo() throws Exception {
        this.accept_Modes = Arrays.asList(WikiMode.PAGEINFO);
        this.addChild(UIRelatedPagesContainer.class, null, null);
    }

    protected List<PageVersion> getVersionList(Page page) {
        List versions = null;
        try {
            versions = this.wikiService.getVersionsOfPage(page);
            Collections.sort(versions, new VersionNameComparatorDesc());
            return versions.subList(0, versions.size() > 5 ? 5 : versions.size());
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("getting version list of page %s failed", page.getName()), (Throwable)e);
            }
            return versions;
        }
    }

    protected String getPageLink(Page page) throws Exception {
        WikiPageParams params = org.exoplatform.wiki.utils.Utils.getWikiPageParams((Page)page);
        return Utils.getURLFromParams(params);
    }

    protected String renderHierarchy() throws Exception {
        RenderingService renderingService = (RenderingService)PortalContainer.getComponent(RenderingService.class);
        Utils.setUpWikiContext((UIWikiPortlet)this.getAncestorOfType(UIWikiPortlet.class));
        String content = renderingService.render("{{pagetree /}}", Syntax.XWIKI_2_0.toIdString(), Syntax.XHTML_1_0.toIdString(), false);
        Utils.removeWikiContext();
        return content;
    }

    protected Page getCurrentPage() throws Exception {
        return Utils.getCurrentWikiPage();
    }

    protected Page getCurrentParentPage() throws Exception {
        return this.wikiService.getParentPageOf(this.getCurrentPage());
    }
}

