/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.pom.data.ApplicationData;
import org.exoplatform.portal.pom.data.ModelChange;
import org.exoplatform.portal.pom.data.ModelData;
import org.exoplatform.portal.pom.data.ModelDataStorage;
import org.exoplatform.portal.pom.data.PageData;
import org.exoplatform.portal.pom.data.PageKey;
import org.exoplatform.portal.pom.data.PortalData;
import org.exoplatform.portal.pom.data.PortalKey;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.listener.ListenerService;

public class DataStorageImpl
implements DataStorage {
    private ModelDataStorage delegate;
    private ListenerService listenerServ_;
    private Container sharedLayout = null;

    public DataStorageImpl(CacheService cacheService, ModelDataStorage delegate, ListenerService listenerServ) {
        this.delegate = delegate;
        this.listenerServ_ = listenerServ;
    }

    @Override
    public Page clonePage(String pageId, String clonedOwnerType, String clonedOwnerId, String clonedName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void create(PortalConfig config) throws Exception {
        this.delegate.create(config.build());
        this.listenerServ_.broadcast(PORTAL_CONFIG_CREATED, (Object)this, (Object)config);
    }

    @Override
    public void save(PortalConfig config) throws Exception {
        this.delegate.save(config.build());
        this.listenerServ_.broadcast(PORTAL_CONFIG_UPDATED, (Object)this, (Object)config);
    }

    @Override
    public void remove(PortalConfig config) throws Exception {
        this.delegate.remove(config.build());
        this.listenerServ_.broadcast(PORTAL_CONFIG_REMOVED, (Object)this, (Object)config);
    }

    @Override
    public void create(Page page) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ModelChange> save(Page page) throws Exception {
        List<ModelChange> changes = this.delegate.save(page.build());
        this.listenerServ_.broadcast(PAGE_UPDATED, (Object)this, (Object)page);
        return changes;
    }

    @Override
    public void remove(Page page) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <S> S load(ApplicationState<S> state, ApplicationType<S> type) throws Exception {
        return this.delegate.load(state, type);
    }

    @Override
    public <S> ApplicationState<S> save(ApplicationState<S> state, S preferences) throws Exception {
        return this.delegate.save(state, preferences);
    }

    @Override
    public Container getSharedLayout() throws Exception {
        if (PropertyManager.isDevelopping() || this.sharedLayout == null) {
            this.sharedLayout = this.delegate.getSharedLayout();
        }
        return this.sharedLayout;
    }

    @Override
    public PortalConfig getPortalConfig(String portalName) throws Exception {
        return this.getPortalConfig(PortalConfig.PORTAL_TYPE, portalName);
    }

    @Override
    public Page getPage(String pageId) throws Exception {
        PageKey key = PageKey.create(pageId);
        PageData data = this.delegate.getPage(key);
        return data != null ? new Page(data) : null;
    }

    @Override
    public List<String> getAllPortalNames() throws Exception {
        Query<PortalKey> q = new Query<PortalKey>("portal", null, PortalKey.class);
        List keys = this.delegate.find(q).getAll();
        LinkedList<String> list = new LinkedList<String>();
        for (PortalKey key : keys) {
            list.add(key.getId());
        }
        return list;
    }

    @Override
    public List<String> getAllGroupNames() throws Exception {
        Query<PortalKey> q = new Query<PortalKey>("group", null, PortalKey.class);
        List keys = this.delegate.find(q).getAll();
        LinkedList<String> list = new LinkedList<String>();
        for (PortalKey key : keys) {
            list.add(key.getId());
        }
        return list;
    }

    @Override
    public <T> ListAccess<T> find2(Query<T> q) throws Exception {
        return this.find2(q, null);
    }

    @Override
    public <T> LazyPageList<T> find(Query<T> q, Comparator<T> sortComparator) throws Exception {
        return new LazyPageList(this.find2(q, sortComparator), 10);
    }

    @Override
    public <T> ListAccess<T> find2(Query<T> q, Comparator<T> sortComparator) throws Exception {
        Class<T> type = q.getClassType();
        if (type == Page.class) {
            Bilto<Page, PageData> bilto = new Bilto<Page, PageData>(q, PageData.class, sortComparator){

                @Override
                protected Page create(PageData pageData) {
                    return new Page(pageData);
                }
            };
            return bilto.execute();
        }
        if (type == PortalConfig.class) {
            Bilto<PortalConfig, PortalData> bilto = new Bilto<PortalConfig, PortalData>(q, PortalData.class, sortComparator){

                @Override
                protected PortalConfig create(PortalData portalData) {
                    return new PortalConfig(portalData);
                }
            };
            return bilto.execute();
        }
        throw new UnsupportedOperationException("Cannot query type " + type);
    }

    @Override
    public <T> LazyPageList<T> find(Query<T> q) throws Exception {
        return this.find(q, null);
    }

    @Override
    public <S> String getId(ApplicationState<S> state) throws Exception {
        return this.delegate.getId(state);
    }

    @Override
    public void save() throws Exception {
        this.delegate.save();
    }

    @Override
    public PortalConfig getPortalConfig(String ownerType, String portalName) throws Exception {
        PortalKey key = new PortalKey(ownerType, portalName);
        PortalData data = this.delegate.getPortalConfig(key);
        return data != null ? new PortalConfig(data) : null;
    }

    @Override
    public <A> A adapt(ModelObject modelObject, Class<A> type) {
        return this.delegate.adapt(modelObject.build(), type);
    }

    @Override
    public <A> A adapt(ModelObject modelObject, Class<A> type, boolean create) {
        return this.delegate.adapt(modelObject.build(), type, create);
    }

    @Override
    public String[] getSiteInfo(String applicationStorageId) throws Exception {
        return this.delegate.getSiteInfo(applicationStorageId);
    }

    @Override
    public <S> Application<S> getApplicationModel(String applicationStorageId) throws Exception {
        ApplicationData applicationData = this.delegate.getApplicationData(applicationStorageId);
        return new Application(applicationData);
    }

    private abstract class Bilto<O extends ModelObject, D extends ModelData> {
        final Query<O> q;
        final Class<D> dataType;
        final Comparator<O> cp;

        Bilto(Query<O> q, Class<D> dataType) {
            this.q = q;
            this.dataType = dataType;
            this.cp = null;
        }

        Bilto(Query<O> q, Class<D> dataType, Comparator<O> cp) {
            this.q = q;
            this.dataType = dataType;
            this.cp = cp;
        }

        protected abstract O create(D var1);

        ListAccess<O> execute() throws Exception {
            Query<D> delegateQ = new Query<D>(this.q, this.dataType);
            LazyPageList<D> r = DataStorageImpl.this.delegate.find(delegateQ, null);
            List<D> tmp = r.getAll();
            final List<D> list = tmp = this.sort(tmp, this.cp);
            return new ListAccess<O>(){

                public int getSize() throws Exception {
                    return list.size();
                }

                public O[] load(int index, int length) throws Exception {
                    ModelObject[] pages = (ModelObject[])Array.newInstance(Bilto.this.q.getClassType(), length);
                    int i = 0;
                    for (ModelData data : list.subList(index, index + length)) {
                        pages[i++] = Bilto.this.create(data);
                    }
                    return pages;
                }
            };
        }

        private List<D> sort(List<D> list, final Comparator<O> comparator) {
            if (comparator != null) {
                ArrayList<D> tmpList = new ArrayList<D>();
                for (int i = 0; i < list.size(); ++i) {
                    tmpList.add(list.get(i));
                }
                Collections.sort(tmpList, new Comparator<D>(){

                    @Override
                    public int compare(D d1, D d2) {
                        Object o1 = Bilto.this.create(d1);
                        Object o2 = Bilto.this.create(d2);
                        return comparator.compare(o1, o2);
                    }
                });
                return tmpList;
            }
            return list;
        }
    }
}

