/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.plugin.doc.selector;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.jcr.Node;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.RequestContext;

public class BreadcrumbLocation {
    private List<Object> breadCrumb = new ArrayList<Object>();
    private List<String> breadCrumbTitle = new ArrayList<String>();

    public String getBreadCrumbTitle(Object element) throws Exception {
        if (element instanceof DriveData) {
            return BreadcrumbLocation.getDriveTitle((DriveData)element);
        }
        int index = this.breadCrumb.indexOf(element);
        if (index >= 0) {
            return this.breadCrumbTitle.get(index);
        }
        return null;
    }

    public void addLocation(Object location) throws Exception {
        if (location == null) {
            throw new IllegalArgumentException("location is mandatory");
        }
        if (location instanceof DriveData) {
            DriveData driveData = (DriveData)location;
            this.breadCrumb.add(driveData);
            this.breadCrumbTitle.add(BreadcrumbLocation.getDriveTitle(driveData));
        } else if (location instanceof String) {
            String selectedPath = (String)location;
            DriveData driveData = (DriveData)this.breadCrumb.get(0);
            this.breadCrumb.add(selectedPath);
            this.breadCrumbTitle.add(BreadcrumbLocation.getFolderTitle(BreadcrumbLocation.getNode(driveData.getWorkspace(), selectedPath)));
        } else {
            throw new IllegalStateException("Unhandled location class type: " + location);
        }
    }

    public Node getCurrentFolder() throws Exception {
        if (this.breadCrumb.isEmpty()) {
            return null;
        }
        DriveData drive = (DriveData)this.breadCrumb.get(0);
        String path = null;
        path = this.breadCrumb.size() == 1 ? BreadcrumbLocation.getDriveHomePath(drive) : (String)this.breadCrumb.get(this.breadCrumb.size() - 1);
        String repositoryName = WCMCoreUtils.getRepository().getConfiguration().getName();
        String folderExpression = repositoryName + ":" + drive.getWorkspace() + ":" + path;
        return NodeLocation.getNodeByExpression((String)folderExpression);
    }

    public String getCurrentFolderTitle() {
        if (this.breadCrumbTitle.isEmpty()) {
            return null;
        }
        return this.breadCrumbTitle.get(this.breadCrumbTitle.size() - 1);
    }

    public String getCurrentFolderBreadcrumb() {
        if (this.breadCrumbTitle.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(this.breadCrumbTitle.get(0));
        for (int i = 1; i < this.breadCrumbTitle.size(); ++i) {
            stringBuilder.append(" > ").append(this.breadCrumbTitle.get(i));
        }
        return stringBuilder.toString();
    }

    public boolean isEmpty() {
        return this.breadCrumb.isEmpty();
    }

    public String getWorkspace() {
        if (!this.breadCrumb.isEmpty() && this.breadCrumb.get(0) instanceof DriveData) {
            return ((DriveData)this.breadCrumb.get(0)).getWorkspace();
        }
        return null;
    }

    public List<Object> getBreadCrumb() {
        return this.breadCrumb;
    }

    public void subList(int i, int j) {
        this.breadCrumb = this.breadCrumb.subList(i, j);
        this.breadCrumbTitle = this.breadCrumbTitle.subList(i, j);
    }

    public int size() {
        return this.breadCrumb.size();
    }

    public boolean isFolder() {
        return !this.breadCrumb.isEmpty();
    }

    public static String getDriveHomePath(DriveData driveData) throws Exception {
        String homePath = driveData.getHomePath();
        if (homePath.contains("${userId}")) {
            homePath = Utils.getPersonalDrivePath((String)homePath, (String)Util.getPortalRequestContext().getRemoteUser());
        }
        return homePath;
    }

    public static String getGroupLabel(String groupId, boolean isFull) {
        String ret = groupId.replace(".", " / ");
        if (!isFull) {
            if (ret.startsWith(" / spaces")) {
                return ret.substring(ret.lastIndexOf("/") + 1).trim();
            }
            int count = 0;
            int slashPosition = -1;
            for (int i = 0; i < ret.length(); ++i) {
                if ('/' != ret.charAt(i) || ++count != 4) continue;
                slashPosition = i;
                break;
            }
            if (slashPosition > 0) {
                ret = ret.substring(0, slashPosition) + "...";
            } else if (ret.length() > 70) {
                ret = ret.substring(0, 70) + "...";
            }
        }
        return ret;
    }

    public static String getLabel(String id) {
        RequestContext context = RequestContext.getCurrentInstance();
        if (context == null) {
            return id;
        }
        ResourceBundle res = context.getApplicationResourceBundle();
        if (res == null) {
            return id;
        }
        try {
            PortalRequestContext ctx;
            String userDisplayName = "";
            if ("User Documents".equals(id) && (ctx = Util.getPortalRequestContext()) != null) {
                String username = ctx.getRemoteUser();
                try {
                    User user = ((OrganizationService)CommonsUtils.getService(OrganizationService.class)).getUserHandler().findUserByName(username);
                    if (user != null) {
                        userDisplayName = user.getDisplayName();
                    }
                }
                catch (Exception ex) {
                    userDisplayName = username;
                }
            }
            return res.getString("Drives.label." + id.replace(" ", "")).replace("{0}", userDisplayName);
        }
        catch (Exception ex) {
            return id;
        }
    }

    public static String getDriveTitle(DriveData drive) throws Exception {
        String name = drive.getName();
        if (name == null) {
            return null;
        }
        if (name.startsWith(".")) {
            String groupLabel = BreadcrumbLocation.getGroupLabel(drive);
            if (groupLabel == null) {
                groupLabel = BreadcrumbLocation.getGroupLabel(name, !name.startsWith("/spaces"));
            }
            return groupLabel;
        }
        return BreadcrumbLocation.getLabel(name);
    }

    public static String getGroupLabel(DriveData driveData) throws Exception {
        try {
            RepositoryService repoService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
            NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)WCMCoreUtils.getService(NodeHierarchyCreator.class);
            String groupPath = nodeHierarchyCreator.getJcrPath("groupsPath");
            String absPath = groupPath + driveData.getName().replace(".", "/");
            ManageableRepository currentRepository = repoService.getCurrentRepository();
            String workspace = currentRepository.getConfiguration().getDefaultWorkspaceName();
            return BreadcrumbLocation.getNode(workspace, absPath).getProperty("exo:driveLabel").getString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Node getNode(String workspace, String absPath) throws Exception {
        RepositoryService repoService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
        ManageableRepository currentRepository = repoService.getCurrentRepository();
        Node groupNode = (Node)WCMCoreUtils.getSystemSessionProvider().getSession(workspace, currentRepository).getItem(absPath);
        return groupNode;
    }

    public static String getFolderTitle(Node folderNode) throws Exception {
        return org.exoplatform.ecm.webui.utils.Utils.getTitle((Node)folderNode);
    }
}

