/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.apt;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import org.chromattic.apt.Instrumented;
import org.chromattic.spi.instrument.MethodHandler;
import org.chromattic.spi.instrument.ProxyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyTypeImpl<O>
implements ProxyType<O> {
    private final Constructor<? extends O> ctor;
    private final Field f;

    public ProxyTypeImpl(Class<O> objectClass) {
        Field handler;
        Constructor<?> ctor;
        try {
            ClassLoader classLoader = objectClass.getClassLoader();
            Class<?> proxyClass = classLoader.loadClass(objectClass.getName() + "_Chromattic");
            ctor = proxyClass.getConstructor(MethodHandler.class);
            handler = proxyClass.getField("handler");
        }
        catch (Exception e) {
            AssertionError ae = new AssertionError((Object)("Could not create proxy type for " + objectClass));
            ((Throwable)((Object)ae)).initCause(e);
            throw ae;
        }
        this.ctor = ctor;
        this.f = handler;
    }

    public MethodHandler getInvoker(Object proxy) {
        if (proxy instanceof Instrumented) {
            try {
                return (MethodHandler)this.f.get(proxy);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
        return null;
    }

    public O createProxy(MethodHandler handler) {
        try {
            return this.ctor.newInstance(handler);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public Class<? extends O> getType() {
        return this.ctor.getDeclaringClass();
    }
}

