/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.fastcontentcreator.config.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.ecm.utils.lock.LockUtil;
import org.exoplatform.ecm.webui.form.UIDialogForm;
import org.exoplatform.ecm.webui.nodetype.selector.UINodeTypeSelector;
import org.exoplatform.ecm.webui.selector.ComponentSelector;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.tree.selectone.UIOneNodePathSelector;
import org.exoplatform.ecm.webui.utils.DialogFormUtil;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.cms.JcrInputProperty;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.fastcontentcreator.UIFCCPortlet;
import org.exoplatform.wcm.webui.fastcontentcreator.UIFCCUtils;
import org.exoplatform.wcm.webui.fastcontentcreator.config.UIFCCConfig;
import org.exoplatform.wcm.webui.fastcontentcreator.config.action.UIFCCActionList;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.UIFormMultiValueInputSet;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={UIDialogForm.OnchangeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CloseActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ShowComponentActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveReferenceActionListener.class}, confirm="DialogFormField.msg.confirm-delete", phase=Event.Phase.DECODE)})
public class UIFCCActionForm
extends UIDialogForm
implements UISelectable {
    private String parentPath_;
    private String nodeTypeName_ = null;
    private String scriptPath_ = null;
    private String rootPath_ = null;
    private boolean isAddNew = false;
    private static final String EXO_ACTIONS = "exo:actions";

    public UIFCCActionForm() throws Exception {
        this.setActions(new String[]{"Save", "Close"});
    }

    public void createNewAction(Node parentNode, String actionType, boolean isAddNew) throws Exception {
        this.reset();
        this.parentPath_ = parentNode.getPath();
        this.nodeTypeName_ = actionType;
        this.componentSelectors.clear();
        this.properties.clear();
        this.isAddNew = isAddNew;
        this.getChildren().clear();
    }

    private Node getParentNode(Node node) throws Exception {
        return (Node)node.getSession().getItem(this.parentPath_);
    }

    public void renderField(String name) throws Exception {
        UIComponent uiInput = this.findComponentById(name);
        if ("homePath".equals(name)) {
            String homPath = UIFCCUtils.getPreferenceWorkspace() + ":" + this.parentPath_;
            if (homPath.endsWith("/")) {
                homPath = homPath.substring(0, homPath.length() - 1);
            }
            ((UIFormStringInput)uiInput).setValue((Object)homPath);
        }
        if ("targetPath".equals(name) && this.isOnchange() && !this.isUpdateSelect) {
            ((UIFormStringInput)uiInput).reset();
        }
        super.renderField(name);
    }

    public void doSelect(String selectField, Object value) throws Exception {
        this.isUpdateSelect = true;
        UIComponent uicomponent = this.getChildById(selectField);
        if (UIFormStringInput.class.isInstance(uicomponent)) {
            ((UIFormStringInput)uicomponent).setValue((Object)value.toString());
        } else if (UIFormMultiValueInputSet.class.isInstance(uicomponent)) {
            ((UIFormMultiValueInputSet)uicomponent).setValue((List)((ArrayList)value));
        }
    }

    public String getCurrentPath() throws Exception {
        UIFCCPortlet fastContentCreatorPortlet = (UIFCCPortlet)this.getAncestorOfType(UIFCCPortlet.class);
        UIFCCConfig fastContentCreatorConfig = (UIFCCConfig)fastContentCreatorPortlet.getChild(UIFCCConfig.class);
        return fastContentCreatorConfig.getSavedLocationNode().getPath();
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        DMSConfiguration dmsConfiguration = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
        DMSRepositoryConfiguration repositoryConfiguration = dmsConfiguration.getConfig();
        return new JCRResourceResolver(repositoryConfiguration.getSystemWorkspace());
    }

    public String getTemplate() {
        return this.getDialogPath();
    }

    public String getDialogPath() {
        this.repositoryName = UIFCCUtils.getPreferenceRepository();
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        String userName = Util.getPortalRequestContext().getRemoteUser();
        String dialogPath = null;
        if (this.nodeTypeName_ != null) {
            try {
                dialogPath = templateService.getTemplatePathByUser(true, this.nodeTypeName_, userName);
            }
            catch (Exception e) {
                Utils.createPopupMessage((UIContainer)this, (String)"UIFCCForm.msg.get-dialog-path", null, (int)0);
            }
        }
        return dialogPath;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getTemplateNodeType() {
        return this.nodeTypeName_;
    }

    public String getPath() {
        return this.scriptPath_;
    }

    public void setRootPath(String rootPath) {
        this.rootPath_ = rootPath;
    }

    public String getRootPath() {
        return this.rootPath_;
    }

    public void onchange(Event<?> event) throws Exception {
        if (!this.isAddNew) {
            event.getRequestContext().addUIComponentToUpdateByAjax(this.getParent());
            return;
        }
    }

    public static class ShowComponentActionListener
    extends EventListener<UIFCCActionForm> {
        public void execute(Event<UIFCCActionForm> event) throws Exception {
            String[] stringArray;
            UIFCCActionForm fastContentCreatorActionForm = (UIFCCActionForm)((Object)event.getSource());
            UIContainer uiContainer = (UIContainer)fastContentCreatorActionForm.getParent();
            fastContentCreatorActionForm.isShowingComponent = true;
            String fieldName = event.getRequestContext().getRequestParameter("objectId");
            Map fieldPropertiesMap = (Map)fastContentCreatorActionForm.componentSelectors.get(fieldName);
            String classPath = (String)fieldPropertiesMap.get("selectorClass");
            String rootPath = (String)fieldPropertiesMap.get("rootPath");
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = Class.forName(classPath, true, cl);
            UIComponent uiComp = uiContainer.createUIComponent(clazz, null, null);
            String repositoryName = fastContentCreatorActionForm.getRepositoryName();
            String selectorParams = (String)fieldPropertiesMap.get("selectorParams");
            if (uiComp instanceof UIOneNodePathSelector) {
                String[] arrParams;
                String wsFieldName = (String)fieldPropertiesMap.get("workspaceField");
                String wsName = "";
                if (wsFieldName != null && wsFieldName.length() > 0) {
                    wsName = (String)((UIFormInputBase)fastContentCreatorActionForm.getUIInput(wsFieldName)).getValue();
                    ((UIOneNodePathSelector)uiComp).setIsDisable(wsName, true);
                }
                if (selectorParams != null && (arrParams = selectorParams.split(",")).length == 4) {
                    ((UIOneNodePathSelector)uiComp).setAcceptedNodeTypesInPathPanel(new String[]{"nt:file"});
                    wsName = arrParams[1];
                    rootPath = arrParams[2];
                    ((UIOneNodePathSelector)uiComp).setIsDisable(wsName, true);
                    if (arrParams[3].indexOf(";") > -1) {
                        ((UIOneNodePathSelector)uiComp).setAcceptedMimeTypes(arrParams[3].split(";"));
                    } else {
                        ((UIOneNodePathSelector)uiComp).setAcceptedMimeTypes(new String[]{arrParams[3]});
                    }
                }
                if (rootPath == null) {
                    rootPath = "/";
                }
                ((UIOneNodePathSelector)uiComp).setRootNodeLocation(UIFCCUtils.getPreferenceRepository(), wsName, rootPath);
                ((UIOneNodePathSelector)uiComp).setShowRootPathSelect(true);
                ((UIOneNodePathSelector)uiComp).init(WCMCoreUtils.getUserSessionProvider());
            } else if (uiComp instanceof UINodeTypeSelector) {
                ((UINodeTypeSelector)uiComp).setRepositoryName(repositoryName);
                UIFormMultiValueInputSet uiFormMultiValueInputSet = (UIFormMultiValueInputSet)fastContentCreatorActionForm.getChildById(fieldName);
                List values = uiFormMultiValueInputSet.getValue();
                ((UINodeTypeSelector)uiComp).init(1, values);
            }
            Utils.createPopupWindow((UIContainer)fastContentCreatorActionForm, (UIComponent)uiComp, (String)"UIFCCSelectorPopupWindow", (int)640);
            String param = "returnField=" + fieldName;
            if (selectorParams == null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = param;
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = param;
                stringArray = stringArray3;
                stringArray3[1] = "selectorParams=" + selectorParams;
            }
            String[] params = stringArray;
            ((ComponentSelector)uiComp).setSourceComponent((UIComponent)fastContentCreatorActionForm, params);
            if (fastContentCreatorActionForm.isAddNew) {
                uiContainer.setRendered(true);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiContainer);
        }
    }

    public static class RemoveReferenceActionListener
    extends EventListener<UIFCCActionForm> {
        public void execute(Event<UIFCCActionForm> event) throws Exception {
            UIFCCActionForm fastContentCreatorActionForm = (UIFCCActionForm)((Object)event.getSource());
            fastContentCreatorActionForm.isRemovePreference = true;
            String fieldName = event.getRequestContext().getRequestParameter("objectId");
            fastContentCreatorActionForm.getUIStringInput(fieldName).setValue(null);
            event.getRequestContext().addUIComponentToUpdateByAjax(fastContentCreatorActionForm.getParent());
        }
    }

    public static class CloseActionListener
    extends EventListener<UIFCCActionForm> {
        public void execute(Event<UIFCCActionForm> event) throws Exception {
            UIFCCActionForm fastContentCreatorActionForm = (UIFCCActionForm)((Object)event.getSource());
            Utils.closePopupWindow((UIContainer)fastContentCreatorActionForm, (String)"UIFCCActionPopupWindow");
        }
    }

    public static class SaveActionListener
    extends EventListener<UIFCCActionForm> {
        public void execute(Event<UIFCCActionForm> event) throws Exception {
            UIFCCActionForm fccActionForm = (UIFCCActionForm)((Object)event.getSource());
            UIApplication uiApp = (UIApplication)fccActionForm.getAncestorOfType(UIApplication.class);
            UIFCCPortlet fastContentCreatorPortlet = (UIFCCPortlet)fccActionForm.getAncestorOfType(UIFCCPortlet.class);
            UIFCCConfig fastContentCreatorConfig = (UIFCCConfig)fastContentCreatorPortlet.getChild(UIFCCConfig.class);
            Node currentNode = fastContentCreatorConfig.getSavedLocationNode();
            if (!PermissionUtil.canAddNode((Node)currentNode) || !PermissionUtil.canSetProperty((Node)currentNode)) {
                uiApp.addMessage(new ApplicationMessage("UIFastContentCreatorActionForm.msg.no-permission-add", null));
                return;
            }
            UIFCCActionList fastContentCreatorActionList = null;
            Map sortedInputs = DialogFormUtil.prepareMap((List)fccActionForm.getChildren(), (Map)fccActionForm.getInputProperties(), (Map)fccActionForm.getInputOptions());
            if (!fccActionForm.isAddNew) {
                CmsService cmsService = (CmsService)fccActionForm.getApplicationComponent(CmsService.class);
                Node storedHomeNode = fccActionForm.getParentNode(currentNode).getNode(UIFCCActionForm.EXO_ACTIONS);
                cmsService.storeNode(fccActionForm.nodeTypeName_, storedHomeNode, sortedInputs, false);
                storedHomeNode.getSession().save();
            } else {
                String lockToken;
                if (currentNode.isLocked() && (lockToken = LockUtil.getLockToken((Node)currentNode)) != null) {
                    currentNode.getSession().addLockToken(lockToken);
                }
                try {
                    JcrInputProperty rootProp = (JcrInputProperty)sortedInputs.get("/node");
                    if (rootProp == null) {
                        rootProp = new JcrInputProperty();
                        rootProp.setJcrPath("/node");
                        rootProp.setValue(((JcrInputProperty)sortedInputs.get("/node/exo:name")).getValue());
                        sortedInputs.put("/node", rootProp);
                    } else {
                        rootProp.setValue(((JcrInputProperty)sortedInputs.get("/node/exo:name")).getValue());
                    }
                    String actionName = (String)((JcrInputProperty)sortedInputs.get("/node/exo:name")).getValue();
                    Node parentNode = fccActionForm.getParentNode(currentNode);
                    if (parentNode.hasNode(UIFCCActionForm.EXO_ACTIONS) && parentNode.getNode(UIFCCActionForm.EXO_ACTIONS).hasNode(actionName)) {
                        Object[] args = new Object[]{actionName};
                        uiApp.addMessage(new ApplicationMessage("UIFastContentCreatorActionForm.msg.existed-action", args, 1));
                        return;
                    }
                    if (parentNode.isNew()) {
                        Object[] args = new String[]{parentNode.getPath()};
                        uiApp.addMessage(new ApplicationMessage("UIFastContentCreatorActionForm.msg.unable-add-action", args));
                        return;
                    }
                    ActionServiceContainer actionServiceContainer = (ActionServiceContainer)fccActionForm.getApplicationComponent(ActionServiceContainer.class);
                    actionServiceContainer.addAction(parentNode, fccActionForm.nodeTypeName_, sortedInputs);
                    fccActionForm.setIsOnchange(false);
                    parentNode.getSession().save();
                    fccActionForm.createNewAction(fastContentCreatorConfig.getSavedLocationNode(), fccActionForm.nodeTypeName_, true);
                    fastContentCreatorActionList = (UIFCCActionList)fastContentCreatorConfig.findFirstComponentOfType(UIFCCActionList.class);
                    fastContentCreatorActionList.updateGrid(parentNode, ((UIGrid)fastContentCreatorActionList.getChild(UIGrid.class)).getUIPageIterator().getCurrentPage());
                    fccActionForm.reset();
                }
                catch (RepositoryException repo) {
                    String key = "UIFastContentCreatorActionForm.msg.repository-exception";
                    uiApp.addMessage(new ApplicationMessage(key, null, 1));
                    return;
                }
                catch (NumberFormatException nume) {
                    String key = "UIFastContentCreatorActionForm.msg.numberformat-exception";
                    uiApp.addMessage(new ApplicationMessage(key, null, 1));
                    return;
                }
                catch (NullPointerException nullPointerException) {
                    uiApp.addMessage(new ApplicationMessage("UIFastContentCreatorActionForm.msg.unable-add", null, 1));
                    return;
                }
                catch (Exception e) {
                    uiApp.addMessage(new ApplicationMessage("UIFastContentCreatorActionForm.msg.unable-add", null, 1));
                    return;
                }
            }
            Utils.closePopupWindow((UIContainer)fccActionForm, (String)"UIFCCActionPopupWindow");
        }
    }
}

