/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.migration;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.servlet.ServletContext;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.chromattic.ChromatticLifeCycle;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.commons.chromattic.SessionContext;
import org.exoplatform.commons.cluster.StartableClusterAware;
import org.exoplatform.commons.migration.SettingsMigration$AjcClosure1;
import org.exoplatform.commons.migration.SettingsMigration$AjcClosure3;
import org.exoplatform.commons.migration.SettingsMigration$AjcClosure5;
import org.exoplatform.commons.migration.SettingsMigration$AjcClosure7;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.RDBMSMigrationUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.settings.chromattic.ScopeEntity;
import org.exoplatform.settings.chromattic.SimpleContextEntity;
import org.exoplatform.settings.chromattic.SubContextEntity;
import org.exoplatform.settings.chromattic.SynchronizationTask;
import org.exoplatform.settings.jpa.JPASettingServiceImpl;
import org.exoplatform.settings.jpa.JPAUserSettingServiceImpl;

public class SettingsMigration
implements StartableClusterAware {
    private static final Log LOG;
    private JPASettingServiceImpl jpaSettingService;
    private ChromatticLifeCycle chromatticLifeCycle;
    private OrganizationService organizationService;
    private static List<String> allUsers;
    private static List<String> errorUserSettings;
    private static List<String> errorGlobalSettings;
    private static List<String> nonRemovedGlobalSettings;
    private static List<String> nonRemovedUserSettings;
    public static final String SETTINGS_MIGRATION_USER_KEY = "SETTINGS_MIGRATION_USER";
    public static final String SETTINGS_MIGRATION_GLOBAL_KEY = "SETTINGS_MIGRATION_GLOBAL";
    public static final String SETTINGS_JCR_DATA_USER_MIGRATED_KEY = "SETTINGS_JCR_DATA_USER_MIGRATED";
    public static final String SETTINGS_RDBMS_MIGRATION_DONE = "SETTINGS_RDBMS_MIGRATION_DONE";
    public static final String SETTINGS_RDBMS_CLEANUP_DONE = "SETTINGS_RDBMS_CLEANUP_DONE";
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public SettingsMigration(ChromatticManager chromatticManager, OrganizationService organizationService) {
        this.chromatticLifeCycle = chromatticManager.getLifeCycle("setting");
        this.organizationService = organizationService;
    }

    @Override
    public void start() {
        if (this.getJpaSettingService() == null) {
            throw new IllegalStateException("Cannot find JPASettingServiceImpl service instance");
        }
        if (this.hasGlobalSettingsToMigrate().booleanValue()) {
            this.migrateGlobalSettings();
        } else {
            LOG.info((Object)"No global settings data to migrate from JCR to RDBMS");
        }
        if (this.hasUserSettingsToMigrate().booleanValue()) {
            this.migrateUserSettings();
        } else {
            LOG.info((Object)"No user settings data to migrate from JCR to RDBMS");
        }
    }

    public void cleanup() {
        PortalContainer.addInitTask((ServletContext)PortalContainer.getInstance().getPortalContext(), (RootContainer.PortalContainerInitTask)new RootContainer.PortalContainerPostInitTask(){

            public void execute(ServletContext context, PortalContainer portalContainer) {
                RDBMSMigrationUtils.getExecutorService().submit(new Callable<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Void call() throws Exception {
                        PortalContainer currentContainer = PortalContainer.getInstance();
                        ExoContainerContext.setCurrentContainer((ExoContainer)currentContainer);
                        RequestLifeCycle.begin((ExoContainer)currentContainer);
                        try {
                            boolean userSettingsCleaned;
                            boolean globalSettingsCleaned = SettingsMigration.this.isGlobalSettingsCleanupDone();
                            if (!globalSettingsCleaned) {
                                LOG.info((Object)"=== Start cleaning Global Settings data from JCR");
                                long startTime = System.currentTimeMillis();
                                boolean successfulCleaning = SettingsMigration.this.deleteJcrGlobalSettings();
                                long endTime = System.currentTimeMillis();
                                if (successfulCleaning) {
                                    SettingsMigration.this.setGlobalSettingsCleanupDone();
                                    LOG.info((Object)("=== Global Settings JCR data cleaning due to RDBMS migration done in " + (endTime - startTime) + " ms"));
                                } else {
                                    LOG.error((Object)("=== Global Settings JCR data cleaning due to RDBMS migration failed in " + (endTime - startTime) + " ms"));
                                }
                            }
                            if (!(userSettingsCleaned = SettingsMigration.this.isUserSettingsCleanupDone())) {
                                LOG.info((Object)"=== Start cleaning User Settings data from JCR");
                                long startTime = System.currentTimeMillis();
                                boolean successfulCleaning = SettingsMigration.this.deleteJcrUserSettings();
                                long endTime = System.currentTimeMillis();
                                if (successfulCleaning) {
                                    SettingsMigration.this.setUserSettingsCleanupDone();
                                    LOG.info((Object)("=== User Settings JCR data cleaning due to RDBMS migration done in " + (endTime - startTime) + " ms"));
                                } else {
                                    LOG.error((Object)("=== User Settings JCR data cleaning due to RDBMS migration failed in " + (endTime - startTime) + " ms"));
                                }
                                if (SettingsMigration.this.chromatticLifeCycle.getManager().getSynchronization() != null) {
                                    SettingsMigration.this.chromatticLifeCycle.getManager().endRequest(true);
                                }
                            }
                            if (!globalSettingsCleaned || !userSettingsCleaned) {
                                SettingsMigration.this.reportSettingsMigration();
                            }
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Error while cleaning Settings data from JCR", (Throwable)e);
                        }
                        finally {
                            RequestLifeCycle.end();
                        }
                        return null;
                    }
                });
            }
        });
    }

    private void reportSettingsMigration() {
        long notMigrated = this.getJpaSettingService().countSettingsByNameAndValueAndScope(Scope.APPLICATION.id(SETTINGS_MIGRATION_USER_KEY), SETTINGS_RDBMS_MIGRATION_DONE, "false");
        int error = errorUserSettings.size();
        LOG.info((Object)" === User Settings Migration from JCR to RDBBMS report: ");
        LOG.info((Object)("           - " + Math.max(notMigrated, (long)error) + " User Settings nodes are not migrated to RDBMS "));
        LOG.info((Object)("           - " + nonRemovedUserSettings.size() + " User Settings nodes are migrated but not removed from JCR"));
    }

    private Boolean deleteJcrGlobalSettings() {
        return (Boolean)new SynchronizationTask<Boolean>(){

            protected Boolean execute(SessionContext ctx) {
                try {
                    Set<String> globalSettings = SettingsMigration.this.getGlobalSettings();
                    for (String scope : globalSettings) {
                        if (errorGlobalSettings.contains(scope)) continue;
                        SettingsMigration.this.deleteGlobalSettings(scope);
                    }
                    LOG.info((Object)" === Global Settings Migration from JCR to RDBBMS report: ");
                    LOG.info((Object)("           - " + globalSettings.size() + " Global Settings nodes are cleaned from JCR "));
                    LOG.info((Object)("           - " + errorGlobalSettings.size() + " Global Settings nodes are not migrated to RDBMS "));
                    LOG.info((Object)("           - " + nonRemovedGlobalSettings.size() + " Global Settings nodes are migrated but not removed from JCR"));
                    return true;
                }
                catch (Exception e) {
                    LOG.error((Object)("Error while cleaning JCR global settings : " + e.getMessage()), (Throwable)e);
                    return false;
                }
            }
        }.executeWith(this.chromatticLifeCycle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean deleteJcrUserSettings() {
        try {
            PortalContainer currentContainer = PortalContainer.getInstance();
            ExoContainerContext.setCurrentContainer((ExoContainer)currentContainer);
            RequestLifeCycle.begin((ExoContainer)currentContainer);
            int deletedCounter = 0;
            Set<String> jcrSettingsToRemove = this.getJCRUserSettings();
            if (jcrSettingsToRemove != null) {
                int i = 0;
                int totalSize = jcrSettingsToRemove.size();
                for (String user : jcrSettingsToRemove) {
                    ++i;
                    try {
                        if (!errorUserSettings.contains(user) && (this.isSettingsMigrated(user) || this.organizationService.getUserHandler().findUserByName(user, UserStatus.ANY) == null) && this.deleteUserSettings(user).booleanValue()) {
                            ++deletedCounter;
                            this.getJpaSettingService().remove(Context.USER.id(user), Scope.APPLICATION.id(SETTINGS_MIGRATION_USER_KEY), SETTINGS_RDBMS_MIGRATION_DONE);
                        }
                        if (i % 100 != 0) continue;
                        LOG.info("User settings JCR cleanup - progression = {}/{}", new Object[]{i, totalSize});
                        RequestLifeCycle.end();
                        RequestLifeCycle.begin((ExoContainer)currentContainer);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Error while cleaning settings of user " + user + " : " + e.getMessage()), (Throwable)e);
                    }
                }
            }
            LOG.info((Object)" === User settings Migration & Cleanup from JCR to RDBMS report: ");
            LOG.info((Object)("           - " + deletedCounter + " Users with settings are cleaned from JCR "));
            LOG.info((Object)("           - " + errorUserSettings.size() + " User settings nodes are not migrated to RDBMS "));
            LOG.info((Object)("           - " + nonRemovedUserSettings.size() + " Global Settings nodes are migrated but not removed from JCR"));
            Boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOG.error((Object)("Error while cleaning users settings : " + e.getMessage()), (Throwable)e);
            Boolean bl = false;
            return bl;
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    private Boolean migrateGlobalSettings() {
        return (Boolean)new SynchronizationTask<Boolean>(){

            protected Boolean execute(SessionContext ctx) {
                LOG.info((Object)"=== Start migration of Global Settings data from JCR to RDBMS");
                long startTime = System.currentTimeMillis();
                for (String scope : SettingsMigration.this.getGlobalSettings()) {
                    SettingsMigration.this.migrateGlobalSettingsOfGlobalScopes(scope);
                    SettingsMigration.this.migrateGlobalSettingsOfGlobalSpecificScopes(scope);
                }
                long endTime = System.currentTimeMillis();
                LOG.info((Object)("Global Settings data migrated in " + (endTime - startTime) + " ms"));
                return true;
            }
        }.executeWith(this.chromatticLifeCycle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean migrateUserSettings() {
        int pageSize = 20;
        int current = 0;
        try {
            User[] users;
            ListAccess allUsersListAccess = this.organizationService.getUserHandler().findAllUsers(UserStatus.ANY);
            ExoContainerContext.setCurrentContainer((ExoContainer)PortalContainer.getInstance());
            int totalUsers = allUsersListAccess.getSize();
            LOG.info((Object)("    Number of users = " + totalUsers));
            LOG.info((Object)"=== Start migration of User Settings data from JCR");
            ExoContainer currentContainer = ExoContainerContext.getCurrentContainer();
            RequestLifeCycle.begin((ExoContainer)currentContainer);
            long startTime = System.currentTimeMillis();
            do {
                LOG.info("    Progression of users settings migration : {}/{} users", new Object[]{current, totalUsers});
                if (current + pageSize > totalUsers) {
                    pageSize = totalUsers - current;
                }
                for (User user : users = (User[])allUsersListAccess.load(current, pageSize)) {
                    RequestLifeCycle.end();
                    RequestLifeCycle.begin((ExoContainer)currentContainer);
                    String userName = user.getUserName();
                    if (this.isSettingsMigrated(userName)) continue;
                    for (String userScope : this.getUserScopesSettings(userName)) {
                        this.migrateUserSettingsOfGlobalScope(userName, userScope);
                        this.migrateUserSettingsOfSpecificScope(userName, userScope);
                    }
                    allUsers.add(userName);
                    if (errorUserSettings.contains(userName)) {
                        this.getJpaSettingService().set(Context.USER.id(userName), Scope.APPLICATION.id(SETTINGS_MIGRATION_USER_KEY), SETTINGS_RDBMS_MIGRATION_DONE, SettingValue.create((String)"false"));
                        continue;
                    }
                    this.getJpaSettingService().set(Context.USER.id(userName), Scope.APPLICATION.id(SETTINGS_MIGRATION_USER_KEY), SETTINGS_RDBMS_MIGRATION_DONE, SettingValue.create((String)"true"));
                }
                current += users.length;
            } while (users != null && users.length > 0);
            long endTime = System.currentTimeMillis();
            LOG.info((Object)("User Settings data migrated in " + (endTime - startTime) + " ms"));
            if (!errorUserSettings.isEmpty()) {
                this.getJpaSettingService().set(Context.GLOBAL, Scope.APPLICATION.id(SETTINGS_MIGRATION_USER_KEY), SETTINGS_JCR_DATA_USER_MIGRATED_KEY, SettingValue.create((String)"true"));
            } else {
                this.getJpaSettingService().set(Context.GLOBAL, Scope.APPLICATION.id(SETTINGS_MIGRATION_USER_KEY), SETTINGS_JCR_DATA_USER_MIGRATED_KEY, SettingValue.create((String)"false"));
            }
            Boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOG.error((Object)("Error while migrating user settings data from JCR to RDBMS - Cause : " + e.getMessage()), (Throwable)e);
            Boolean bl = false;
            return bl;
        }
        finally {
            RequestLifeCycle.end();
            if (this.chromatticLifeCycle.getManager().getSynchronization() != null) {
                this.chromatticLifeCycle.getManager().endRequest(true);
            }
        }
    }

    private boolean isSettingsMigrated(String userName) {
        SettingValue setting = this.getJpaSettingService().get(Context.USER.id(userName), Scope.APPLICATION.id(SETTINGS_MIGRATION_USER_KEY), SETTINGS_RDBMS_MIGRATION_DONE);
        return setting != null && setting.getValue().equals("true");
    }

    private Set<String> getUserScopesSettings(final String user) {
        return (Set)new SynchronizationTask<Set<String>>(){

            protected Set<String> execute(SessionContext ctx) {
                SimpleContextEntity userSettings = (SimpleContextEntity)ctx.getSession().findByPath(SimpleContextEntity.class, "settings/user/" + user);
                return userSettings == null ? new HashSet() : userSettings.getScopes().keySet();
            }
        }.executeWith(this.chromatticLifeCycle);
    }

    private ScopeEntity getSpecificScope(final String scope) {
        return (ScopeEntity)new SynchronizationTask<ScopeEntity>(){

            protected ScopeEntity execute(SessionContext ctx) {
                ScopeEntity globalSettings = (ScopeEntity)ctx.getSession().findByPath(ScopeEntity.class, "settings/global/" + scope);
                return globalSettings;
            }
        }.executeWith(this.chromatticLifeCycle);
    }

    @ExoTransactional
    private Boolean migrateGlobalSettingsOfGlobalSpecificScopes(String scope) {
        String string = scope;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (Boolean)ExoTransactionalAspect.aspectOf().around(new SettingsMigration$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    private Boolean deleteGlobalSettings(final String scope) {
        return (Boolean)new SynchronizationTask<Boolean>(){

            protected Boolean execute(SessionContext ctx) {
                try {
                    ctx.getSession().remove(ctx.getSession().findByPath(ScopeEntity.class, "settings/global/" + scope));
                    ctx.getSession().save();
                    return true;
                }
                catch (Exception e) {
                    LOG.error((Object)("Cannot remove JCR settings of scope: " + scope + " - cause: " + e.getCause()), (Throwable)e);
                    nonRemovedGlobalSettings.add(scope);
                    return false;
                }
            }
        }.executeWith(this.chromatticLifeCycle);
    }

    private Boolean deleteUserSettings(final String user) {
        return (Boolean)new SynchronizationTask<Boolean>(){

            protected Boolean execute(SessionContext ctx) {
                try {
                    ctx.getSession().remove(ctx.getSession().findByPath(SimpleContextEntity.class, "settings/user/" + user));
                    ctx.getSession().save();
                    return true;
                }
                catch (Exception e) {
                    LOG.error((Object)("Cannot remove JCR settings of user: " + user + " - cause: " + e.getCause()), (Throwable)e);
                    nonRemovedUserSettings.add(user);
                    return false;
                }
            }
        }.executeWith(this.chromatticLifeCycle);
    }

    private ScopeEntity getScopeOfUser(final String user, final String scope) {
        return (ScopeEntity)new SynchronizationTask<ScopeEntity>(){

            protected ScopeEntity execute(SessionContext ctx) {
                ScopeEntity globalSettings = (ScopeEntity)ctx.getSession().findByPath(ScopeEntity.class, "settings/user/" + user + "/" + scope);
                return globalSettings;
            }
        }.executeWith(this.chromatticLifeCycle);
    }

    @ExoTransactional
    private Boolean migrateUserSettingsOfSpecificScope(String user, String scope) {
        String string = user;
        String string2 = scope;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string, (Object)string2);
        Object[] objectArray = new Object[]{this, string, string2, joinPoint};
        return (Boolean)ExoTransactionalAspect.aspectOf().around(new SettingsMigration$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    private Boolean hasGlobalSettingsToMigrate() {
        return (Boolean)new SynchronizationTask<Boolean>(){

            protected Boolean execute(SessionContext ctx) {
                SimpleContextEntity settings = (SimpleContextEntity)ctx.getSession().findByPath(SimpleContextEntity.class, "settings/global");
                return settings != null && settings.getScopes().size() > 0;
            }
        }.executeWith(this.chromatticLifeCycle);
    }

    private Boolean hasUserSettingsToMigrate() {
        try {
            SettingValue setting = this.getJpaSettingService().get(Context.GLOBAL, Scope.APPLICATION.id(SETTINGS_MIGRATION_USER_KEY), SETTINGS_JCR_DATA_USER_MIGRATED_KEY);
            if (setting != null) {
                return setting.getValue().equals("true");
            }
            return (Boolean)new SynchronizationTask<Boolean>(){

                protected Boolean execute(SessionContext ctx) {
                    Set userSettingsToRemove = SettingsMigration.this.getJCRUserSettings();
                    return userSettingsToRemove != null && userSettingsToRemove.size() > 0;
                }
            }.executeWith(this.chromatticLifeCycle);
        }
        catch (Exception e) {
            LOG.error((Object)("Error when defining if there is user settings to migrate in jcr - cause: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    private Set<String> getJCRUserSettings() {
        return (Set)new SynchronizationTask<Set<String>>(){

            protected Set<String> execute(SessionContext ctx) {
                SubContextEntity settings = (SubContextEntity)ctx.getSession().findByPath(SubContextEntity.class, "settings/user");
                return settings != null ? settings.getContexts().keySet() : null;
            }
        }.executeWith(this.chromatticLifeCycle);
    }

    private void setUserSettingsCleanupDone() {
        this.getJpaSettingService().set(Context.GLOBAL, Scope.APPLICATION.id(SETTINGS_MIGRATION_USER_KEY), SETTINGS_RDBMS_CLEANUP_DONE, SettingValue.create((String)"true"));
    }

    private void setGlobalSettingsCleanupDone() {
        this.getJpaSettingService().set(Context.GLOBAL, Scope.APPLICATION.id(SETTINGS_MIGRATION_GLOBAL_KEY), SETTINGS_RDBMS_CLEANUP_DONE, SettingValue.create((String)"true"));
    }

    private boolean isUserSettingsCleanupDone() {
        SettingValue setting = this.getJpaSettingService().get(Context.GLOBAL, Scope.APPLICATION.id(SETTINGS_MIGRATION_USER_KEY), SETTINGS_RDBMS_CLEANUP_DONE);
        return setting != null && setting.getValue().equals("true");
    }

    private boolean isGlobalSettingsCleanupDone() {
        SettingValue setting = this.getJpaSettingService().get(Context.GLOBAL, Scope.APPLICATION.id(SETTINGS_MIGRATION_GLOBAL_KEY), SETTINGS_RDBMS_CLEANUP_DONE);
        return setting != null && setting.getValue().equals("true");
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public void stop() {
        RDBMSMigrationUtils.getExecutorService().shutdown();
    }

    public Set<String> getGlobalSettings() {
        return (Set)new SynchronizationTask<Set<String>>(){

            protected Set<String> execute(SessionContext ctx) {
                SimpleContextEntity globalSettings = (SimpleContextEntity)ctx.getSession().findByPath(SimpleContextEntity.class, "settings/global");
                if (globalSettings != null) {
                    return globalSettings.getScopes().keySet();
                }
                return new HashSet<String>();
            }
        }.executeWith(this.chromatticLifeCycle);
    }

    public ScopeEntity getGlobalScope(final String scope) {
        return (ScopeEntity)new SynchronizationTask<ScopeEntity>(){

            protected ScopeEntity execute(SessionContext ctx) {
                ScopeEntity globalSettings = (ScopeEntity)ctx.getSession().findByPath(ScopeEntity.class, "settings/global/" + scope);
                return globalSettings;
            }
        }.executeWith(this.chromatticLifeCycle);
    }

    @ExoTransactional
    public Boolean migrateGlobalSettingsOfGlobalScopes(String scope) {
        String string = scope;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (Boolean)ExoTransactionalAspect.aspectOf().around(new SettingsMigration$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
    }

    public ScopeEntity getGlobalScopeOfUser(final String user, final String scope) {
        return (ScopeEntity)new SynchronizationTask<ScopeEntity>(){

            protected ScopeEntity execute(SessionContext ctx) {
                ScopeEntity globalSettings = (ScopeEntity)ctx.getSession().findByPath(ScopeEntity.class, "settings/user/" + user + "/" + scope);
                return globalSettings;
            }
        }.executeWith(this.chromatticLifeCycle);
    }

    @ExoTransactional
    public Boolean migrateUserSettingsOfGlobalScope(String user, String scope) {
        String string = user;
        String string2 = scope;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string, (Object)string2);
        Object[] objectArray = new Object[]{this, string, string2, joinPoint};
        return (Boolean)ExoTransactionalAspect.aspectOf().around(new SettingsMigration$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
    }

    public JPASettingServiceImpl getJpaSettingService() {
        if (this.jpaSettingService == null) {
            this.jpaSettingService = CommonsUtils.getService(JPASettingServiceImpl.class);
        }
        return this.jpaSettingService;
    }

    private Scope getScope(String scope, String id) {
        switch (scope) {
            case "windows": {
                return Scope.WINDOWS.id(id);
            }
            case "page": {
                return Scope.PAGE.id(id);
            }
            case "space": {
                return Scope.SPACE.id(id);
            }
            case "site": {
                return Scope.SITE.id(id);
            }
            case "portal": {
                return Scope.PORTAL.id(id);
            }
            case "application": {
                return Scope.APPLICATION.id(id);
            }
            case "global": {
                return Scope.GLOBAL.id(id);
            }
        }
        return null;
    }

    static {
        SettingsMigration.ajc$preClinit();
        LOG = ExoLogger.getLogger(SettingsMigration.class);
        allUsers = new LinkedList<String>();
        errorUserSettings = new LinkedList<String>();
        errorGlobalSettings = new LinkedList<String>();
        nonRemovedGlobalSettings = new LinkedList<String>();
        nonRemovedUserSettings = new LinkedList<String>();
    }

    static /* synthetic */ Boolean migrateGlobalSettingsOfGlobalSpecificScopes_aroundBody0(SettingsMigration ajc$this, String scope, JoinPoint joinPoint) {
        ScopeEntity scopeEntity = ajc$this.getSpecificScope(scope);
        for (String instance : scopeEntity.getInstances().keySet()) {
            Scope specificScope = ajc$this.getScope(scope, instance);
            for (String key : scopeEntity.getInstance(instance).getProperties().keySet()) {
                try {
                    ajc$this.getJpaSettingService().set(Context.GLOBAL, specificScope, key, new SettingValue(scopeEntity.getInstance(instance).getValue(key)));
                }
                catch (Exception e) {
                    errorGlobalSettings.add(scope);
                    LOG.error((Object)("Cannot migrate Global Settings data of specific scope: " + scope + " - cause: " + e.getMessage()), (Throwable)e);
                }
            }
        }
        return true;
    }

    static /* synthetic */ Boolean migrateUserSettingsOfSpecificScope_aroundBody2(SettingsMigration ajc$this, String user, String scope, JoinPoint joinPoint) {
        ScopeEntity scopeEntity = ajc$this.getScopeOfUser(user, scope);
        if (scopeEntity != null) {
            for (String instance : scopeEntity.getInstances().keySet()) {
                Scope specificScope = ajc$this.getScope(scope, instance);
                for (String key : scopeEntity.getInstance(instance).getProperties().keySet()) {
                    try {
                        Scope settingScope = specificScope;
                        if (key.equals("exo:isEnabled")) {
                            settingScope = Scope.GLOBAL.id(null);
                        }
                        ajc$this.getJpaSettingService().set(Context.USER.id(user), settingScope, key, new SettingValue(scopeEntity.getInstance(instance).getValue(key)));
                    }
                    catch (Exception e) {
                        errorUserSettings.add(user);
                        LOG.error((Object)("Cannot migrate User Settings data of user: " + user + " and scope: " + scope + " - cause: " + e.getMessage()), (Throwable)e);
                    }
                }
            }
        }
        return true;
    }

    static /* synthetic */ Boolean migrateGlobalSettingsOfGlobalScopes_aroundBody4(SettingsMigration ajc$this, String scope, JoinPoint joinPoint) {
        ScopeEntity scopeEntity = ajc$this.getGlobalScope(scope);
        Scope globalScope = ajc$this.getScope(scope, null);
        for (String key : scopeEntity.getProperties().keySet()) {
            try {
                ajc$this.getJpaSettingService().set(Context.GLOBAL, globalScope, key, new SettingValue(scopeEntity.getValue(key)));
            }
            catch (Exception e) {
                errorGlobalSettings.add(scope);
                LOG.error((Object)("Cannot migrate Global Settings data of scope: " + scope + " - cause: " + e.getMessage()), (Throwable)e);
            }
        }
        return true;
    }

    static /* synthetic */ Boolean migrateUserSettingsOfGlobalScope_aroundBody6(SettingsMigration ajc$this, String user, String scope, JoinPoint joinPoint) {
        ScopeEntity scopeEntity = ajc$this.getGlobalScopeOfUser(user, scope);
        Scope globalScope = ajc$this.getScope(scope, null);
        if (scopeEntity != null) {
            for (String key : scopeEntity.getProperties().keySet()) {
                try {
                    Scope settingScope = globalScope;
                    if (key.equals("exo:lastReadDate") || key.equals("exo:daily") || key.equals("exo:weekly") || key.equals("exo:isActive") || key.startsWith("exo:") && key.endsWith("Channel")) {
                        settingScope = JPAUserSettingServiceImpl.NOTIFICATION_SCOPE;
                    }
                    ajc$this.getJpaSettingService().set(Context.USER.id(user), settingScope, key, new SettingValue(scopeEntity.getValue(key)));
                }
                catch (Exception e) {
                    errorUserSettings.add(user);
                    LOG.error((Object)("Cannot migrate User Settings data of user: " + user + " and scope: " + scope + " - cause: " + e.getMessage()), (Throwable)e);
                }
            }
        }
        return true;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SettingsMigration.java", SettingsMigration.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "migrateGlobalSettingsOfGlobalSpecificScopes", "org.exoplatform.commons.migration.SettingsMigration", "java.lang.String", "scope", "", "java.lang.Boolean"), 326);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "migrateUserSettingsOfSpecificScope", "org.exoplatform.commons.migration.SettingsMigration", "java.lang.String:java.lang.String", "user:scope", "", "java.lang.Boolean"), 388);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "migrateGlobalSettingsOfGlobalScopes", "org.exoplatform.commons.migration.SettingsMigration", "java.lang.String", "scope", "", "java.lang.Boolean"), 505);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "migrateUserSettingsOfGlobalScope", "org.exoplatform.commons.migration.SettingsMigration", "java.lang.String:java.lang.String", "user:scope", "", "java.lang.Boolean"), 531);
    }
}

