/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.search.connector;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.util.ListHashMap;
import org.exoplatform.commons.api.search.data.SearchContext;
import org.exoplatform.commons.api.search.data.SearchResult;
import org.exoplatform.commons.search.es.ElasticSearchServiceConnector;
import org.exoplatform.commons.search.es.client.ElasticSearchingClient;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.documents.DocumentService;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.search.base.EcmsSearchResult;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.json.simple.JSONObject;

public class FileSearchServiceConnector
extends ElasticSearchServiceConnector {
    private static final Log LOG = ExoLogger.getLogger((String)FileSearchServiceConnector.class.getName());
    private RepositoryService repositoryService;
    private DocumentService documentService;
    StringBuffer downloadUrl;

    public FileSearchServiceConnector(InitParams initParams, ElasticSearchingClient client, RepositoryService repositoryService, DocumentService documentService) {
        super(initParams, client);
        this.repositoryService = repositoryService;
        this.documentService = documentService;
        this.setEnabledForAnonymous(true);
    }

    protected String getSourceFields() {
        List<String> fields = Arrays.asList("name", "title", "workspace", "path", "author", "createdDate", "lastUpdatedDate", "fileType", "fileSize");
        return fields.stream().map(field -> "\"" + field + "\"").collect(Collectors.joining(","));
    }

    protected SearchResult buildHit(JSONObject jsonHit, SearchContext searchContext) {
        boolean isAnonymous;
        SearchResult searchResult = super.buildHit(jsonHit, searchContext);
        JSONObject hitSource = (JSONObject)jsonHit.get((Object)"_source");
        String workspace = (String)hitSource.get((Object)"workspace");
        String nodePath = (String)hitSource.get((Object)"path");
        String fileType = (String)hitSource.get((Object)"fileType");
        String fileSize = (String)hitSource.get((Object)"fileSize");
        String driveName = "";
        try {
            DriveData driveOfNode = this.documentService.getDriveOfNode(nodePath);
            if (driveOfNode != null) {
                driveName = driveOfNode.getName() + " - ";
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Cannot get drive of node " + nodePath), (Throwable)e);
        }
        String lang = searchContext.getParamValue(SearchContext.RouterParams.LANG.create());
        if (StringUtils.isBlank((CharSequence)lang)) {
            lang = Locale.getDefault().getLanguage();
        }
        String detail = driveName + this.getFormattedFileSize(fileSize) + " - " + this.getFormattedDate(searchResult.getDate(), lang);
        EcmsSearchResult ecmsSearchResult = new EcmsSearchResult(this.getUrl(nodePath), this.getPreviewUrl(jsonHit, searchContext), searchResult.getTitle(), searchResult.getExcerpt(), detail, this.getImageUrl(workspace, nodePath), searchResult.getDate(), searchResult.getRelevancy(), fileType, nodePath, this.getBreadcrumb(nodePath));
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        boolean bl = isAnonymous = userId == null || userId.isEmpty() || userId.equals("__anonim");
        if (isAnonymous) {
            ecmsSearchResult.setPreviewUrl(this.downloadUrl.toString());
        }
        return ecmsSearchResult;
    }

    protected String getUrl(String nodePath) {
        String url = "";
        try {
            url = this.documentService.getLinkInDocumentsApp(nodePath);
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot get url of document " + nodePath), (Throwable)e);
        }
        return url;
    }

    protected String getFormattedDate(long createdDateTime, String lang) {
        try {
            Locale locale = LocaleUtils.toLocale((String)lang);
            DateTimeFormatter df = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.FULL, FormatStyle.SHORT).withLocale(locale).withZone(ZoneId.systemDefault());
            return df.format(Instant.ofEpochMilli(createdDateTime));
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot format date for timestamp " + createdDateTime), (Throwable)e);
            return "";
        }
    }

    protected String getFormattedFileSize(String fileSize) {
        try {
            Long size = Long.parseLong(fileSize);
            return Utils.formatSize((long)size);
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot format file size " + fileSize), (Throwable)e);
            return "";
        }
    }

    protected String getPreviewUrl(JSONObject jsonHit, SearchContext context) {
        JSONObject hitSource = (JSONObject)jsonHit.get((Object)"_source");
        String id = (String)jsonHit.get((Object)"_id");
        String author = (String)hitSource.get((Object)"author");
        String title = (String)hitSource.get((Object)"title");
        String workspace = (String)hitSource.get((Object)"workspace");
        String nodePath = (String)hitSource.get((Object)"path");
        String fileType = (String)hitSource.get((Object)"fileType");
        String restContextName = WCMCoreUtils.getRestContextName();
        String repositoryName = null;
        try {
            repositoryName = this.repositoryService.getCurrentRepository().getConfiguration().getName();
        }
        catch (RepositoryException e) {
            LOG.error((Object)"Cannot get repository name", (Throwable)e);
        }
        this.downloadUrl = new StringBuffer();
        this.downloadUrl.append('/').append(restContextName).append("/jcr/").append(repositoryName).append('/').append(workspace).append(nodePath);
        StringBuilder url = new StringBuilder("javascript:require(['SHARED/documentPreview'], function(documentPreview) {documentPreview.init({doc:{");
        url.append("id:'").append(id).append("',");
        url.append("fileType:'").append(fileType).append("',");
        url.append("title:'").append(title).append("',");
        String linkInDocumentsApp = "";
        try {
            linkInDocumentsApp = this.documentService.getLinkInDocumentsApp(nodePath);
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot get link in document app for node " + nodePath), (Throwable)e);
        }
        url.append("path:'").append(nodePath).append("', repository:'").append(repositoryName).append("', workspace:'").append(workspace).append("', downloadUrl:'").append(this.downloadUrl.toString()).append("', openUrl:'").append(linkInDocumentsApp).append("'}");
        if (author != null) {
            url.append(",author:{username:'").append(author).append("'}");
        }
        url.append("})});void(0);");
        return url.toString();
    }

    protected String getImageUrl(String workspace, String nodePath) {
        try {
            String path = nodePath.replaceAll("'", "\\\\'");
            String encodedPath = URLEncoder.encode(path, "utf-8");
            encodedPath = encodedPath.replaceAll("%2F", "/");
            String restContextName = WCMCoreUtils.getRestContextName();
            String repositoryName = null;
            try {
                repositoryName = this.repositoryService.getCurrentRepository().getConfiguration().getName();
            }
            catch (RepositoryException e) {
                LOG.error((Object)"Cannot get repository name", (Throwable)e);
            }
            String thumbnailImage = "/" + restContextName + "/thumbnailImage/medium/" + repositoryName + "/" + workspace + encodedPath;
            return thumbnailImage;
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)("Cannot encode path " + nodePath), (Throwable)e);
            return "";
        }
    }

    protected Map<String, List<String>> getBreadcrumb(String nodePath) {
        ListHashMap uris = new ListHashMap();
        try {
            DriveData drive;
            if (nodePath.endsWith("/")) {
                nodePath = nodePath.substring(0, nodePath.length() - 1);
            }
            if ((drive = this.documentService.getDriveOfNode(nodePath)) == null) {
                LOG.warn("Can't find associated drive of node with path '{}'. No breadcrumb will be returned", new Object[]{nodePath});
                return uris;
            }
            String nodePathFromDrive = nodePath;
            String driveHomePath = drive.getResolvedHomePath();
            if (nodePath.startsWith(driveHomePath)) {
                nodePathFromDrive = nodePath.substring(driveHomePath.length());
            }
            if (nodePathFromDrive.startsWith("/")) {
                nodePathFromDrive = nodePathFromDrive.substring(1);
            }
            String path = driveHomePath;
            for (String nodeName : nodePathFromDrive.split("/")) {
                path = path + "/" + nodeName;
                try {
                    Node docNode = NodeLocation.getNodeByExpression((String)(WCMCoreUtils.getRepository().getConfiguration().getName() + ":" + drive.getWorkspace() + ":" + path));
                    if (docNode == null) continue;
                    String nodeTitle = Utils.getTitle((Node)docNode);
                    String docLink = this.documentService.getLinkInDocumentsApp(path, drive);
                    ArrayList<String> titleAndLink = new ArrayList<String>();
                    titleAndLink.add(nodeTitle);
                    titleAndLink.add(docLink);
                    uris.put(path, titleAndLink);
                }
                catch (Exception e) {
                    LOG.error((Object)("Cannot get title and link of node " + nodeName), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error while building breadcrumb of file " + nodePath), (Throwable)e);
        }
        return uris;
    }
}

