/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.settings.ExoFeatureService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.space.SpaceTemplate;
import org.exoplatform.social.core.space.spi.SpaceTemplateService;
import org.exoplatform.social.webui.space.UISpaceSetting;
import org.exoplatform.social.webui.space.UISpaceTemplateDescription;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.ExpressionValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;

public class UISpaceSettings
extends UIFormInputSet {
    public static final String SPACE_DISPLAY_NAME = "displayName";
    public static final String SPACE_DESCRIPTION = "description";
    public static final String SPACE_TEMPLATE = "template";
    public static final String SPACE_TEMPLATES_FEATURE = "space-templates";
    private static final String TEMPLATES_ONCHANGE = "ChangeTemplate";
    private final String MSG_INVALID_SPACE_NAME = "UISpaceSettings.msg.invalid_space_name";
    private ExoFeatureService featureService = (ExoFeatureService)CommonsUtils.getService(ExoFeatureService.class);
    private SpaceTemplateService spaceTemplateService = (SpaceTemplateService)CommonsUtils.getService(SpaceTemplateService.class);
    private static final String HTML_ATTRIBUTE_PLACEHOLDER = "placeholder";
    private static final Log LOG = ExoLogger.getLogger(UISpaceSetting.class);

    public UISpaceSettings(String name) throws Exception {
        super(name);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(SPACE_DISPLAY_NAME, SPACE_DISPLAY_NAME, "").addValidator(MandatoryValidator.class, new Object[0]).addValidator(ExpressionValidator.class, new Object[]{"^([\\p{L}\\s\\d'_&]+[\\s]?)+$", "UISpaceSettings.msg.invalid_space_name"}).addValidator(StringLengthValidator.class, new Object[]{3, 200}));
        UIFormSelectBox uiFormTypesSelectBox = new UIFormSelectBox(SPACE_TEMPLATE, SPACE_TEMPLATE, null);
        this.initTypeSelectBox(uiFormTypesSelectBox);
        uiFormTypesSelectBox.setOnChange(TEMPLATES_ONCHANGE);
        this.addUIFormInput((UIFormInput)uiFormTypesSelectBox);
        this.addChild(UISpaceTemplateDescription.class, null, "UISpaceTemplateDescription");
        this.addUIFormInput((UIFormInput)new UIFormTextAreaInput(SPACE_DESCRIPTION, SPACE_DESCRIPTION, ""));
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        ResourceBundle resourceBundle = context.getApplicationResourceBundle();
        this.getUIStringInput(SPACE_DISPLAY_NAME).setHTMLAttribute(HTML_ATTRIBUTE_PLACEHOLDER, resourceBundle.getString("UISpaceSettings.label.spaceDisplayName"));
        UIFormSelectBox uiFormTypesSelectBox = this.getUIFormSelectBox(SPACE_TEMPLATE);
        String scripts = "(function(jq){jq(\"textarea#" + SPACE_DESCRIPTION + "\").attr(\"placeholder\", \"" + resourceBundle.getString("UISpaceSettings.label.spaceDescription") + "\");})(jq);";
        context.getJavascriptManager().getRequireJS().require("SHARED/jquery", "jq").addScripts(scripts);
        boolean isActive = this.featureService.isActiveFeature(SPACE_TEMPLATES_FEATURE);
        boolean hasTemplates = uiFormTypesSelectBox.getOptions().size() > 0;
        uiFormTypesSelectBox.setRendered(isActive && hasTemplates);
        UISpaceTemplateDescription uiSpaceTemplateDescription = (UISpaceTemplateDescription)this.getChild(UISpaceTemplateDescription.class);
        uiSpaceTemplateDescription.setTemplateName((String)uiFormTypesSelectBox.getValue());
        uiSpaceTemplateDescription.setRendered(isActive && hasTemplates);
        super.processRender(context);
    }

    private void initTypeSelectBox(UIFormSelectBox typeSelectBox) throws Exception {
        ArrayList<SelectItemOption> templates = new ArrayList<SelectItemOption>();
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        List spaceTemplates = this.spaceTemplateService.getSpaceTemplates(userId);
        for (SpaceTemplate spaceTemplate : spaceTemplates) {
            String spaceType = spaceTemplate.getName();
            String translation = null;
            try {
                ResourceBundle resourceBundle = WebuiRequestContext.getCurrentInstance().getApplicationResourceBundle();
                String key = "space.template." + spaceType;
                translation = resourceBundle.getString(key);
            }
            catch (MissingResourceException e) {
                translation = StringUtils.capitalize((String)spaceType);
            }
            catch (Exception e) {
                LOG.debug((Object)"Could not get resource bundle.");
            }
            SelectItemOption option = new SelectItemOption(translation, (Object)spaceType);
            templates.add(option);
        }
        String defaultSpaceTemplate = this.spaceTemplateService.getDefaultSpaceTemplate();
        typeSelectBox.setOptions(templates);
        SpaceTemplate defaultTemplate = this.spaceTemplateService.getSpaceTemplateByName(defaultSpaceTemplate);
        if (defaultTemplate != null && spaceTemplates.stream().anyMatch(st -> st.getName().equals(defaultSpaceTemplate))) {
            typeSelectBox.setValue(defaultSpaceTemplate);
        }
    }
}

