/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino.util.enumerator;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.janino.util.enumerator.EnumeratorFormatException;

public abstract class Enumerator {
    final String name;
    private static final Map instances = Collections.synchronizedMap(new HashMap());

    protected Enumerator(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
        Enumerator.getInstances(this.getClass()).put(name, this);
    }

    public final boolean equals(Object that) {
        return this == that;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    static Map getInstances(Class enumeratorClass) {
        HashMap m = (HashMap)instances.get(enumeratorClass);
        if (m != null) {
            return m;
        }
        m = new HashMap();
        instances.put(enumeratorClass, m);
        return m;
    }

    protected static final Enumerator fromString(String name, Class enumeratorClass) throws EnumeratorFormatException {
        Enumerator value = (Enumerator)Enumerator.getInstances(enumeratorClass).get(name);
        if (value == null) {
            throw new EnumeratorFormatException(name);
        }
        return value;
    }

    public String toString() {
        return this.name;
    }
}

