/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.upgrade.wikiname;

import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.wiki.rendering.util.Utils;

public class WikiNameUpgradePlugin
extends UpgradeProductPlugin {
    private Log log = ExoLogger.getLogger((String)((Object)((Object)this)).getClass().getName());
    private SpaceService spaceService;

    public WikiNameUpgradePlugin(InitParams initParams) {
        super(initParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("-------------- Starting " + this.getName() + " --------------"));
        }
        try {
            RequestLifeCycle.begin((ExoContainer)ExoContainerContext.getCurrentContainer());
            this.spaceService = (SpaceService)Utils.getService(SpaceService.class);
            ListAccess spaces = this.spaceService.getAllSpacesWithListAccess();
            for (Space space : (Space[])spaces.load(0, spaces.getSize())) {
                String apps = space.getApp();
                if (apps == null || !apps.contains("WikiPortlet:Wiki:")) continue;
                space.setApp(apps.replace("WikiPortlet:Wiki:", "WikiPortlet:wiki:"));
                this.spaceService.updateSpace(space);
                if (!this.log.isInfoEnabled()) continue;
                this.log.info((Object)("-------------- Rename WikiPortlet from space " + space.getPrettyName() + "--------------"));
            }
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("-------------- " + this.getName() + " finish successfully --------------"));
            }
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Error when upgrading wiki portlet name.", (Throwable)e);
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }
}

