/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.BackOffPolicy;
import com.google.api.client.http.GZipEncoding;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpEncoding;
import com.google.api.client.http.HttpEncodingStreamingContent;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpMediaType;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpResponseInterceptor;
import com.google.api.client.http.HttpStatusCodes;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.util.IOUtils;
import com.google.api.client.util.LoggingStreamingContent;
import com.google.api.client.util.ObjectParser;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.StreamingContent;
import com.google.api.client.util.StringUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpRequest {
    public static final String VERSION = "1.14.1-beta";
    public static final String USER_AGENT_SUFFIX = "Google-HTTP-Java-Client/1.14.1-beta (gzip)";
    private HttpExecuteInterceptor executeInterceptor;
    private HttpHeaders headers = new HttpHeaders();
    private HttpHeaders responseHeaders = new HttpHeaders();
    private int numRetries = 10;
    private int contentLoggingLimit = 16384;
    private boolean loggingEnabled = true;
    private boolean curlLoggingEnabled = true;
    private HttpContent content;
    private final HttpTransport transport;
    private String requestMethod;
    private GenericUrl url;
    private int connectTimeout = 20000;
    private int readTimeout = 20000;
    private HttpUnsuccessfulResponseHandler unsuccessfulResponseHandler;
    private HttpResponseInterceptor responseInterceptor;
    private ObjectParser objectParser;
    private HttpEncoding encoding;
    @Deprecated
    private boolean enableGZipContent;
    private BackOffPolicy backOffPolicy;
    private boolean followRedirects = true;
    private boolean throwExceptionOnExecuteError = true;
    private boolean retryOnExecuteIOException = false;
    private boolean suppressUserAgentSuffix;

    HttpRequest(HttpTransport transport, String requestMethod) {
        this.transport = transport;
        this.setRequestMethod(requestMethod);
    }

    public HttpTransport getTransport() {
        return this.transport;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public HttpRequest setRequestMethod(String requestMethod) {
        Preconditions.checkArgument(requestMethod == null || HttpMediaType.matchesToken(requestMethod));
        this.requestMethod = requestMethod;
        return this;
    }

    public GenericUrl getUrl() {
        return this.url;
    }

    public HttpRequest setUrl(GenericUrl url) {
        this.url = Preconditions.checkNotNull(url);
        return this;
    }

    public HttpContent getContent() {
        return this.content;
    }

    public HttpRequest setContent(HttpContent content) {
        this.content = content;
        return this;
    }

    public HttpEncoding getEncoding() {
        return this.encoding;
    }

    public HttpRequest setEncoding(HttpEncoding encoding) {
        this.encoding = encoding;
        return this;
    }

    @Deprecated
    public boolean getEnableGZipContent() {
        return this.enableGZipContent;
    }

    @Deprecated
    public HttpRequest setEnableGZipContent(boolean enableGZipContent) {
        this.enableGZipContent = enableGZipContent;
        return this;
    }

    public BackOffPolicy getBackOffPolicy() {
        return this.backOffPolicy;
    }

    public HttpRequest setBackOffPolicy(BackOffPolicy backOffPolicy) {
        this.backOffPolicy = backOffPolicy;
        return this;
    }

    public int getContentLoggingLimit() {
        return this.contentLoggingLimit;
    }

    public HttpRequest setContentLoggingLimit(int contentLoggingLimit) {
        Preconditions.checkArgument(contentLoggingLimit >= 0, "The content logging limit must be non-negative.");
        this.contentLoggingLimit = contentLoggingLimit;
        return this;
    }

    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    public HttpRequest setLoggingEnabled(boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
        return this;
    }

    public boolean isCurlLoggingEnabled() {
        return this.curlLoggingEnabled;
    }

    public HttpRequest setCurlLoggingEnabled(boolean curlLoggingEnabled) {
        this.curlLoggingEnabled = curlLoggingEnabled;
        return this;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public HttpRequest setConnectTimeout(int connectTimeout) {
        Preconditions.checkArgument(connectTimeout >= 0);
        this.connectTimeout = connectTimeout;
        return this;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public HttpRequest setReadTimeout(int readTimeout) {
        Preconditions.checkArgument(readTimeout >= 0);
        this.readTimeout = readTimeout;
        return this;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public HttpRequest setHeaders(HttpHeaders headers) {
        this.headers = Preconditions.checkNotNull(headers);
        return this;
    }

    public HttpHeaders getResponseHeaders() {
        return this.responseHeaders;
    }

    public HttpRequest setResponseHeaders(HttpHeaders responseHeaders) {
        this.responseHeaders = Preconditions.checkNotNull(responseHeaders);
        return this;
    }

    public HttpExecuteInterceptor getInterceptor() {
        return this.executeInterceptor;
    }

    public HttpRequest setInterceptor(HttpExecuteInterceptor interceptor) {
        this.executeInterceptor = interceptor;
        return this;
    }

    public HttpUnsuccessfulResponseHandler getUnsuccessfulResponseHandler() {
        return this.unsuccessfulResponseHandler;
    }

    public HttpRequest setUnsuccessfulResponseHandler(HttpUnsuccessfulResponseHandler unsuccessfulResponseHandler) {
        this.unsuccessfulResponseHandler = unsuccessfulResponseHandler;
        return this;
    }

    public HttpResponseInterceptor getResponseInterceptor() {
        return this.responseInterceptor;
    }

    public HttpRequest setResponseInterceptor(HttpResponseInterceptor responseInterceptor) {
        this.responseInterceptor = responseInterceptor;
        return this;
    }

    public int getNumberOfRetries() {
        return this.numRetries;
    }

    public HttpRequest setNumberOfRetries(int numRetries) {
        Preconditions.checkArgument(numRetries >= 0);
        this.numRetries = numRetries;
        return this;
    }

    public HttpRequest setParser(ObjectParser parser) {
        this.objectParser = parser;
        return this;
    }

    public final ObjectParser getParser() {
        return this.objectParser;
    }

    public boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public HttpRequest setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    public boolean getThrowExceptionOnExecuteError() {
        return this.throwExceptionOnExecuteError;
    }

    public HttpRequest setThrowExceptionOnExecuteError(boolean throwExceptionOnExecuteError) {
        this.throwExceptionOnExecuteError = throwExceptionOnExecuteError;
        return this;
    }

    public boolean getRetryOnExecuteIOException() {
        return this.retryOnExecuteIOException;
    }

    public HttpRequest setRetryOnExecuteIOException(boolean retryOnExecuteIOException) {
        this.retryOnExecuteIOException = retryOnExecuteIOException;
        return this;
    }

    public boolean getSuppressUserAgentSuffix() {
        return this.suppressUserAgentSuffix;
    }

    public HttpRequest setSuppressUserAgentSuffix(boolean suppressUserAgentSuffix) {
        this.suppressUserAgentSuffix = suppressUserAgentSuffix;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse execute() throws IOException {
        IOException executeException;
        boolean retrySupported = false;
        Preconditions.checkArgument(this.numRetries >= 0);
        int retriesRemaining = this.numRetries;
        if (this.backOffPolicy != null) {
            this.backOffPolicy.reset();
        }
        HttpResponse response = null;
        Preconditions.checkNotNull(this.requestMethod);
        Preconditions.checkNotNull(this.url);
        do {
            StreamingContent streamingContent;
            boolean contentRetrySupported;
            if (response != null) {
                response.ignore();
            }
            response = null;
            executeException = null;
            if (this.executeInterceptor != null) {
                this.executeInterceptor.intercept(this);
            }
            String urlString = this.url.build();
            LowLevelHttpRequest lowLevelHttpRequest = this.transport.buildRequest(this.requestMethod, urlString);
            Logger logger = HttpTransport.LOGGER;
            boolean loggable = this.loggingEnabled && logger.isLoggable(Level.CONFIG);
            StringBuilder logbuf = null;
            StringBuilder curlbuf = null;
            if (loggable) {
                logbuf = new StringBuilder();
                logbuf.append("-------------- REQUEST  --------------").append(StringUtils.LINE_SEPARATOR);
                logbuf.append(this.requestMethod).append(' ').append(urlString).append(StringUtils.LINE_SEPARATOR);
                if (this.curlLoggingEnabled) {
                    curlbuf = new StringBuilder("curl -v --compressed");
                    if (!this.requestMethod.equals("GET")) {
                        curlbuf.append(" -X ").append(this.requestMethod);
                    }
                }
            }
            String originalUserAgent = this.headers.getUserAgent();
            if (!this.suppressUserAgentSuffix) {
                if (originalUserAgent == null) {
                    this.headers.setUserAgent(USER_AGENT_SUFFIX);
                } else {
                    this.headers.setUserAgent(originalUserAgent + " " + USER_AGENT_SUFFIX);
                }
            }
            HttpHeaders.serializeHeaders(this.headers, logbuf, curlbuf, logger, lowLevelHttpRequest);
            if (!this.suppressUserAgentSuffix) {
                this.headers.setUserAgent(originalUserAgent);
            }
            boolean bl = contentRetrySupported = (streamingContent = this.content) == null || this.content.retrySupported();
            if (streamingContent != null) {
                long contentLength;
                String contentEncoding;
                final String contentType = this.content.getType();
                if (loggable) {
                    streamingContent = new LoggingStreamingContent(streamingContent, HttpTransport.LOGGER, Level.CONFIG, this.contentLoggingLimit);
                }
                String underlyingEncoding = this.content.getEncoding();
                if (this.enableGZipContent) {
                    Preconditions.checkArgument(this.encoding == null || this.encoding instanceof GZipEncoding);
                    this.setEncoding(new GZipEncoding());
                }
                if (this.encoding == null || underlyingEncoding != null) {
                    Preconditions.checkArgument(this.encoding == null || underlyingEncoding == null);
                    contentEncoding = underlyingEncoding;
                    contentLength = this.content.getLength();
                } else {
                    contentEncoding = this.encoding.getName();
                    streamingContent = new HttpEncodingStreamingContent(streamingContent, this.encoding);
                    long l = contentLength = contentRetrySupported ? IOUtils.computeLength(streamingContent) : -1L;
                }
                if (loggable) {
                    String header;
                    if (contentType != null) {
                        header = "Content-Type: " + contentType;
                        logbuf.append(header).append(StringUtils.LINE_SEPARATOR);
                        if (curlbuf != null) {
                            curlbuf.append(" -H '" + header + "'");
                        }
                    }
                    if (underlyingEncoding != null) {
                        header = "Content-Encoding: " + underlyingEncoding;
                        logbuf.append(header).append(StringUtils.LINE_SEPARATOR);
                        if (curlbuf != null) {
                            curlbuf.append(" -H '" + header + "'");
                        }
                    }
                    if (contentLength >= 0L) {
                        header = "Content-Length: " + contentLength;
                        logbuf.append(header).append(StringUtils.LINE_SEPARATOR);
                    }
                }
                if (curlbuf != null) {
                    curlbuf.append(" -d '@-'");
                }
                final StreamingContent streamingContent2 = streamingContent;
                lowLevelHttpRequest.setContent(new HttpContent(){

                    public void writeTo(OutputStream out) throws IOException {
                        streamingContent2.writeTo(out);
                    }

                    @Deprecated
                    public String getEncoding() {
                        return contentEncoding;
                    }

                    public long getLength() throws IOException {
                        return contentLength;
                    }

                    public String getType() {
                        return contentType;
                    }

                    public boolean retrySupported() {
                        return contentRetrySupported;
                    }
                });
                lowLevelHttpRequest.setContentType(contentType);
                lowLevelHttpRequest.setContentEncoding(contentEncoding);
                lowLevelHttpRequest.setContentLength(contentLength);
                lowLevelHttpRequest.setStreamingContent(streamingContent);
            }
            if (loggable) {
                logger.config(logbuf.toString());
                if (curlbuf != null) {
                    curlbuf.append(" -- ");
                    curlbuf.append(urlString);
                    if (streamingContent != null) {
                        curlbuf.append(" << $$$");
                    }
                    logger.config(curlbuf.toString());
                }
            }
            retrySupported = contentRetrySupported && retriesRemaining > 0;
            lowLevelHttpRequest.setTimeout(this.connectTimeout, this.readTimeout);
            try {
                LowLevelHttpResponse lowLevelHttpResponse = lowLevelHttpRequest.execute();
                boolean responseConstructed = false;
                try {
                    response = new HttpResponse(this, lowLevelHttpResponse);
                    responseConstructed = true;
                }
                finally {
                    if (!responseConstructed) {
                        lowLevelHttpResponse.getContent().close();
                    }
                }
            }
            catch (IOException e) {
                if (!this.retryOnExecuteIOException) {
                    throw e;
                }
                executeException = e;
                logger.log(Level.WARNING, "exception thrown while executing request", e);
            }
            boolean responseProcessed = false;
            try {
                if (response != null && !response.isSuccessStatusCode()) {
                    boolean errorHandled = false;
                    boolean redirectRequest = false;
                    boolean backOffRetry = false;
                    if (this.unsuccessfulResponseHandler != null) {
                        errorHandled = this.unsuccessfulResponseHandler.handleResponse(this, response, retrySupported);
                    }
                    if (!errorHandled) {
                        long backOffTime;
                        if (this.handleRedirect(response.getStatusCode(), response.getHeaders())) {
                            redirectRequest = true;
                        } else if (retrySupported && this.backOffPolicy != null && this.backOffPolicy.isBackOffRequired(response.getStatusCode()) && (backOffTime = this.backOffPolicy.getNextBackOffMillis()) != -1L) {
                            this.sleep(backOffTime);
                            backOffRetry = true;
                        }
                    }
                    if (retrySupported &= errorHandled || redirectRequest || backOffRetry) {
                        response.ignore();
                    }
                } else {
                    retrySupported &= response == null;
                }
                --retriesRemaining;
                responseProcessed = true;
            }
            finally {
                if (response != null && !responseProcessed) {
                    response.disconnect();
                }
            }
        } while (retrySupported);
        if (response == null) {
            throw executeException;
        }
        if (this.responseInterceptor != null) {
            this.responseInterceptor.interceptResponse(response);
        }
        if (this.throwExceptionOnExecuteError && !response.isSuccessStatusCode()) {
            try {
                throw new HttpResponseException(response);
            }
            catch (Throwable throwable) {
                response.disconnect();
                throw throwable;
            }
        }
        return response;
    }

    public Future<HttpResponse> executeAsync(Executor executor) {
        FutureTask<HttpResponse> future = new FutureTask<HttpResponse>(new Callable<HttpResponse>(){

            @Override
            public HttpResponse call() throws Exception {
                return HttpRequest.this.execute();
            }
        });
        executor.execute(future);
        return future;
    }

    public Future<HttpResponse> executeAsync() {
        return this.executeAsync(Executors.newSingleThreadExecutor());
    }

    public boolean handleRedirect(int statusCode, HttpHeaders responseHeaders) {
        String redirectLocation = responseHeaders.getLocation();
        if (this.getFollowRedirects() && HttpStatusCodes.isRedirect(statusCode) && redirectLocation != null) {
            this.setUrl(new GenericUrl(this.url.toURL(redirectLocation)));
            if (statusCode == 303) {
                this.setRequestMethod("GET");
            }
            this.headers.setAuthorization((String)null);
            this.headers.setIfMatch(null);
            this.headers.setIfNoneMatch(null);
            this.headers.setIfModifiedSince(null);
            this.headers.setIfUnmodifiedSince(null);
            this.headers.setIfRange(null);
            return true;
        }
        return false;
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

