/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.spacetemplates;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.InputStream;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.space.SpaceTemplate;
import org.exoplatform.social.core.space.spi.SpaceTemplateService;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.api.ErrorResource;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.api.SocialRest;

@Path(value="v1/social/spaceTemplates")
@Api(tags={"v1/social/spaceTemplates"}, value="v1/social/spaceTemplates", description="Managing Spaces Templates")
public class SpaceTemplatesRestResourcesV1
implements SocialRest {
    private SpaceTemplateService spaceTemplateService;
    private ConfigurationManager configurationManager;
    private static final Log LOG = ExoLogger.getLogger(SpaceTemplatesRestResourcesV1.class);

    public SpaceTemplatesRestResourcesV1(SpaceTemplateService spaceTemplateService, ConfigurationManager configurationManager) {
        this.spaceTemplateService = spaceTemplateService;
        this.configurationManager = configurationManager;
    }

    @GET
    @Path(value="templates")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets all spaces templates", httpMethod="GET", response=Response.class, notes="This returns space templates details")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error")})
    public Response getAllTemplates(@Context UriInfo uriInfo, @ApiParam(value="User language", required=true) @QueryParam(value="lang") String lang) {
        Identity identity = ConversationState.getCurrent().getIdentity();
        String userId = identity.getUserId();
        try {
            List list = this.spaceTemplateService.getLabelledSpaceTemplates(userId, lang);
            return EntityBuilder.getResponse(list, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
        }
        catch (Exception e) {
            LOG.error("Cannot get list of templates for user {}, with lang {}", new Object[]{userId, lang, e});
            return EntityBuilder.getResponse(new ErrorResource("Error occurred while getting list of space templates", "space templates permissions not extracted"), uriInfo, RestUtils.getJsonMediaType(), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="bannerStream")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets space template banner", httpMethod="GET", response=Response.class, notes="This returns space template banner input stream")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=404, message="Resource not found"), @ApiResponse(code=500, message="Internal server error")})
    public Response getBannerStream(@Context UriInfo uriInfo, @Context Request request, @ApiParam(value="Space template name", required=true) @QueryParam(value="templateName") String templateName) {
        SpaceTemplate spaceTemplate = this.spaceTemplateService.getSpaceTemplateByName(templateName);
        if (spaceTemplate == null) {
            LOG.debug("Cannot find space template: {}", new Object[]{templateName});
            return EntityBuilder.getResponse(new ErrorResource("space template does not exist: " + templateName, "space template not found"), uriInfo, RestUtils.getJsonMediaType(), Response.Status.NOT_FOUND);
        }
        String bannerPath = spaceTemplate.getBannerPath();
        if (StringUtils.isNotBlank((CharSequence)bannerPath)) {
            EntityTag eTag = new EntityTag(Integer.toString(templateName.hashCode()));
            Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
            if (builder == null) {
                InputStream bannerStream = null;
                try {
                    bannerStream = this.configurationManager.getInputStream(bannerPath);
                }
                catch (Exception e) {
                    LOG.warn("Error retrieving banner image of template {}", new Object[]{templateName, e});
                    return EntityBuilder.getResponse(new ErrorResource("inputStream could not be extracted from path: " + bannerPath, "inputStream not extracted"), uriInfo, RestUtils.getJsonMediaType(), Response.Status.INTERNAL_SERVER_ERROR);
                }
                if (bannerStream == null) {
                    throw new WebApplicationException(Response.Status.NOT_FOUND);
                }
                builder = Response.ok((Object)bannerStream, (String)"image/png");
                builder.tag(eTag);
            }
            CacheControl cc = new CacheControl();
            cc.setMaxAge(86400);
            builder.cacheControl(cc);
            return builder.cacheControl(cc).build();
        }
        return EntityBuilder.getResponse(new ErrorResource("image does not exist in path: " + bannerPath, "banner not found"), uriInfo, RestUtils.getJsonMediaType(), Response.Status.NOT_FOUND);
    }
}

