/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.user;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.user.UserStateModel;
import org.exoplatform.services.user.UserStateService;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.model.ActivityFile;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.api.ErrorResource;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.api.UserRestResources;
import org.exoplatform.social.rest.entity.ActivityEntity;
import org.exoplatform.social.rest.entity.CollectionEntity;
import org.exoplatform.social.rest.entity.DataEntity;
import org.exoplatform.social.rest.entity.ProfileEntity;
import org.exoplatform.social.rest.entity.SpaceEntity;
import org.exoplatform.social.rest.entity.UserEntity;
import org.exoplatform.social.service.rest.api.models.ActivityRestIn;

@Path(value="v1/social/users")
@Api(tags={"v1/social/users"}, value="v1/social/users", description="Operations on users with their activities, connections and spaces")
public class UserRestResourcesV1
implements UserRestResources {
    private static final String ONLINE = "online";
    private UserACL userACL;
    private IdentityManager identityManager;
    private UserStateService userStateService;
    private SpaceService spaceService;
    private static final String INVISIBLE = "invisible";
    private static final Log LOG = ExoLogger.getLogger(UserRestResourcesV1.class);

    public UserRestResourcesV1(UserACL userACL, IdentityManager identityManager, UserStateService userStateService, SpaceService spaceService) {
        this.userACL = userACL;
        this.identityManager = identityManager;
        this.userStateService = userStateService;
        this.spaceService = spaceService;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @GET
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets all users", httpMethod="GET", response=Response.class, notes="Using the query param \"q\" to filter the target users, ex: \"q=jo*\" returns all the users beginning by \"jo\".Using the query param \"status\" to filter the target users, ex: \"status=online*\" returns the visible online users.Using the query params \"status\" and \"spaceId\" together to filter the target users, ex: \"status=online*\" and \"spaceId=1*\" returns the visible online users who are member of space with id=1.The params \"status\" and \"spaceId\" cannot be used with \"q\" param since it will falsify the \"limit\" param which is 20 by default. If these 3 parameters are used together, the parameter \"q\" will be ignored")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=404, message="Resource not found"), @ApiResponse(code=500, message="Internal server error due to data encoding"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getUsers(@Context UriInfo uriInfo, @ApiParam(value="User name information to filter, ex: user name, last name, first name or full name", required=false) @QueryParam(value="q") String q, @ApiParam(value="User status to filter online users, ex: online", required=false) @QueryParam(value="status") String status, @ApiParam(value="Space id to filter only its members, ex: 1", required=false) @QueryParam(value="spaceId") String spaceId, @ApiParam(value="Offset", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit", required=false, defaultValue="20") @QueryParam(value="limit") int limit, @ApiParam(value="Returning the number of users found or not", defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) throws Exception {
        Identity[] identities;
        offset = offset > 0 ? offset : RestUtils.getOffset(uriInfo);
        limit = limit > 0 ? limit : RestUtils.getLimit(uriInfo);
        int totalSize = 0;
        if (StringUtils.isNotBlank((CharSequence)status) && ONLINE.equals(status)) {
            String userId;
            try {
                userId = ConversationState.getCurrent().getIdentity().getUserId();
            }
            catch (Exception e) {
                return Response.status((int)401).build();
            }
            if (StringUtils.isBlank((CharSequence)userId)) {
                return Response.status((int)401).build();
            }
            Space space = null;
            if (StringUtils.isNotBlank((CharSequence)spaceId)) {
                space = this.spaceService.getSpaceById(spaceId);
                if (space == null) return EntityBuilder.getResponse(new ErrorResource("space " + spaceId + " does not exist", "space not found"), uriInfo, RestUtils.getJsonMediaType(), Response.Status.NOT_FOUND);
                identities = this.getOnlineIdentitiesOfSpace(userId, space, limit);
            } else {
                identities = this.getOnlineIdentities(userId, limit);
            }
        } else {
            ProfileFilter filter = new ProfileFilter();
            filter.setName(q == null || q.isEmpty() ? "" : q);
            Identity[] list = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getIdentitiesByProfileFilter("organization", filter, false);
            identities = (Identity[])list.load(offset, limit);
            if (returnSize) {
                totalSize = list.getSize();
            }
        }
        ArrayList<DataEntity> profileInfos = new ArrayList<DataEntity>();
        for (Identity identity : identities) {
            ProfileEntity profileInfo = EntityBuilder.buildEntityProfile(identity.getProfile(), uriInfo.getPath(), expand);
            profileInfos.add(profileInfo.getDataEntity());
        }
        CollectionEntity collectionUser = new CollectionEntity(profileInfos, "users", offset, limit);
        if (!returnSize) return EntityBuilder.getResponse(collectionUser, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
        collectionUser.setSize(totalSize);
        return EntityBuilder.getResponse(collectionUser, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @POST
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Creates a new user", httpMethod="POST", response=Response.class, notes="This creates the user if the authenticated user is in the /platform/administrators group.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input")})
    public Response addUser(@Context UriInfo uriInfo, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="User object to be created, ex:<br />{<br />\"username\": \"john\",<br />\"password\": \"gtngtn\",<br />\"email\": \"john@exoplatform.com\",<br />\"firstname\": \"John\",<br />\"lastname\": \"Smith\"<br />}", required=true) UserEntity model) throws Exception {
        if (model.isNotValid()) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if (!RestUtils.isMemberOfAdminGroup()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        Identity identity = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", model.getUsername(), true);
        if (identity != null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (UserRestResourcesV1.getUserByEmail(model.getEmail()) != null) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        UserHandler userHandler = ((OrganizationService)CommonsUtils.getService(OrganizationService.class)).getUserHandler();
        User user = userHandler.createUserInstance(model.getUsername());
        user.setFirstName(model.getFirstname());
        user.setLastName(model.getLastname());
        user.setEmail(model.getEmail());
        user.setPassword(model.getPassword() == null || model.getPassword().isEmpty() ? "exo" : model.getPassword());
        userHandler.createUser(user, true);
        return EntityBuilder.getResponse(EntityBuilder.buildEntityProfile(model.getUsername(), uriInfo.getPath(), expand), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @GET
    @Path(value="{id}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets a specific user by user name", httpMethod="GET", response=Response.class, notes="This can only be done by the logged in user.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=404, message="Resource not found"), @ApiResponse(code=500, message="Internal server error due to data encoding"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getUserById(@Context UriInfo uriInfo, @ApiParam(value="User name", required=true) @PathParam(value="id") String id, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) throws Exception {
        Identity identity = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", id, true);
        if (identity == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        return EntityBuilder.getResponse(EntityBuilder.buildEntityProfile(identity.getProfile(), uriInfo.getPath(), expand), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @GET
    @Path(value="{id}/avatar")
    @ApiOperation(value="Gets a specific user avatar by username", httpMethod="GET", response=Response.class, notes="This can only be done by the logged in user.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=404, message="Resource not found"), @ApiResponse(code=500, message="Internal server error due to data encoding"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getUserAvatarById(@Context UriInfo uriInfo, @Context Request request, @ApiParam(value="User name", required=true) @PathParam(value="id") String id, @ApiParam(value="URL to default avatar Or '404' to return a 404 http code", required=false) @QueryParam(value="default") String defaultAvatar) throws IOException {
        InputStream stream;
        Identity identity = this.identityManager.getOrCreateIdentity("organization", id, true);
        Response.ResponseBuilder builder = null;
        if (identity == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        Profile profile = identity.getProfile();
        Long lastUpdated = null;
        if (profile != null) {
            lastUpdated = profile.getAvatarLastUpdated();
        }
        EntityTag eTag = null;
        if (lastUpdated != null) {
            eTag = new EntityTag(Integer.toString(lastUpdated.hashCode()));
        }
        Response.ResponseBuilder responseBuilder = builder = eTag == null ? null : request.evaluatePreconditions(eTag);
        if (builder == null && (stream = this.identityManager.getAvatarInputStream(identity)) != null) {
            builder = Response.ok((Object)stream, (String)"image/png");
            builder.tag(eTag);
        }
        if (builder == null) {
            builder = this.getDefaultAvatarBuilder(defaultAvatar);
        }
        CacheControl cc = new CacheControl();
        cc.setMaxAge(86400);
        builder.cacheControl(cc);
        return builder.cacheControl(cc).build();
    }

    @GET
    @Path(value="{id}/banner")
    @ApiOperation(value="Gets a specific user banner by username", httpMethod="GET", response=Response.class, notes="This can only be done by the logged in user.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=404, message="Resource not found"), @ApiResponse(code=500, message="Internal server error due to data encoding"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getUserBannerById(@Context UriInfo uriInfo, @Context Request request, @ApiParam(value="User name", required=true) @PathParam(value="id") String id, @ApiParam(value="URL to default banner Or '404' to return a 404 http code", required=false) @QueryParam(value="default") String defaultBanner) throws IOException {
        InputStream stream;
        Identity identity = this.identityManager.getOrCreateIdentity("organization", id, true);
        Response.ResponseBuilder builder = null;
        if (identity == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        Profile profile = identity.getProfile();
        Long lastUpdated = null;
        if (profile != null) {
            lastUpdated = profile.getBannerLastUpdated();
        }
        EntityTag eTag = null;
        if (lastUpdated != null) {
            eTag = new EntityTag(Integer.toString(lastUpdated.hashCode()));
        }
        Response.ResponseBuilder responseBuilder = builder = eTag == null ? null : request.evaluatePreconditions(eTag);
        if (builder == null && (stream = this.identityManager.getBannerInputStream(identity)) != null) {
            builder = Response.ok((Object)stream, (String)"image/png");
            builder.tag(eTag);
        }
        if (builder == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        CacheControl cc = new CacheControl();
        cc.setMaxAge(86400);
        builder.cacheControl(cc);
        return builder.cacheControl(cc).build();
    }

    private Response.ResponseBuilder getDefaultAvatarBuilder(String avatarUrl) {
        InputStream is;
        if (avatarUrl != null) {
            if (avatarUrl.equals("404")) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            try {
                URL url = new URL(avatarUrl);
                String type = url.openConnection().getHeaderField("Content-Type");
                if (type != null && type.startsWith("image/")) {
                    InputStream input = url.openStream();
                    return Response.ok((Object)input, (String)type);
                }
            }
            catch (IOException e) {
                LOG.debug((Object)("Could NOT open the default url " + avatarUrl));
            }
        }
        if ((is = PortalContainer.getInstance().getPortalContext().getResourceAsStream("/skin/images/system/UserAvtDefault.png")) == null) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        return Response.ok((Object)is, (String)"image/png");
    }

    @Override
    @DELETE
    @Path(value="{id}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Deletes a specific user by user name", httpMethod="DELETE", response=Response.class, notes="This deletes the user if the authenticated user is in the /platform/administrators group.")
    public Response deleteUserById(@Context UriInfo uriInfo, @ApiParam(value="User name", required=true) @PathParam(value="id") String id, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) throws Exception {
        if (!RestUtils.isMemberOfAdminGroup()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        Identity identity = identityManager.getOrCreateIdentity("organization", id, true);
        if (identity == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        identityManager.hardDeleteIdentity(identity);
        identity.setDeleted(true);
        UserHandler userHandler = ((OrganizationService)CommonsUtils.getService(OrganizationService.class)).getUserHandler();
        userHandler.removeUser(id, false);
        return EntityBuilder.getResponse(EntityBuilder.buildEntityProfile(identity.getProfile(), uriInfo.getPath(), expand), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @PUT
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Updates a specific user by user name", httpMethod="PUT", response=Response.class, notes="This updates the user if he is the authenticated user.")
    public Response updateUserById(@Context UriInfo uriInfo, @ApiParam(value="User name", required=true) @PathParam(value="id") String id, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="User object to be updated, ex:<br />{<br />\"username\": \"john\",<br />\"password\": \"gtngtn\",<br />\"email\": \"john@exoplatform.com\",<br />\"firstname\": \"John\",<br />\"lastname\": \"Smith\"<br />}", required=true) UserEntity model) throws Exception {
        UserHandler userHandler = ((OrganizationService)CommonsUtils.getService(OrganizationService.class)).getUserHandler();
        User user = userHandler.findUserByName(id);
        if (user == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (!ConversationState.getCurrent().getIdentity().getUserId().equals(id)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        if (UserRestResourcesV1.getUserByEmail(model.getEmail()) != null && !user.getUserName().equals(UserRestResourcesV1.getUserByEmail(model.getEmail()).getUserName())) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        this.fillUserFromModel(user, model);
        userHandler.saveUser(user, true);
        return EntityBuilder.getResponse(EntityBuilder.buildEntityProfile(id, uriInfo.getPath(), expand), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @GET
    @Path(value="{id}/connections")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets connections of a specific user", httpMethod="GET", response=Response.class, notes="This can only be done by the logged in user.")
    public Response getConnectionOfUser(@Context UriInfo uriInfo, @ApiParam(value="User name", required=true) @PathParam(value="id") String id, @ApiParam(value="Returning the number of connections or not", defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) throws Exception {
        Identity[] identities;
        Identity target = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", id, true);
        if (target == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        int limit = RestUtils.getLimit(uriInfo);
        int offset = RestUtils.getOffset(uriInfo);
        ArrayList<DataEntity> profileInfos = new ArrayList<DataEntity>();
        ListAccess listAccess = ((RelationshipManager)CommonsUtils.getService(RelationshipManager.class)).getConnectionsByFilter(target, new ProfileFilter());
        for (Identity identity : identities = (Identity[])listAccess.load(offset, limit)) {
            ProfileEntity profileInfo = EntityBuilder.buildEntityProfile(identity.getProfile(), uriInfo.getPath(), expand);
            profileInfos.add(profileInfo.getDataEntity());
        }
        CollectionEntity collectionUser = new CollectionEntity(profileInfos, "users", offset, limit);
        if (returnSize) {
            collectionUser.setSize(listAccess.getSize());
        }
        return EntityBuilder.getResponse(collectionUser, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @GET
    @Path(value="{id}/spaces")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets spaces of a specific user", httpMethod="GET", response=Response.class, notes="This returns a list of spaces in the following cases: <br/><ul><li>the given user is the authenticated user</li><li>the authenticated user is in the group /platform/administrators</li></ul>")
    public Response getSpacesOfUser(@Context UriInfo uriInfo, @ApiParam(value="User name", required=true) @PathParam(value="id") String id, @ApiParam(value="Offset", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit", required=false, defaultValue="20") @QueryParam(value="limit") int limit, @ApiParam(value="Returning the number of spaces or not", defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @ApiParam(value="Asking for a full representation of a specific subresource, ex: <em>members</em> or <em>managers</em>", required=false) @QueryParam(value="expand") String expand) throws Exception {
        offset = offset > 0 ? offset : RestUtils.getOffset(uriInfo);
        limit = limit > 0 ? limit : RestUtils.getLimit(uriInfo);
        Identity target = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", id, true);
        if (target == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        if (!this.userACL.getSuperUser().equals(authenticatedUser) && !authenticatedUser.equals(id)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        ArrayList<DataEntity> spaceInfos = new ArrayList<DataEntity>();
        ListAccess listAccess = ((SpaceService)CommonsUtils.getService(SpaceService.class)).getMemberSpaces(id);
        for (Space space : (Space[])listAccess.load(offset, limit)) {
            SpaceEntity spaceInfo = EntityBuilder.buildEntityFromSpace(space, id, uriInfo.getPath(), expand);
            spaceInfos.add(spaceInfo.getDataEntity());
        }
        CollectionEntity collectionSpace = new CollectionEntity(spaceInfos, "spaces", offset, limit);
        if (returnSize) {
            collectionSpace.setSize(listAccess.getSize());
        }
        return EntityBuilder.getResponse(collectionSpace, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @GET
    @Path(value="{id}/activities")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets activities of a specific user", httpMethod="GET", response=Response.class, notes="This returns an activity in the list in the following cases: <br/><ul><li>this is a user activity and the owner of the activity is the authenticated user or one of his connections</li><li>this is a space activity and the authenticated user is a member of the space</li></ul>")
    public Response getActivitiesOfUser(@Context UriInfo uriInfo, @ApiParam(value="User name", required=true) @PathParam(value="id") String id, @ApiParam(value="Activity stream type, ex: <em>owner, connections, spaces</em> or <em>all</em>", required=false, defaultValue="all") @QueryParam(value="type") String type, @ApiParam(value="Offset", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit", required=false, defaultValue="20") @QueryParam(value="limit") int limit, @ApiParam(value="Base time to load older activities (yyyy-MM-dd HH:mm:ss)", required=false) @QueryParam(value="before") String before, @ApiParam(value="Base time to load newer activities (yyyy-MM-dd HH:mm:ss)", required=false) @QueryParam(value="after") String after, @ApiParam(value="Returning the number of activities or not", defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @ApiParam(value="Asking for a full representation of a specific subresource, ex: <em>comments</em> or <em>likes</em>", required=false) @QueryParam(value="expand") String expand) throws Exception {
        ACTIVITY_STREAM_TYPE streamType;
        offset = offset > 0 ? offset : RestUtils.getOffset(uriInfo);
        limit = limit > 0 ? limit : RestUtils.getLimit(uriInfo);
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        Identity target = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", id, true);
        if (target == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        try {
            streamType = ACTIVITY_STREAM_TYPE.valueOf(type);
        }
        catch (Exception e) {
            streamType = ACTIVITY_STREAM_TYPE.all;
        }
        ActivityManager activityManager = (ActivityManager)CommonsUtils.getService(ActivityManager.class);
        RealtimeListAccess listAccess = null;
        List activities = null;
        switch (streamType) {
            case all: {
                listAccess = activityManager.getActivityFeedWithListAccess(target);
                break;
            }
            case owner: {
                listAccess = activityManager.getActivitiesWithListAccess(target);
                break;
            }
            case connections: {
                listAccess = activityManager.getActivitiesOfConnectionsWithListAccess(target);
                break;
            }
            case spaces: {
                listAccess = activityManager.getActivitiesOfUserSpacesWithListAccess(target);
                break;
            }
        }
        activities = after != null && RestUtils.getBaseTime(after) > 0L ? listAccess.loadNewer(Long.valueOf(RestUtils.getBaseTime(after)), limit) : (before != null && RestUtils.getBaseTime(before) > 0L ? listAccess.loadOlder(Long.valueOf(RestUtils.getBaseTime(before)), limit) : listAccess.loadAsList(offset, limit));
        Identity currentUser = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", authenticatedUser, true);
        ArrayList<DataEntity> activityEntities = new ArrayList<DataEntity>();
        for (ExoSocialActivity activity : activities) {
            DataEntity as = EntityBuilder.getActivityStream(activity, currentUser);
            if (as == null) continue;
            ActivityEntity activityEntity = EntityBuilder.buildEntityFromActivity(activity, uriInfo.getPath(), expand);
            activityEntity.setActivityStream(as);
            activityEntities.add(activityEntity.getDataEntity());
        }
        CollectionEntity collectionActivity = new CollectionEntity(activityEntities, "activities", offset, limit);
        if (returnSize) {
            if (before != null || after != null) {
                collectionActivity.setSize(activities.size());
            } else {
                collectionActivity.setSize(listAccess.getSize());
            }
        }
        return EntityBuilder.getResponse(collectionActivity, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @POST
    @Path(value="{id}/activities")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Creates an activity by a specific user", httpMethod="POST", response=Response.class, notes="This creates the activity if the given user is the authenticated user.")
    public Response addActivityByUser(@Context UriInfo uriInfo, @ApiParam(value="User name", required=true) @PathParam(value="id") String id, @ApiParam(value="Asking for a full representation of a specific subresource, ex: <em>comments</em> or <em>likes</em>", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="Activity object to be created, in which the title of activity is required, ex: <br/>{\"title\": \"act4 posted\"}", required=true) ActivityRestIn model) throws Exception {
        if (model == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        Identity target = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", id, true);
        if (target == null || !ConversationState.getCurrent().getIdentity().getUserId().equals(id)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(model.getTitle());
        activity.setBody(model.getBody());
        activity.setType(model.getType());
        activity.setUserId(target.getId());
        if (model.getFiles() != null) {
            activity.setFiles(model.getFiles().stream().map(fileModel -> new ActivityFile(fileModel.getUploadId(), fileModel.getStorage())).collect(Collectors.toList()));
        }
        ((ActivityManager)CommonsUtils.getService(ActivityManager.class)).saveActivityNoReturn(target, (ExoSocialActivity)activity);
        return EntityBuilder.getResponse(EntityBuilder.buildEntityFromActivity((ExoSocialActivity)activity, uriInfo.getPath(), expand), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    private void fillUserFromModel(User user, UserEntity model) {
        if (model.getFirstname() != null && !model.getFirstname().isEmpty()) {
            user.setFirstName(model.getFirstname());
        }
        if (model.getLastname() != null && !model.getLastname().isEmpty()) {
            user.setLastName(model.getLastname());
        }
        if (model.getEmail() != null && !model.getEmail().isEmpty()) {
            user.setEmail(model.getEmail());
        }
        if (model.getPassword() != null && !model.getPassword().isEmpty()) {
            user.setPassword(model.getPassword());
        }
    }

    private Identity[] getOnlineIdentitiesOfSpace(String userId, Space space, int limit) {
        ArrayList<Identity> identities = new ArrayList<Identity>();
        String[] spaceMembers = space.getMembers();
        String superUserName = this.userACL.getSuperUser();
        for (String user : spaceMembers) {
            UserStateModel userModel = this.userStateService.getUserState(user);
            boolean isOnline = this.userStateService.isOnline(user);
            if (user.equals(userId) || user.equals(superUserName) || userModel == null || INVISIBLE.equals(userModel.getStatus()) || !isOnline) continue;
            Identity userIdentity = this.identityManager.getOrCreateIdentity("organization", user, false);
            identities.add(userIdentity);
            if (identities.size() == limit) break;
        }
        return identities.toArray(new Identity[identities.size()]);
    }

    private Identity[] getOnlineIdentities(String userId, int limit) {
        ArrayList<Identity> identities = new ArrayList<Identity>();
        List users = this.userStateService.online();
        Collections.reverse(users);
        if (users.size() > limit) {
            users = users.subList(0, limit);
        }
        String superUserName = this.userACL.getSuperUser();
        for (UserStateModel userModel : users) {
            String user = userModel.getUserId();
            if (user.equals(userId) || user.equals(superUserName) || userModel == null || INVISIBLE.equals(userModel.getStatus())) continue;
            Identity userIdentity = this.identityManager.getOrCreateIdentity("organization", user, false);
            identities.add(userIdentity);
        }
        return identities.toArray(new Identity[identities.size()]);
    }

    public static User getUserByEmail(String email) {
        if (email == null) {
            return null;
        }
        try {
            Query query = new Query();
            query.setEmail(email);
            OrganizationService service = (OrganizationService)CommonsUtils.getService(OrganizationService.class);
            User[] users = (User[])service.getUserHandler().findUsersByQuery(query).load(0, 10);
            return users[0];
        }
        catch (Exception e) {
            return null;
        }
    }

    public static enum ACTIVITY_STREAM_TYPE {
        all,
        owner,
        connections,
        spaces;

    }
}

