/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.migration;

import org.exoplatform.commons.upgrade.DeleteJCRFolderUpgradePlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.organization.externalstore.IDMExternalStoreService;
import org.exoplatform.services.transaction.TransactionService;

public class DeleteOrganizationIntegrationFoldersUpgradePlugin
extends DeleteJCRFolderUpgradePlugin {
    private static final Log LOG = ExoLogger.getLogger(DeleteOrganizationIntegrationFoldersUpgradePlugin.class);
    private final OrganizationService organizationService;
    private final IDMExternalStoreService externalStoreService;

    public DeleteOrganizationIntegrationFoldersUpgradePlugin(RepositoryService repositoryService, TransactionService transactionService, OrganizationService organizationService, IDMExternalStoreService externalStoreService, InitParams initParams) {
        super(repositoryService, transactionService, initParams);
        this.externalStoreService = externalStoreService;
        this.organizationService = organizationService;
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        try {
            int totalFoldersCountApproximation = this.organizationService.getUserHandler().findAllUsers(UserStatus.ANY).getSize();
            LOG.info("Attempt to delete JCR folders of Organization Integration service (approximatively {} folders)", new Object[]{totalFoldersCountApproximation *= 5});
            super.processUpgrade(oldVersion, newVersion);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred while Deleting Organization Integration service folders");
        }
    }

    public boolean isEnabled() {
        if (this.externalStoreService == null || !this.externalStoreService.isEnabled()) {
            LOG.info((Object)"ExternalStore is disabled, thus the OrganizationIntegrationService data will be kept");
            return false;
        }
        return super.isEnabled();
    }
}

