/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.listener.social.profile;

import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.addons.gamification.service.effective.GamificationService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.profile.ProfileLifeCycleEvent;
import org.exoplatform.social.core.profile.ProfileListenerPlugin;
import org.exoplatform.social.core.space.spi.SpaceService;

@Asynchronous
public class GamificationProfileListener
extends ProfileListenerPlugin {
    private static final Log LOG = ExoLogger.getLogger(GamificationProfileListener.class);
    protected RuleService ruleService = (RuleService)CommonsUtils.getService(RuleService.class);
    protected IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
    protected SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
    protected GamificationService gamificationService = (GamificationService)CommonsUtils.getService(GamificationService.class);

    public void avatarUpdated(ProfileLifeCycleEvent event) {
        Long lastUpdate = event.getProfile().getAvatarLastUpdated();
        if (lastUpdate != null) {
            return;
        }
        this.gamificationService.createHistory("addUserProfileAvatar", event.getProfile().getId(), event.getProfile().getId(), "/portal/intranet/profile/");
    }

    public void bannerUpdated(ProfileLifeCycleEvent event) {
        Object aHistory = null;
        Long lastUpdate = event.getProfile().getBannerLastUpdated();
        if (lastUpdate != null) {
            return;
        }
        String receiver = event.getProfile().getId();
        this.gamificationService.createHistory("addUserProfileBanner", receiver, receiver, "/portal/intranet/profile/");
    }

    public void basicInfoUpdated(ProfileLifeCycleEvent event) {
    }

    public void contactSectionUpdated(ProfileLifeCycleEvent event) {
    }

    public void experienceSectionUpdated(ProfileLifeCycleEvent event) {
    }

    public void headerSectionUpdated(ProfileLifeCycleEvent event) {
    }

    public void createProfile(ProfileLifeCycleEvent event) {
    }

    public void aboutMeUpdated(ProfileLifeCycleEvent event) {
        this.gamificationService.createHistory("addUserProfileAboutMe", event.getProfile().getId(), event.getProfile().getIdentity().getId(), "/portal/intranet/profile/" + event.getProfile().getIdentity().getId());
    }
}

