/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.upgrade.plugins;

import java.util.Date;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.importer.Imported;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageService;
import org.exoplatform.portal.pom.config.POMSession;
import org.exoplatform.portal.pom.config.POMSessionManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.gatein.mop.api.workspace.Workspace;

public class ProfilePageUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger((String)ProfilePageUpgradePlugin.class.getName());
    private static final String INTRANET = "intranet";
    private static final String PROFILE_PAGE = "profile";
    private DataStorage dataStorage;
    private UserPortalConfigService portalConfigService;
    private final POMSessionManager pomMgr;
    private PageService pageService;

    public ProfilePageUpgradePlugin(UserPortalConfigService portalConfigService, POMSessionManager pomMgr, DataStorage dataStorage, PageService pageService, InitParams initParams) {
        super(initParams);
        this.dataStorage = dataStorage;
        this.portalConfigService = portalConfigService;
        this.pomMgr = pomMgr;
        this.pageService = pageService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        block14: {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Start " + ((Object)((Object)this)).getClass().getName() + "............."));
            }
            try {
                RequestLifeCycle.begin((ExoContainer)ExoContainerContext.getCurrentContainer());
                SiteKey siteKey = new SiteKey(SiteType.PORTAL, INTRANET);
                PageKey pageKey = new PageKey(siteKey, PROFILE_PAGE);
                Page page = this.dataStorage.getPage(pageKey.format());
                if (page == null) {
                    return;
                }
                this.pageService.destroyPage(pageKey);
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"profile page has been removed!");
                }
                POMSession session = this.pomMgr.getSession();
                Workspace workspace = session.getWorkspace();
                Imported imported = (Imported)workspace.adapt(Imported.class);
                imported.setLastModificationDate(new Date());
                imported.setStatus(Integer.valueOf(Imported.Status.WANT_REIMPORT.status()));
                session.save();
                LOG.info((Object)"Import status updated successfully!");
            }
            catch (Exception e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"An unexpected error occurs when migrating pages:", (Throwable)e);
                }
            }
            finally {
                RequestLifeCycle.end();
            }
            try {
                LOG.info((Object)"Starts to reimport portal configuration....");
                this.portalConfigService.start();
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)(((Object)((Object)this)).getClass().getName() + " finished successfully!"));
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block14;
                LOG.error((Object)"An unexpected error occurs when migrating pages:", (Throwable)e);
            }
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }
}

