/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.upgrade.plugins;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.service.setting.PluginContainer;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.commons.notification.NotificationConfiguration;
import org.exoplatform.commons.notification.NotificationUtils;
import org.exoplatform.commons.notification.impl.NotificationSessionManager;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.chromattic.entity.IdentityEntity;

public class UpgradeUserNotificationSettingPlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger(UpgradeUserNotificationSettingPlugin.class);
    private static final int LIMIT_LOAD_THRESHOLD = 500;
    private static final String SETTING_LIFE_CYCLE_NAME = "setting";
    private final String workspace;
    private final String settingWorkspace;
    private final String socialWorkspace;
    private String activeChannelList = null;
    private String inactiveChannelList = null;
    private Map<String, String> channelProperties;

    public UpgradeUserNotificationSettingPlugin(InitParams initParams, ChromatticManager manager) {
        super(initParams);
        NotificationConfiguration configuration = (NotificationConfiguration)CommonsUtils.getService(NotificationConfiguration.class);
        this.workspace = configuration != null ? configuration.getWorkspace() : null;
        this.socialWorkspace = manager.getLifeCycle("soc").getWorkspaceName();
        this.settingWorkspace = manager.getLifeCycle(SETTING_LIFE_CYCLE_NAME).getWorkspaceName();
        this.channelProperties = new HashMap<String, String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        if (this.workspace == null) {
            return;
        }
        boolean created = NotificationSessionManager.createSystemProvider();
        SessionProvider sProvider = NotificationSessionManager.getSessionProvider();
        this.loadChannels();
        int offset = 0;
        long total = System.currentTimeMillis();
        try {
            Session socialSession = this.getJCRSession(sProvider, this.socialWorkspace);
            NodeIterator ni = this.getIdentityNodes(socialSession, offset, 500);
            Node node = null;
            String remoteId = null;
            long t = 0L;
            while (ni.hasNext()) {
                node = ni.nextNode();
                remoteId = node.getProperty(IdentityEntity.remoteId.getName()).getString();
                t = System.currentTimeMillis();
                LOG.info((Object)String.format("| \\ START::user number: %s (%s user)", offset, remoteId));
                this.processUpgrade(sProvider, remoteId);
                LOG.info((Object)String.format("| // END::Migration setting (%s user) consumed time: %s", remoteId, System.currentTimeMillis() - t));
                if (++offset % 500 != 0) continue;
                socialSession.logout();
                socialSession = null;
                socialSession = this.getJCRSession(sProvider, this.socialWorkspace);
                ni = this.getIdentityNodes(socialSession, offset, 500);
            }
        }
        catch (Exception e) {
            try {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                LOG.info((Object)String.format("| DONE::total: %s user(s) consumed time: %s", offset, System.currentTimeMillis() - total));
                NotificationSessionManager.closeSessionProvider((boolean)created);
                throw throwable;
            }
            LOG.info((Object)String.format("| DONE::total: %s user(s) consumed time: %s", offset, System.currentTimeMillis() - total));
            NotificationSessionManager.closeSessionProvider((boolean)created);
        }
        LOG.info((Object)String.format("| DONE::total: %s user(s) consumed time: %s", offset, System.currentTimeMillis() - total));
        NotificationSessionManager.closeSessionProvider((boolean)created);
    }

    private void processUpgrade(SessionProvider sProvider, String remoteId) throws PathNotFoundException, RepositoryException {
        Node userNode = this.getUserSettingNode(sProvider, remoteId);
        if (userNode == null) {
            this.addMixin(sProvider, remoteId);
            return;
        }
        boolean mustMigration = this.mustUpgrade(userNode);
        String globalPath = Scope.GLOBAL.toString().toLowerCase();
        Node userSettingNode = userNode.hasNode(globalPath) ? userNode.getNode(globalPath) : null;
        UpgradeBuilder upgradeBuilder = this.builder(userSettingNode).doNormalization(userNode, remoteId);
        if (userSettingNode != null && mustMigration) {
            upgradeBuilder.upgradeDaily().upgradeWeekly().upgradeInstantly().upgradeIsActive().upgradeChannels();
        }
        upgradeBuilder.done();
    }

    private UpgradeBuilder builder(Node userSettingNode) {
        return new UpgradeBuilder(userSettingNode);
    }

    private String getChannelProperty(String channelId) {
        return "exo:{CHANNELID}Channel".replace("{CHANNELID}", channelId);
    }

    private String loadActiveValue() {
        if (this.activeChannelList == null) {
            ChannelManager channelManager = (ChannelManager)CommonsUtils.getService(ChannelManager.class);
            ArrayList<String> channelIds = new ArrayList<String>();
            for (AbstractChannel channel : channelManager.getChannels()) {
                channelIds.add(channel.getId());
            }
            this.activeChannelList = StringUtils.join(channelIds, (char)',');
        }
        return this.activeChannelList;
    }

    private void loadChannels() {
        if (this.channelProperties == null || this.channelProperties.size() == 0) {
            PluginContainer container = (PluginContainer)CommonsUtils.getService(PluginContainer.class);
            ChannelManager channelManager = (ChannelManager)CommonsUtils.getService(ChannelManager.class);
            for (AbstractChannel channel : channelManager.getChannels()) {
                if ("MAIL_CHANNEL".equals(channel.getId())) continue;
                this.channelProperties.put(channel.getId(), NotificationUtils.listToString((List)container.getDefaultActivePlugins(), (String)"{VALUE}"));
            }
        }
    }

    private String loadInactiveValue() {
        if (this.inactiveChannelList == null) {
            ChannelManager channelManager = (ChannelManager)CommonsUtils.getService(ChannelManager.class);
            ArrayList<String> channelIds = new ArrayList<String>();
            for (AbstractChannel channel : channelManager.getChannels()) {
                if ("MAIL_CHANNEL".equals(channel.getId())) continue;
                channelIds.add(channel.getId());
            }
            this.inactiveChannelList = StringUtils.join(channelIds, (char)',');
        }
        return this.inactiveChannelList;
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }

    private void upgradeProperty(Node userSettingNode, String property, String propertyValue) throws ValueFormatException, PathNotFoundException, RepositoryException {
        if ("exo:daily".equals(property) && userSettingNode.hasProperty("exo:daily")) {
            Value value = userSettingNode.getProperty(property).getValue();
            if (value != null) {
                String oldValue = value.getString();
                String newValue = NotificationUtils.listToString((List)NotificationUtils.stringToList((String)oldValue), (String)"{VALUE}");
                userSettingNode.setProperty(property, newValue);
            }
        } else if ("exo:weekly".equals(property) && userSettingNode.hasProperty("exo:weekly")) {
            Value value = userSettingNode.getProperty(property).getValue();
            if (value != null) {
                String oldValue = value.getString();
                String newValue = NotificationUtils.listToString((List)NotificationUtils.stringToList((String)oldValue), (String)"{VALUE}");
                userSettingNode.setProperty(property, newValue);
            }
        } else if ("exo:instantly".equals(property)) {
            Value value;
            if (userSettingNode.hasProperty("exo:instantly") && (value = userSettingNode.getProperty(property).getValue()) != null) {
                String oldValue = value.getString();
                String newValue = NotificationUtils.listToString((List)NotificationUtils.stringToList((String)oldValue), (String)"{VALUE}");
                userSettingNode.setProperty("exo:{CHANNELID}Channel".replace("{CHANNELID}", "MAIL_CHANNEL"), newValue);
                userSettingNode.setProperty("exo:instantly", (Value)null);
            }
        } else if ("exo:isActive".equals(property)) {
            Value value;
            if (userSettingNode.hasProperty("exo:isActive") && (value = userSettingNode.getProperty(property).getValue()) != null) {
                String oldValue = value.getString();
                String newValue = "";
                newValue = "true".equals(oldValue) ? this.loadActiveValue() : ("false".equals(oldValue) || oldValue.isEmpty() ? this.loadInactiveValue() : oldValue);
                userSettingNode.setProperty("exo:isActive", newValue);
            }
        } else {
            userSettingNode.setProperty(property, propertyValue);
        }
    }

    private NodeIterator getIdentityNodes(Session session, int offset, int limit) {
        try {
            StringBuilder sqlQuery = new StringBuilder("SELECT * FROM ").append("soc:identitydefinition").append(" WHERE ").append(" (").append("jcr:path LIKE '").append("/production/soc:providers/soc:organization/%'").append(" AND NOT jcr:path LIKE '").append("/production/soc:providers/soc:organization/%/%'").append(")");
            String queryStatement = sqlQuery.toString();
            QueryManager queryMgr = session.getWorkspace().getQueryManager();
            Query query = queryMgr.createQuery(queryStatement, "sql");
            QueryImpl impl = (QueryImpl)query;
            impl.setOffset((long)offset);
            impl.setLimit((long)limit);
            return query.execute().getNodes();
        }
        catch (Exception ex) {
            LOG.error((Object)"Query is failed!.", (Throwable)ex);
            return null;
        }
    }

    private Session getJCRSession(SessionProvider sProvider, String wpName) {
        Session session = null;
        try {
            session = sProvider.getSession(wpName, CommonsUtils.getRepository());
        }
        catch (RepositoryException e) {
            LOG.error((Object)e);
        }
        return session;
    }

    private void addMixin(SessionProvider sProvider, String userName) {
        try {
            Session session = this.getJCRSession(sProvider, this.settingWorkspace);
            Node userHomeNode = this.getUserSettingHome(session);
            Node userNode = userHomeNode.addNode(userName, "stg:simplecontext");
            if (userNode.canAddMixin("mix:defaultSetting")) {
                userNode.addMixin("mix:defaultSetting");
                LOG.debug((Object)("|| Done to addMixin default setting for user: " + userName));
            }
            session.save();
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to addMixin for user notification setting", (Throwable)e);
        }
    }

    private Node getUserSettingHome(Session session) throws Exception {
        Node settingNode = session.getRootNode().getNode("settings");
        Node userHomeNode = null;
        if (!settingNode.hasNode("user")) {
            userHomeNode = settingNode.addNode("user", "stg:subcontext");
            session.save();
        } else {
            userHomeNode = settingNode.getNode("user");
        }
        return userHomeNode;
    }

    private Node getUserSettingNode(SessionProvider sProvider, String userName) {
        Session session = this.getJCRSession(sProvider, this.settingWorkspace);
        try {
            return (Node)session.getItem("/settings/user/" + userName);
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean mustUpgrade(Node userNode) {
        try {
            if (userNode.isNodeType("mix:defaultSetting")) {
                if (userNode.hasNode(Scope.GLOBAL.toString().toLowerCase())) {
                    Node global = userNode.getNode(Scope.GLOBAL.toString().toLowerCase());
                    return global.hasProperty("exo:instantly") || global.hasProperty("exo:daily") || global.hasProperty("exo:weekly");
                }
                return false;
            }
            if (!userNode.isNodeType("mix:defaultSetting") && userNode.hasNode(Scope.GLOBAL.toString().toLowerCase())) {
                Node global = userNode.getNode(Scope.GLOBAL.toString().toLowerCase());
                return global.hasProperty("exo:instantly") || global.hasProperty("exo:daily") || global.hasProperty("exo:weekly");
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void normalize(Node userNode, String remoteId) {
        block5: {
            try {
                Node global;
                if (userNode.isNodeType("mix:defaultSetting") && userNode.hasNode(Scope.GLOBAL.toString().toLowerCase()) && ((global = userNode.getNode(Scope.GLOBAL.toString().toLowerCase())).hasProperty("exo:instantly") || global.hasProperty("exo:daily") || global.hasProperty("exo:weekly"))) {
                    LOG.info((Object)String.format("   CASE 1:: %s user has both mixin and notif setting >> Action: remove mixin", remoteId));
                    userNode.removeMixin("mix:defaultSetting");
                    return;
                }
                if (userNode.isNodeType("mix:defaultSetting")) break block5;
                if (userNode.hasNode(Scope.GLOBAL.toString().toLowerCase())) {
                    global = userNode.getNode(Scope.GLOBAL.toString().toLowerCase());
                    if (!(global.hasProperty("exo:instantly") || global.hasProperty("exo:daily") || global.hasProperty("exo:weekly"))) {
                        LOG.info((Object)String.format("   CASE 2:: %s user has NOT both mixin and notif setting >> Action: add mixin", remoteId));
                        userNode.addMixin("mix:defaultSetting");
                        return;
                    }
                    break block5;
                }
                LOG.info((Object)String.format("   CASE 3:: %s user has NOT both mixin and global node >> Action: add mixin", remoteId));
                userNode.addMixin("mix:defaultSetting");
                return;
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private class UpgradeBuilder {
        private final Node userSettingNode;

        private UpgradeBuilder(Node userSettingNode) {
            this.userSettingNode = userSettingNode;
        }

        private UpgradeBuilder upgradeDaily() throws RepositoryException {
            UpgradeUserNotificationSettingPlugin.this.upgradeProperty(this.userSettingNode, "exo:daily", null);
            return this;
        }

        private UpgradeBuilder upgradeWeekly() throws RepositoryException {
            UpgradeUserNotificationSettingPlugin.this.upgradeProperty(this.userSettingNode, "exo:weekly", null);
            return this;
        }

        private UpgradeBuilder upgradeInstantly() throws RepositoryException {
            UpgradeUserNotificationSettingPlugin.this.upgradeProperty(this.userSettingNode, "exo:instantly", null);
            return this;
        }

        private UpgradeBuilder upgradeIsActive() throws RepositoryException {
            UpgradeUserNotificationSettingPlugin.this.upgradeProperty(this.userSettingNode, "exo:isActive", null);
            return this;
        }

        private UpgradeBuilder upgradeChannels() throws RepositoryException {
            LOG.info((Object)String.format("  %s channel(s) will be add the plugins in the user setting", UpgradeUserNotificationSettingPlugin.this.channelProperties.size()));
            for (Map.Entry entry : UpgradeUserNotificationSettingPlugin.this.channelProperties.entrySet()) {
                String key = UpgradeUserNotificationSettingPlugin.this.getChannelProperty((String)entry.getKey());
                UpgradeUserNotificationSettingPlugin.this.upgradeProperty(this.userSettingNode, key, (String)entry.getValue());
            }
            return this;
        }

        private UpgradeBuilder doNormalization(Node userNode, String remoteId) throws RepositoryException {
            UpgradeUserNotificationSettingPlugin.this.normalize(userNode, remoteId);
            if (this.userSettingNode == null) {
                userNode.getSession().save();
            }
            return this;
        }

        private void done() throws RepositoryException {
            if (this.userSettingNode != null) {
                this.userSettingNode.getSession().save();
            }
        }
    }
}

