/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.mop.core.api.content;

import java.util.HashMap;
import java.util.Map;
import org.gatein.mop.api.content.ContentType;
import org.gatein.mop.core.api.content.ContentRegistration;
import org.gatein.mop.spi.content.ContentProvider;

public class ContentManagerRegistry {
    public final transient Map<String, ContentRegistration> providers = new HashMap<String, ContentRegistration>();

    public synchronized <E> void register(ContentType<E> contentType, ContentProvider<E, ?> contentProvider) {
        if (contentType == null) {
            throw new NullPointerException();
        }
        if (contentProvider == null) {
            throw new NullPointerException();
        }
        this.providers.put(contentType.getMimeType(), new ContentRegistration(contentType, contentProvider));
    }

    public synchronized void unregister(ContentType contentType) {
        if (contentType == null) {
            throw new NullPointerException();
        }
        this.providers.remove(contentType.getMimeType());
    }
}

