/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.command;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.command.NotificationCommand;
import org.exoplatform.commons.api.notification.command.NotificationExecutor;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.service.NotificationCompletionService;
import org.exoplatform.commons.api.notification.service.storage.NotificationService;
import org.exoplatform.commons.notification.impl.NotificationSessionManager;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class NotificationExecutorImpl
implements NotificationExecutor {
    private static final Log LOG = ExoLogger.getLogger(NotificationExecutorImpl.class);
    private final List<NotificationCommand> commands = new CopyOnWriteArrayList<NotificationCommand>();
    private NotificationCompletionService completionService;
    private NotificationService notificationService = CommonsUtils.getService(NotificationService.class);

    public NotificationExecutorImpl() {
        this.completionService = CommonsUtils.getService(NotificationCompletionService.class);
    }

    private boolean process(NotificationContext ctx, NotificationCommand command) {
        try {
            if (!command.getPlugin().isValid(ctx)) {
                return false;
            }
            Callable<Boolean> task = () -> {
                try {
                    ExoContainerContext.setCurrentContainer((ExoContainer)PortalContainer.getInstance());
                    NotificationInfo notifiction = this.create(ctx, command);
                    if (notifiction != null) {
                        this.notificationService.process(notifiction);
                    }
                }
                catch (Exception e) {
                    LOG.warn((Object)("Process NotificationInfo is failed: " + e.getMessage()), (Throwable)e);
                    LOG.debug((Object)e.getMessage(), (Throwable)e);
                    return false;
                }
                return true;
            };
            this.completionService.addTask(task);
            return true;
        }
        catch (Exception e) {
            ctx.setException((Throwable)e);
            return false;
        }
    }

    private NotificationInfo create(NotificationContext ctx, NotificationCommand command) {
        return command.processNotification(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(NotificationContext ctx) {
        boolean result = true;
        if (!CommonsUtils.isFeatureActive("notification")) {
            this.commands.clear();
            return result;
        }
        boolean created = NotificationSessionManager.createSystemProvider();
        try {
            for (NotificationCommand command : this.commands) {
                result &= this.process(ctx, command);
                this.printLog(ctx);
            }
        }
        finally {
            NotificationSessionManager.closeSessionProvider(created);
        }
        this.commands.clear();
        return result;
    }

    private void printLog(NotificationContext ctx) {
        if (ctx.isFailed()) {
            LOG.error((Object)"Failed to process the notification.", (Throwable)ctx.getException());
        }
    }

    public NotificationExecutor with(NotificationCommand command) {
        if (command != null) {
            this.commands.add(command);
        }
        return this;
    }

    public NotificationExecutor with(List<NotificationCommand> commands) {
        this.commands.addAll(commands);
        return this;
    }
}

