/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.conf;

import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.forum.common.jcr.KSDataLocation;
import org.exoplatform.forum.common.jcr.SessionManager;
import org.exoplatform.forum.service.ForumServiceUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipEventListener;

public class ForumMembershipEventListener
extends MembershipEventListener {
    private Log LOG = ExoLogger.getLogger(ForumMembershipEventListener.class);
    public static final String PLATFORM_ADMIN_GROUP = "/platform/administrators";

    public void preSave(Membership m, boolean isNew) throws Exception {
        ForumServiceUtils.clearCache();
    }

    public void preDelete(Membership m) throws Exception {
        ForumServiceUtils.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSave(Membership m, boolean isNew) throws Exception {
        if (PLATFORM_ADMIN_GROUP.equals(m.getGroupId())) {
            SessionManager sessionManager = null;
            Session session = null;
            try {
                KSDataLocation dataLocation = (KSDataLocation)CommonsUtils.getService(KSDataLocation.class);
                sessionManager = dataLocation.getSessionManager();
                session = sessionManager.openSession();
                Node rootNode = session.getRootNode();
                if (rootNode.hasNode(dataLocation.getUserProfilesLocation() + "/" + m.getUserName())) {
                    Node userProfileNode = rootNode.getNode(dataLocation.getUserProfilesLocation()).getNode(m.getUserName());
                    userProfileNode.setProperty("exo:userRole", 0L);
                    userProfileNode.save();
                }
            }
            catch (Exception e) {
                this.LOG.error((Object)("Failed to update user role : " + e.getMessage()), (Throwable)e);
            }
            finally {
                if (session != null) {
                    sessionManager.closeSession(true);
                }
            }
        }
    }
}

