/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.impl;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.QueryManager;
import net.fortuna.ical4j.model.DateTime;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarException;
import org.exoplatform.calendar.service.EventDAO;
import org.exoplatform.calendar.service.EventPageListQuery;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.service.Invitation;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.service.impl.CalendarServiceImpl;
import org.exoplatform.calendar.service.impl.EventListAccess;
import org.exoplatform.calendar.service.impl.InvitationListAccess;
import org.exoplatform.calendar.service.impl.JCRDataStorage;
import org.exoplatform.commons.utils.ActivityTypeUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

@Deprecated
public class EventDAOImpl
implements EventDAO {
    private static Log log = ExoLogger.getLogger(EventDAOImpl.class);
    private CalendarServiceImpl calService;
    protected JCRDataStorage storage;

    public EventDAOImpl(CalendarServiceImpl calService, JCRDataStorage storage_) {
        this.calService = calService;
        this.storage = storage_;
    }

    @Override
    public ListAccess<CalendarEvent> findEventsByQuery(EventQuery eventQuery) throws CalendarException {
        return new EventListAccess(this, eventQuery);
    }

    @Override
    public ListAccess<Invitation> findInvitationsByQuery(EventQuery query) {
        return new InvitationListAccess(this, query);
    }

    @Override
    public Invitation getInvitationById(String invitationID) throws CalendarException {
        String[] tmp = Invitation.parse(invitationID);
        String eventId = tmp[0];
        String participant = tmp[1];
        CalendarEvent event = null;
        try {
            event = this.calService.getEventById(eventId);
        }
        catch (Exception e) {
            log.error("error during get event: {}, exeption: {}", new Object[]{eventId, e.getMessage()});
            throw new CalendarException(null, (Throwable)e);
        }
        if (event != null) {
            Invitation[] invitations;
            for (Invitation invite : invitations = event.getInvitations()) {
                if (!invite.getParticipant().equals(participant)) continue;
                return invite;
            }
        } else {
            log.debug("Can't find invitation due to event not found: {}", new Object[]{invitationID});
        }
        return null;
    }

    @Override
    public void removeInvitation(String invitationId) throws CalendarException {
        String[] tmp = Invitation.parse(invitationId);
        String eventId = tmp[0];
        String participant = tmp[1];
        CalendarEvent event = null;
        try {
            event = this.calService.getEventById(eventId);
        }
        catch (Exception e) {
            log.error("Can't remove Invitation, there is error during get event {}", new Object[]{eventId});
            throw new CalendarException(null, (Throwable)e);
        }
        if (event != null) {
            event.removeParticipant(participant);
            try {
                this.saveEvent(participant, event);
            }
            catch (Exception e) {
                log.error((Object)"Can't remove invitation, there is error during saving event {}", (Throwable)e);
                throw new CalendarException(null, (Throwable)e);
            }
        }
    }

    @Override
    public void updateInvitation(String id, String status) {
        Map<String, String> statusMap;
        String currStatus;
        String[] tmp = Invitation.parse(id);
        String eventId = tmp[0];
        String participant = tmp[1];
        CalendarEvent event = null;
        try {
            event = this.calService.getEventById(eventId);
        }
        catch (Exception e) {
            log.error("Can't update invitation due to can't find event {}", new Object[]{eventId});
            throw new CalendarException(null, (Throwable)e);
        }
        if (event != null && (currStatus = (statusMap = event.getStatusMap()).get(participant)) != null && !currStatus.equals(status)) {
            statusMap.put(participant, status);
            event.setStatusMap(statusMap);
            try {
                this.saveEvent(participant, event);
            }
            catch (Exception e) {
                log.error("Can't update invitation. There is error event {}", new Object[]{eventId});
                throw new CalendarException(null, (Throwable)e);
            }
        }
    }

    @Override
    public Invitation createInvitation(String eventId, String participant, String status) throws CalendarException {
        CalendarEvent event;
        try {
            event = this.calService.getEventById(eventId);
        }
        catch (Exception e) {
            log.error("Can't create invitation. There is error duing getting event: {}", new Object[]{eventId});
            throw new CalendarException(null, (Throwable)e);
        }
        if (event != null && event.getStatusMap().get(participant) == null) {
            event.addParticipant(participant, status);
            try {
                this.saveEvent(participant, event);
                return new Invitation(eventId, participant, status);
            }
            catch (Exception e) {
                log.error("Can't create invitation. There is error during saving event: {}", new Object[]{eventId});
                throw new CalendarException(null, (Throwable)e);
            }
        }
        return null;
    }

    private void saveEvent(String username, CalendarEvent event) throws Exception {
        String calendarId = event.getCalendarId();
        Calendar cal = this.calService.getCalendarById(calendarId);
        String owner = cal.getCalendarOwner();
        int type = this.calService.getTypeOfCalendar(owner, calendarId);
        switch (type) {
            case 0: {
                this.calService.saveUserEvent(owner, calendarId, event, false);
                break;
            }
            case 2: {
                this.calService.savePublicEvent(calendarId, event, false);
                break;
            }
            case 1: {
                this.calService.saveEventToSharedCalendar(username, calendarId, event, false);
            }
        }
    }

    public QueryImpl createJCRQuery(SessionProvider provider, String queryStm, String queryType) throws Exception {
        QueryManager qm = this.storage.getSession(provider).getWorkspace().getQueryManager();
        return (QueryImpl)qm.createQuery(queryStm, queryType);
    }

    public CalendarEvent getEventFromNode(Node eventNode) throws RepositoryException {
        CalendarEvent event = new CalendarEvent();
        try {
            event = EventPageListQuery.getEventFromNode(event, eventNode, this.getReminderFolder(eventNode.getProperty("exo:fromDateTime").getDate().getTime()));
        }
        catch (Exception e) {
            log.error((Object)"Error during mapping node to CalendarEvent", (Throwable)e);
            return null;
        }
        StringBuilder namePattern = new StringBuilder(128);
        namePattern.append("exo:recurrenceId").append('|').append("exo:isException").append('|').append("exo:repeatUntil").append('|').append("exo:repeatCount").append('|').append("exo:originalReference").append('|').append("exo:repeatInterval").append('|').append("exo:excludeId").append('|').append("exo:repeatByDay").append('|').append("exo:repeatByMonthDay");
        PropertyIterator it = eventNode.getProperties(namePattern.toString());
        while (it.hasNext()) {
            int i;
            Value[] values;
            Property p = it.nextProperty();
            String name = p.getName();
            if (name.equals("exo:recurrenceId")) {
                event.setRecurrenceId(p.getString());
                continue;
            }
            if (name.equals("exo:isException")) {
                event.setIsExceptionOccurrence(p.getBoolean());
                continue;
            }
            if (name.equals("exo:repeatUntil")) {
                event.setRepeatUntilDate(p.getDate().getTime());
                continue;
            }
            if (name.equals("exo:repeatCount")) {
                event.setRepeatCount(p.getLong());
                continue;
            }
            if (name.equals("exo:originalReference")) {
                event.setOriginalReference(p.getString());
                continue;
            }
            if (name.equals("exo:repeatInterval")) {
                event.setRepeatInterval(p.getLong());
                continue;
            }
            if (name.equals("exo:excludeId")) {
                values = p.getValues();
                if (values.length == 1) {
                    event.setExcludeId(new String[]{values[0].getString()});
                    continue;
                }
                String[] excludeIds = new String[values.length];
                for (i = 0; i < values.length; ++i) {
                    excludeIds[i] = values[i].getString();
                }
                event.setExcludeId(excludeIds);
                continue;
            }
            if (name.equals("exo:repeatByDay")) {
                values = p.getValues();
                if (values.length == 1) {
                    event.setRepeatByDay(new String[]{values[0].getString()});
                    continue;
                }
                String[] byDays = new String[values.length];
                for (i = 0; i < values.length; ++i) {
                    byDays[i] = values[i].getString();
                }
                event.setRepeatByDay(byDays);
                continue;
            }
            if (!name.equals("exo:repeatByMonthDay")) continue;
            values = p.getValues();
            if (values.length == 1) {
                event.setRepeatByMonthDay(new long[]{values[0].getLong()});
                continue;
            }
            long[] byMonthDays = new long[values.length];
            for (i = 0; i < values.length; ++i) {
                byMonthDays[i] = values[i].getLong();
            }
            event.setRepeatByMonthDay(byMonthDays);
        }
        String activitiId = ActivityTypeUtils.getActivityId((Node)eventNode);
        if (activitiId != null) {
            event.setActivityId(ActivityTypeUtils.getActivityId((Node)eventNode));
        }
        return event;
    }

    private Node getReminderFolder(Date fromDate) throws Exception {
        Node publicApp = this.storage.getPublicCalendarServiceHome();
        Node dateFolder = this.getDateFolder(publicApp, fromDate);
        try {
            return dateFolder.getNode("reminders");
        }
        catch (PathNotFoundException pnfe) {
            try {
                dateFolder.addNode("reminders", "nt:unstructured");
                if (dateFolder.isNew()) {
                    dateFolder.getSession().save();
                } else {
                    dateFolder.save();
                }
            }
            catch (Exception e) {
                dateFolder.refresh(false);
            }
            return dateFolder.getNode("reminders");
        }
    }

    private Node getDateFolder(Node publicApp, Date date) throws Exception {
        Node monthNode;
        Node yearNode;
        if (date instanceof DateTime) {
            date = new Date(date.getTime());
        }
        GregorianCalendar fromCalendar = Utils.getInstanceTempCalendar();
        fromCalendar.setTime(date);
        String year = "Y" + String.valueOf(fromCalendar.get(1));
        String month = "M" + String.valueOf(fromCalendar.get(2) + 1);
        String day = "D" + String.valueOf(fromCalendar.get(5));
        try {
            yearNode = publicApp.getNode(year);
        }
        catch (PathNotFoundException e) {
            yearNode = publicApp.addNode(year, "nt:unstructured");
        }
        try {
            monthNode = yearNode.getNode(month);
        }
        catch (PathNotFoundException e) {
            monthNode = yearNode.addNode(month, "nt:unstructured");
        }
        try {
            return monthNode.getNode(day);
        }
        catch (PathNotFoundException e) {
            return monthNode.addNode(day, "nt:unstructured");
        }
    }
}

