/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.description;

import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.exoplatform.portal.mop.Described;
import org.exoplatform.portal.mop.description.CacheKey;
import org.exoplatform.portal.mop.description.DataCache;
import org.exoplatform.portal.mop.description.DescriptionService;
import org.exoplatform.portal.mop.description.ExoDataCache;
import org.exoplatform.portal.mop.description.SimpleDataCache;
import org.exoplatform.portal.mop.i18n.I18NAdapter;
import org.exoplatform.portal.pom.config.POMSession;
import org.exoplatform.portal.pom.config.POMSessionManager;
import org.exoplatform.services.cache.CacheService;
import org.gatein.mop.api.workspace.WorkspaceObject;

public class DescriptionServiceImpl
implements DescriptionService {
    private final POMSessionManager manager;
    private DataCache cache;

    public DescriptionServiceImpl(POMSessionManager manager) {
        this(manager, new SimpleDataCache());
    }

    public DescriptionServiceImpl(POMSessionManager manager, DataCache cache) {
        this.manager = manager;
        this.cache = cache;
    }

    public DescriptionServiceImpl(POMSessionManager manager, CacheService cacheService) {
        this(manager, new ExoDataCache(cacheService));
    }

    @Override
    public Described.State resolveDescription(String id, Locale locale) throws NullPointerException {
        return this.resolveDescription(id, null, locale);
    }

    @Override
    public Described.State resolveDescription(String id, Locale locale2, Locale locale1) throws NullPointerException {
        if (id == null) {
            throw new NullPointerException("No null id accepted");
        }
        if (locale1 == null) {
            throw new NullPointerException("No null locale accepted");
        }
        POMSession session = this.manager.getSession();
        Described.State state = this.resolveDescription(session, id, locale1);
        if (state == null && locale2 != null) {
            state = this.resolveDescription(session, id, locale2);
        }
        return state;
    }

    private Described.State resolveDescription(POMSession session, String id, Locale locale) throws NullPointerException {
        return this.cache.getState(session, new CacheKey(locale, id));
    }

    @Override
    public Described.State getDescription(String id, Locale locale) {
        if (id == null) {
            throw new NullPointerException("No null id accepted");
        }
        if (locale == null) {
            throw new NullPointerException("No null locale accepted");
        }
        POMSession session = this.manager.getSession();
        WorkspaceObject obj = session.findObjectById(id);
        I18NAdapter able = (I18NAdapter)obj.adapt(I18NAdapter.class);
        Described desc = able.getI18NMixin(Described.class, locale, false);
        return desc != null ? desc.getState() : null;
    }

    @Override
    public void setDescription(String id, Locale locale, Described.State description) {
        if (id == null) {
            throw new NullPointerException("No null id accepted");
        }
        if (locale == null) {
            throw new NullPointerException("No null locale accepted");
        }
        POMSession session = this.manager.getSession();
        WorkspaceObject obj = session.findObjectById(id);
        I18NAdapter able = (I18NAdapter)obj.adapt(I18NAdapter.class);
        Described desc = able.getI18NMixin(Described.class, locale, true);
        this.cache.removeState(new CacheKey(locale, id));
        desc.setState(description);
    }

    @Override
    public Described.State getDescription(String id) {
        if (id == null) {
            throw new NullPointerException("No null id accepted");
        }
        POMSession session = this.manager.getSession();
        WorkspaceObject obj = session.findObjectById(id);
        I18NAdapter able = (I18NAdapter)obj.adapt(I18NAdapter.class);
        Described desc = able.getMixin(Described.class, false);
        return desc != null ? desc.getState() : null;
    }

    @Override
    public void setDescription(String id, Described.State description) {
        if (id == null) {
            throw new NullPointerException("No null id accepted");
        }
        POMSession session = this.manager.getSession();
        WorkspaceObject obj = session.findObjectById(id);
        I18NAdapter able = (I18NAdapter)obj.adapt(I18NAdapter.class);
        if (description != null) {
            Described desc = able.getMixin(Described.class, true);
            desc.setState(description);
        } else {
            able.removeMixin(Described.class);
        }
    }

    @Override
    public Map<Locale, Described.State> getDescriptions(String id) {
        if (id == null) {
            throw new NullPointerException("No null id accepted");
        }
        POMSession session = this.manager.getSession();
        WorkspaceObject obj = session.findObjectById(id);
        I18NAdapter able = (I18NAdapter)obj.adapt(I18NAdapter.class);
        Map<Locale, Described> mixins = able.getI18NMixin(Described.class);
        HashMap<Locale, Described.State> names = null;
        if (mixins != null) {
            names = new HashMap<Locale, Described.State>(mixins.size());
            for (Map.Entry<Locale, Described> entry : mixins.entrySet()) {
                names.put(entry.getKey(), entry.getValue().getState());
            }
        }
        return names;
    }

    @Override
    public void setDescriptions(String id, Map<Locale, Described.State> descriptions) {
        if (id == null) {
            throw new NullPointerException("No null id accepted");
        }
        POMSession session = this.manager.getSession();
        WorkspaceObject obj = session.findObjectById(id);
        I18NAdapter able = (I18NAdapter)obj.adapt(I18NAdapter.class);
        Collection<Locale> locales = able.removeI18NMixin(Described.class);
        for (Locale locale : locales) {
            this.cache.removeState(new CacheKey(locale, id));
        }
        if (descriptions != null) {
            for (Map.Entry entry : descriptions.entrySet()) {
                Described described = able.addI18NMixin(Described.class, (Locale)entry.getKey());
                described.setState((Described.State)entry.getValue());
            }
        }
    }
}

