/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.database;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.services.database.HibernateService;
import org.exoplatform.services.database.ObjectQuery;
import org.hibernate.Query;
import org.hibernate.Session;

public class DBObjectPageList
extends PageList<Object> {
    private String findQuery_;
    private String countQuery_;
    private HibernateService service_;
    private Map<String, Object> binding = new HashMap<String, Object>();

    public DBObjectPageList(HibernateService service, Class<?> objectType) throws Exception {
        super(20);
        this.service_ = service;
        this.findQuery_ = "from o in class " + objectType.getName();
        this.countQuery_ = "select count(o) from " + objectType.getName() + " o";
        Session session = this.service_.openSession();
        List l = session.createQuery(this.countQuery_).list();
        Number count = (Number)l.get(0);
        this.setAvailablePage(count.intValue());
    }

    public DBObjectPageList(HibernateService service, ObjectQuery oq) throws Exception {
        super(20);
        this.service_ = service;
        this.findQuery_ = oq.getHibernateQueryWithBinding();
        this.countQuery_ = oq.getHibernateCountQueryWithBinding();
        this.binding = oq.getBindingFields();
        Session session = this.service_.openSession();
        Query countQuery = session.createQuery(this.countQuery_);
        this.bindFields(countQuery);
        List l = countQuery.list();
        Number count = (Number)l.get(0);
        this.setAvailablePage(count.intValue());
    }

    public DBObjectPageList(HibernateService service, int pageSize, String query, String countQuery) throws Exception {
        super(pageSize);
        this.service_ = service;
        this.findQuery_ = query;
        this.countQuery_ = countQuery;
        Session session = this.service_.openSession();
        List l = session.createQuery(this.countQuery_).list();
        Number count = (Number)l.get(0);
        this.setAvailablePage(count.intValue());
    }

    protected void populateCurrentPage(int page) throws Exception {
        Session session = this.service_.openSession();
        Query query = session.createQuery(this.findQuery_);
        this.bindFields(query);
        int from = this.getFrom();
        query.setFirstResult(from);
        query.setMaxResults(this.getTo() - from);
        this.currentListPage_ = query.list();
    }

    public List getAll() throws Exception {
        Session session = this.service_.openSession();
        Query query = session.createQuery(this.findQuery_);
        this.bindFields(query);
        return query.list();
    }

    private void bindFields(Query query) {
        for (Map.Entry<String, Object> entry : this.binding.entrySet()) {
            query.setParameter(entry.getKey(), entry.getValue());
        }
    }
}

