/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.nodetype.registration;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.TreeNodeStream;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeData;
import org.exoplatform.services.jcr.impl.core.NamespaceRegistryImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.CNDLexer;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.CNDParser;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.CNDWalker;

public class CNDStreamReader {
    private NamespaceRegistryImpl namespaceRegistry;

    public CNDStreamReader(NamespaceRegistryImpl namespaceRegistry) {
        this.namespaceRegistry = namespaceRegistry;
    }

    public List<NodeTypeData> read(InputStream is) throws RepositoryException {
        try {
            if (is != null) {
                CNDLexer lex = new CNDLexer((CharStream)new ANTLRInputStream(is));
                CommonTokenStream tokens = new CommonTokenStream((TokenSource)lex);
                CNDParser parser = new CNDParser((TokenStream)tokens);
                if (lex.hasError()) {
                    throw new RepositoryException("Lexer errors found " + lex.getErrors().toString());
                }
                CNDParser.cnd_return r = parser.cnd();
                if (parser.hasError()) {
                    throw new RepositoryException("Parser errors found " + parser.getErrors().toString());
                }
                CommonTreeNodeStream nodes = new CommonTreeNodeStream(r.getTree());
                CNDWalker walker = new CNDWalker((TreeNodeStream)nodes);
                walker.cnd(this.namespaceRegistry);
                return walker.getNodeTypes();
            }
            return new ArrayList<NodeTypeData>();
        }
        catch (IOException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (RecognitionException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
    }
}

