/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.importer;

import java.util.HashMap;
import java.util.List;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.importer.ImportMode;
import org.exoplatform.portal.mop.management.operations.page.PageUtils;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageService;
import org.exoplatform.portal.mop.page.PageServiceWrapper;
import org.exoplatform.portal.mop.page.PageState;

public class PageImporter {
    private final SiteKey siteKey;
    private final List<Page> list;
    private final DataStorage service;
    private final PageService pageService;
    private final ImportMode mode;

    public PageImporter(ImportMode importMode, SiteKey siteKey, List<Page> list, DataStorage dataStorage_, PageService pageService) {
        this.siteKey = siteKey;
        this.mode = importMode;
        this.list = list;
        this.service = dataStorage_;
        this.pageService = pageService;
    }

    public void perform() throws Exception {
        HashMap<String, Page> hashPageList = new HashMap<String, Page>();
        for (Page page : this.list) {
            hashPageList.put(page.getPageId(), page);
        }
        if (this.mode == ImportMode.OVERWRITE && !this.siteKey.getType().equals((Object)SiteType.USER)) {
            List<PageContext> allPages = ((PageServiceWrapper)this.pageService).loadPages(this.siteKey);
            for (PageContext currentPage : allPages) {
                String currentPageId = currentPage.getKey().format();
                if (hashPageList.containsKey(currentPageId)) continue;
                this.pageService.destroyPage(currentPage.getKey());
            }
        }
        for (Page page : this.list) {
            Page dst;
            PageContext existingPage = this.pageService.loadPage(page.getPageKey());
            switch (this.mode) {
                case CONSERVE: {
                    dst = null;
                    break;
                }
                case INSERT: {
                    if (existingPage == null) {
                        dst = page;
                        break;
                    }
                    dst = null;
                    break;
                }
                case MERGE: 
                case OVERWRITE: {
                    dst = page;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (dst == null) continue;
            PageState dstState = PageUtils.toPageState(dst);
            this.pageService.savePage(new PageContext(page.getPageKey(), dstState));
            this.service.save(dst);
        }
    }
}

