/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.tree.list;

import java.util.ListIterator;
import java.util.NoSuchElementException;

public class ListTree<T extends ListTree<T>> {
    private T parent;
    private T next = null;
    private T previous = null;
    private T head = null;
    private T tail = null;
    private int size = 0;

    public final int getDepth() {
        int depth = 0;
        T current = this.parent;
        while (current != null) {
            ++depth;
            current = ((ListTree)current).parent;
        }
        return depth;
    }

    public final T getNext() {
        return this.next;
    }

    public final T getPrevious() {
        return this.previous;
    }

    public final T getParent() {
        return this.parent;
    }

    public final int getSize() {
        return this.size;
    }

    public final T getFirst() {
        return this.head;
    }

    public final T getLast() {
        return this.tail;
    }

    public final T get(int index) throws IndexOutOfBoundsException {
        if (index < 0) {
            throw new IndexOutOfBoundsException("No negative index allowed");
        }
        T current = this.head;
        while (true) {
            if (current == null) {
                throw new IndexOutOfBoundsException("index " + index + " is greater than the children size");
            }
            if (index == 0) break;
            current = ((ListTree)current).next;
            --index;
        }
        return current;
    }

    public final void insertAt(Integer index, T tree) throws NullPointerException, IllegalArgumentException, IndexOutOfBoundsException {
        if (tree == null) {
            throw new NullPointerException("No null tree accepted");
        }
        if (index != null && index < 0) {
            throw new IndexOutOfBoundsException("No negative index permitted");
        }
        if (index != null) {
            T a = this.head;
            if (index == 0) {
                this.insertFirst(tree);
            } else {
                while (index > 0) {
                    if (a == null) {
                        throw new IndexOutOfBoundsException();
                    }
                    Integer n = index;
                    Integer n2 = index = Integer.valueOf(index - 1);
                    a = ((ListTree)a).next;
                }
                if (a == null) {
                    this.insertLast(tree);
                } else if (a != tree) {
                    ((ListTree)a).insertBefore(tree);
                }
            }
        } else {
            T a = this.tail;
            if (a == null) {
                this.insertFirst(tree);
            } else if (a != tree) {
                ((ListTree)a).insertAfter(tree);
            }
        }
    }

    public final void insertLast(T tree) {
        if (this.tail == null) {
            this.insertFirst(tree);
        } else {
            ((ListTree)this.tail).insertAfter(tree);
        }
    }

    public void insertFirst(T tree) throws NullPointerException {
        if (tree == null) {
            throw new NullPointerException();
        }
        if (this.head == null) {
            this.beforeInsert(tree);
            if (((ListTree)tree).parent != null) {
                ((ListTree)tree).remove();
            }
            this.tail = tree;
            this.head = this.tail;
            ((ListTree)tree).parent = this;
            ++this.size;
            this.afterInsert(tree);
        } else {
            ((ListTree)this.head).insertBefore(tree);
        }
    }

    public final void insertAfter(T tree) {
        if (tree == null) {
            throw new NullPointerException("No null tree argument accepted");
        }
        if (this.parent == null) {
            throw new IllegalStateException();
        }
        if (this != tree) {
            ((ListTree)this.parent).beforeInsert(tree);
            if (((ListTree)tree).parent != null) {
                ((ListTree)tree).remove();
            }
            ((ListTree)tree).previous = this;
            ((ListTree)tree).next = this.next;
            if (this.next == null) {
                ((ListTree)this.parent).tail = tree;
            } else {
                ((ListTree)this.next).previous = tree;
            }
            this.next = tree;
            ((ListTree)tree).parent = this.parent;
            ++((ListTree)this.parent).size;
            ((ListTree)this.parent).afterInsert(tree);
        }
    }

    public final void insertBefore(T tree) throws NullPointerException, IllegalStateException {
        if (tree == null) {
            throw new NullPointerException("No null tree argument accepted");
        }
        if (this.parent == null) {
            throw new IllegalStateException();
        }
        if (this != tree) {
            ((ListTree)this.parent).beforeInsert(tree);
            if (((ListTree)tree).parent != null) {
                ((ListTree)tree).remove();
            }
            ((ListTree)tree).previous = this.previous;
            ((ListTree)tree).next = this;
            if (this.previous == null) {
                ((ListTree)this.parent).head = tree;
            } else {
                ((ListTree)this.previous).next = tree;
            }
            this.previous = tree;
            ((ListTree)tree).parent = this.parent;
            ++((ListTree)this.parent).size;
            ((ListTree)this.parent).afterInsert(tree);
        }
    }

    public final void remove() throws IllegalStateException {
        if (this.parent == null) {
            throw new IllegalStateException();
        }
        this.parent.beforeRemove((ListTree)this);
        if (this.previous == null) {
            ((ListTree)this.parent).head = this.next;
        } else {
            ((ListTree)this.previous).next = this.next;
        }
        if (this.next == null) {
            ((ListTree)this.parent).tail = this.previous;
        } else {
            ((ListTree)this.next).previous = this.previous;
        }
        ListTree _parent = this.parent;
        this.parent = null;
        this.previous = null;
        this.next = null;
        --_parent.size;
        _parent.afterRemove((ListTree)this);
    }

    public final ListIterator<T> listIterator() {
        return new ListIterator<T>(){
            T next;
            T current;
            T previous;
            int index;
            {
                this.next = ListTree.this.head;
                this.current = null;
                this.previous = null;
                this.index = 0;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public T next() {
                if (this.next != null) {
                    this.current = this.next;
                    this.previous = this.next;
                    this.next = ((ListTree)this.next).next;
                    ++this.index;
                    return this.current;
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasPrevious() {
                return this.previous != null;
            }

            @Override
            public T previous() {
                if (this.previous != null) {
                    this.current = this.previous;
                    this.next = this.previous;
                    this.previous = ((ListTree)this.previous).previous;
                    --this.index;
                    return this.current;
                }
                throw new NoSuchElementException();
            }

            @Override
            public int nextIndex() {
                return this.index;
            }

            @Override
            public int previousIndex() {
                return this.index - 1;
            }

            @Override
            public void remove() {
                if (this.current == null) {
                    throw new IllegalStateException("no element to remove");
                }
                if (this.current == this.previous) {
                    --this.index;
                }
                this.next = ((ListTree)this.current).next;
                this.previous = ((ListTree)this.current).previous;
                ((ListTree)this.current).remove();
                this.current = null;
            }

            @Override
            public void set(T tree) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(T tree) {
                if (this.previous == null) {
                    ListTree.this.insertFirst(tree);
                } else {
                    ((ListTree)this.previous).insertAfter(tree);
                }
                ++this.index;
                this.previous = tree;
                this.next = ((ListTree)tree).next;
            }
        };
    }

    protected void beforeInsert(T tree) {
    }

    protected void afterInsert(T tree) {
    }

    protected void beforeRemove(T tree) {
    }

    protected void afterRemove(T tree) {
    }
}

