/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.impl;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.ItemExistsException;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarImportExport;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.EventCategory;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.service.impl.JCRDataStorage;
import org.exoplatform.calendar.util.Constants;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CsvImportExport
implements CalendarImportExport {
    public static final String CSV_PATTERN = "\"([^\"]+?)\",?|([^,]+),?|,";
    private static Pattern csvRE = Pattern.compile("\"([^\"]+?)\",?|([^,]+),?|,");
    public static String EV_SUMMARY = "Subject".intern();
    public static String EV_STARTDATE = "Start Date".intern();
    public static String EV_STARTTIME = "Start Time".intern();
    public static String EV_ENDDATE = "End Date".intern();
    public static String EV_ENDTIME = "End Time".intern();
    public static String EV_ALLDAY = "All day event".intern();
    public static String EV_HASREMINDER = "Reminder on/off".intern();
    public static String EV_REMINDERDATE = "Reminder Date".intern();
    public static String EV_REMINDERTIME = "Reminder Time".intern();
    public static String EV_MEETINGORGANIZER = "Meeting Organizer".intern();
    public static String EV_ATTENDEES = "Required Attendees".intern();
    public static String EV_INVITATION = "Optional Attendees".intern();
    public static String EV_ATTACTMENT = "Meeting Resources".intern();
    public static String EV_BILLINGINFO = "Billing Information".intern();
    public static String EV_CATEGORIES = "Categories".intern();
    public static String EV_DESCRIPTION = "Description".intern();
    public static String EV_LOCATION = "Location".intern();
    public static String EV_MILEAGE = "Mileage".intern();
    public static String EV_PRIORITY = "Priority".intern();
    public static String EV_PRIVATE = "Private".intern();
    public static String EV_SENSITIVITY = "Sensitivity".intern();
    public static String EV_STATUS = "Show time as".intern();
    private static final String PRIVATE_TYPE = "0".intern();
    private JCRDataStorage storage_;
    private static final Log logger = ExoLogger.getLogger(CsvImportExport.class);
    private List<String> headers;

    public CsvImportExport(JCRDataStorage dataStore) {
        this.storage_ = dataStore;
    }

    public List<CalendarEvent> process(BufferedReader in) throws Exception {
        String line;
        int lineCount = 0;
        ArrayList<CalendarEvent> eventList = new ArrayList<CalendarEvent>();
        while ((line = in.readLine()) != null) {
            String tempLine = line;
            if (!line.endsWith("\"")) {
                line = tempLine + in.readLine();
            }
            if (lineCount == 0) {
                this.headers = this.parse(line);
            } else {
                CalendarEvent eventObj = this.getEventFromLine(line);
                if (eventObj != null) {
                    eventList.add(eventObj);
                }
            }
            ++lineCount;
        }
        return eventList;
    }

    private CalendarEvent getEventFromLine(String line) {
        CalendarEvent eventObj = new CalendarEvent();
        eventObj.setEventType(CalendarEvent.TYPE_EVENT);
        eventObj.setCalType(PRIVATE_TYPE);
        List<String> values = this.parse(line);
        Date fromDate = this.getFromDate(values);
        Date toDate = this.getToDate(values);
        if (fromDate != null && toDate != null) {
            eventObj.setFromDateTime(this.getFromDate(values));
            eventObj.setToDateTime(this.getToDate(values));
            block0: for (int i = 0; i < values.size(); ++i) {
                String key = this.headers.get(i);
                if (EV_SUMMARY.equals(key)) {
                    eventObj.setSummary(values.get(i));
                    continue;
                }
                if (EV_LOCATION.equals(key)) {
                    eventObj.setLocation(values.get(i));
                    continue;
                }
                if (EV_DESCRIPTION.equals(key)) {
                    eventObj.setDescription(values.get(i));
                    continue;
                }
                if (EV_STATUS.equals(key)) {
                    int st = Integer.valueOf(values.get(i));
                    if (st == 0 || st == 1) {
                        eventObj.setStatus(CalendarEvent.ST_AVAILABLE);
                        continue;
                    }
                    if (st == 2) {
                        eventObj.setStatus(CalendarEvent.ST_BUSY);
                        continue;
                    }
                    if (st != 3) continue;
                    eventObj.setStatus(CalendarEvent.ST_OUTSIDE);
                    continue;
                }
                if (EV_PRIORITY.equals(key)) {
                    for (int j = 0; j < CalendarEvent.PRIORITY.length; ++j) {
                        if (!CalendarEvent.PRIORITY[i].equalsIgnoreCase(values.get(i).toLowerCase())) continue;
                        eventObj.setPriority(String.valueOf(j));
                        continue block0;
                    }
                    continue;
                }
                if (EV_CATEGORIES.equals(key)) {
                    eventObj.setEventCategoryName(values.get(i));
                    continue;
                }
                if (EV_ATTENDEES.equals(key)) {
                    if (values.get(i) == null) continue;
                    eventObj.setParticipant(values.get(i).split(";"));
                    continue;
                }
                if (!EV_INVITATION.equals(key) || values.get(i) == null) continue;
                eventObj.setInvitation(values.get(i).split(";"));
            }
            return eventObj;
        }
        return null;
    }

    public List<String> parse(String line) {
        String match;
        ArrayList<String> list = new ArrayList<String>();
        Matcher m = csvRE.matcher(line);
        while (m.find() && (match = m.group()) != null) {
            if (match.equals(",")) {
                match = null;
            } else {
                if (match.endsWith(",")) {
                    match = match.substring(0, match.length() - 1);
                }
                if (match.startsWith("\"")) {
                    match = match.substring(1);
                }
                if (match.endsWith("\"")) {
                    match = match.substring(0, match.length() - 1);
                }
            }
            list.add(match);
        }
        return list;
    }

    public OutputStream exportCalendar(String username, List<String> calendarIds, String type) throws Exception {
        return null;
    }

    @Override
    public List<CalendarEvent> getEventObjects(InputStream inputStream) throws Exception {
        return null;
    }

    @Override
    public void importCalendar(String username, InputStream inputStream, String calendarId, String calendarName, java.util.Calendar from, java.util.Calendar to, boolean isNew) throws Exception {
        List<CalendarEvent> data = this.process(new BufferedReader(new InputStreamReader(inputStream)));
        if (data == null || data.size() < 1) {
            return;
        }
        CalendarService calService = (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarService.class);
        if (isNew) {
            Calendar exoCalendar = new Calendar();
            exoCalendar.setName(calendarName);
            exoCalendar.setCalendarColor(Constants.COLORS[0]);
            exoCalendar.setDescription("");
            exoCalendar.setPublic(true);
            exoCalendar.setCalendarOwner(username);
            this.storage_.saveUserCalendar(username, exoCalendar, true);
            calendarId = exoCalendar.getId();
        }
        for (CalendarEvent exoEvent : data) {
            if (!Utils.isEmpty(exoEvent.getEventCategoryName())) {
                EventCategory evCate;
                block7: {
                    evCate = new EventCategory();
                    evCate.setName(exoEvent.getEventCategoryName());
                    try {
                        calService.saveEventCategory(username, evCate, true);
                    }
                    catch (ItemExistsException e) {
                        evCate = calService.getEventCategoryByName(username, evCate.getName());
                    }
                    catch (Exception e) {
                        if (!logger.isDebugEnabled()) break block7;
                        logger.debug((Object)("Exception occurs when saving new event category '" + evCate.getName() + "' for event: " + exoEvent.getId()), (Throwable)e);
                    }
                }
                exoEvent.setEventCategoryId(evCate.getId());
                exoEvent.setEventCategoryName(evCate.getName());
            }
            exoEvent.setCalendarId(calendarId);
            this.storage_.saveUserEvent(username, calendarId, exoEvent, true);
        }
    }

    @Override
    public boolean isValidate(InputStream icalInputStream) throws Exception {
        try {
            List<CalendarEvent> eventObjs = this.process(new BufferedReader(new InputStreamReader(icalInputStream)));
            return eventObjs.size() > 0;
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"The inputStream is not valid", (Throwable)e);
            }
            return false;
        }
    }

    @Override
    public OutputStream exportCalendar(String username, List<String> calendarIds, String type, int number) throws Exception {
        return null;
    }

    @Override
    public OutputStream exportEventCalendar(String username, String calendarId, String type, String eventId) throws Exception {
        return null;
    }

    @Override
    public ByteArrayOutputStream exportEventCalendar(CalendarEvent event) throws Exception {
        return null;
    }

    private Date getFromDate(List<String> values) {
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yy hh:mm:ss a", Locale.ENGLISH);
        java.util.Calendar cal = java.util.Calendar.getInstance();
        Date date = null;
        try {
            String dateStr = this.getValue(values, EV_STARTDATE);
            String allDay = this.getValue(values, EV_ALLDAY);
            if ("True".equals(allDay)) {
                date = df.parse(dateStr + "0:00:00 AM");
                cal.set(14, 0);
                return cal.getTime();
            }
            date = df.parse(this.getValue(values, EV_STARTDATE) + " " + this.getValue(values, EV_STARTTIME));
            return date;
        }
        catch (ParseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"can't parse the date", (Throwable)e);
            }
            return null;
        }
    }

    private Date getToDate(List<String> values) {
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yy hh:mm:ss a", Locale.ENGLISH);
        java.util.Calendar cal = java.util.Calendar.getInstance();
        try {
            String dateStr = this.getValue(values, EV_ENDDATE);
            String allDay = this.getValue(values, EV_ALLDAY);
            if (dateStr == null) {
                return this.getFromDate(values);
            }
            if ("True".equals(allDay)) {
                Date date = df.parse(dateStr + "23:59:59 PM");
                cal.set(14, 999);
                return cal.getTime();
            }
            Date date = df.parse(this.getValue(values, EV_ENDDATE) + " " + this.getValue(values, EV_ENDTIME));
            return date;
        }
        catch (ParseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"can't parse the date", (Throwable)e);
            }
            return null;
        }
    }

    private String getValue(List<String> values, String field) {
        int i = this.headers.indexOf(field);
        if (i > -1) {
            return values.get(i);
        }
        return null;
    }
}

