/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.impl;

import java.util.LinkedList;
import javax.jcr.NodeIterator;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.service.impl.AbstractEventListAccess;
import org.exoplatform.calendar.service.impl.EventDAOImpl;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.query.lucene.QueryResultImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class EventListAccess
extends AbstractEventListAccess<CalendarEvent> {
    private static Log log = ExoLogger.getLogger(EventListAccess.class);
    private EventDAOImpl evtDAO;

    public EventListAccess(EventDAOImpl evtDAO, EventQuery eventQuery) {
        super(evtDAO, eventQuery);
        this.evtDAO = evtDAO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CalendarEvent[] load(int offset, int limit) {
        try (SessionProvider provider = SessionProvider.createSystemProvider();){
            QueryResultImpl queryResult = super.loadData(provider, offset, limit);
            if (queryResult != null) {
                NodeIterator nodes = queryResult.getNodes();
                LinkedList<CalendarEvent> results = new LinkedList<CalendarEvent>();
                while (nodes.hasNext()) {
                    results.add(this.evtDAO.storage.getEvent(nodes.nextNode()));
                }
                CalendarEvent[] calendarEventArray = results.toArray(new CalendarEvent[results.size()]);
                return calendarEventArray;
            }
        }
        return null;
    }
}

