/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.cdi.contexts;

import java.io.Serializable;
import java.util.LinkedList;

public class PortletRequestLifecycle
implements Serializable {
    private final LinkedList<State> states = new LinkedList();

    public State last() {
        return this.states.peekLast();
    }

    public State first() {
        return this.states.peekFirst();
    }

    public State addNext(State next) {
        State previous = this.last();
        this.states.add(next);
        return previous;
    }

    public int size() {
        return this.states.size();
    }

    public static class State
    implements Serializable {
        private static final int START = 0;
        private static final int END = 1;
        private final String phase;
        private final int flag;

        public static State starting(String phase) {
            return new State(phase, 0);
        }

        public static State ending(String phase) {
            return new State(phase, 1);
        }

        private State(String phase, int flag) {
            if (phase == null) {
                throw new NullPointerException("phase cannot be null");
            }
            this.phase = phase;
            this.flag = flag;
        }

        public String getPhase() {
            return this.phase;
        }

        public boolean isPhase(String ... phases) {
            if (phases == null) {
                return false;
            }
            for (String phase : phases) {
                if (!this.phase.equals(phase)) continue;
                return true;
            }
            return false;
        }

        public boolean started() {
            return this.flag == 0;
        }

        public boolean ended() {
            return this.flag == 1;
        }
    }
}

