/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.Body;
import com.github.sommeri.less4j.core.ast.ComposedExpression;
import com.github.sommeri.less4j.core.ast.Declaration;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.ExpressionOperator;
import com.github.sommeri.less4j.core.ast.RuleSet;
import com.github.sommeri.less4j.core.compiler.stages.ASTManipulator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PropertiesMerger {
    private Map<String, Declaration> mergingProperties = new HashMap<String, Declaration>();
    private ASTManipulator manipulator = new ASTManipulator();

    public void propertiesMerger(ASTCssNode node) {
        switch (node.getType()) {
            case RULE_SET: {
                RuleSet ruleset = (RuleSet)node;
                this.rulesetsBodyPropertiesMerger(ruleset.getBody());
                break;
            }
            case CHARSET_DECLARATION: 
            case IMPORT: {
                break;
            }
            default: {
                this.mergeKidsProperties(node);
            }
        }
    }

    private void mergeKidsProperties(ASTCssNode node) {
        ArrayList<? extends ASTCssNode> childs = new ArrayList<ASTCssNode>(node.getChilds());
        for (ASTCssNode aSTCssNode : childs) {
            this.propertiesMerger(aSTCssNode);
        }
    }

    private void rulesetsBodyPropertiesMerger(Body node) {
        this.enteringBody(node);
        List<ASTCssNode> childs = node.getChilds();
        block3: for (ASTCssNode kid : childs) {
            switch (kid.getType()) {
                case DECLARATION: {
                    Declaration declaration = (Declaration)kid;
                    if (!declaration.isMerging()) continue block3;
                    this.addToPrevious(declaration);
                    continue block3;
                }
            }
            this.mergeKidsProperties(kid);
        }
    }

    private void addToPrevious(Declaration declaration) {
        if (declaration.getExpression() == null) {
            return;
        }
        String key = this.toMergingPropertiesKey(declaration);
        if (this.mergingProperties.containsKey(key)) {
            Declaration previousDeclaration = this.mergingProperties.get(key);
            Expression previousExpression = previousDeclaration.getExpression();
            ComposedExpression composedExpression = new ComposedExpression(declaration.getUnderlyingStructure(), previousExpression, new ExpressionOperator(declaration.getUnderlyingStructure(), declaration.getMergeOperator()), declaration.getExpression());
            previousDeclaration.setExpression(composedExpression);
            composedExpression.setParent(previousDeclaration);
            this.manipulator.removeFromBody(declaration);
        } else {
            this.mergingProperties.put(key, declaration);
        }
    }

    private String toMergingPropertiesKey(Declaration declaration) {
        String cssPropertyName = declaration.getNameAsString();
        boolean important = declaration.isImportant();
        return cssPropertyName + " " + important;
    }

    private void enteringBody(Body node) {
        this.mergingProperties = new HashMap<String, Declaration>();
    }
}

