/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.lifecycle;

import java.util.ArrayList;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.lifecycle.AbstractNotificationLifecycle;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.service.QueueMessage;
import org.exoplatform.commons.api.notification.service.setting.UserSettingService;
import org.exoplatform.commons.api.notification.service.storage.MailNotificationStorage;
import org.exoplatform.commons.notification.NotificationContextFactory;
import org.exoplatform.commons.notification.NotificationUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class MailLifecycle
extends AbstractNotificationLifecycle {
    private static final Log LOG = ExoLogger.getLogger(MailLifecycle.class);
    private NotificationContextFactory notificationContextFactory = CommonsUtils.getService(NotificationContextFactory.class);

    public void process(NotificationContext ctx, String ... userIds) {
        NotificationInfo notification = ctx.getNotificationInfo();
        String pluginId = notification.getKey().getId();
        UserSettingService userService = CommonsUtils.getService(UserSettingService.class);
        ArrayList<String> userIdPendings = new ArrayList<String>();
        for (String userId : userIds) {
            UserSetting userSetting = userService.get(userId);
            if (!userSetting.isEnabled() || !userSetting.isChannelActive("MAIL_CHANNEL")) continue;
            if (userSetting.isActive("MAIL_CHANNEL", pluginId)) {
                this.send(ctx.setNotificationInfo(notification.clone().setTo(userId)));
            }
            if (!userSetting.isInDaily(pluginId) && !userSetting.isInWeekly(pluginId)) continue;
            userIdPendings.add(userId);
            this.setValueSendbyFrequency(notification, userSetting, userId);
        }
        if (userIdPendings.size() > 0 || notification.isSendAll()) {
            this.store(notification);
        }
    }

    private void setValueSendbyFrequency(NotificationInfo msg, UserSetting userSetting, String userId) {
        if (msg.isSendAll()) {
            return;
        }
        String pluginId = msg.getKey().getId();
        if (userSetting.isInDaily(pluginId)) {
            msg.setSendToDaily(userId);
        }
        if (userSetting.isInWeekly(pluginId)) {
            msg.setSendToWeekly(userId);
        }
    }

    public void process(NotificationContext ctx, String userId) {
        LOG.info((Object)("Mail Notification process user: " + userId));
    }

    public void store(NotificationInfo notifInfo) {
        MailNotificationStorage storage = CommonsUtils.getService(MailNotificationStorage.class);
        try {
            storage.save(notifInfo);
        }
        catch (Exception e) {
            LOG.error((Object)"Error storing notification", (Throwable)e);
        }
    }

    public void send(NotificationContext ctx) {
        MessageInfo msg;
        boolean stats = this.notificationContextFactory.getStatistics().isStatisticsEnabled();
        NotificationInfo notification = ctx.getNotificationInfo();
        AbstractTemplateBuilder builder = this.getChannel().getTemplateBuilder(notification.getKey());
        if (builder != null && (msg = builder.buildMessage(ctx)) != null) {
            if (NotificationUtils.isValidEmailAddresses(msg.getTo())) {
                try {
                    CommonsUtils.getService(QueueMessage.class).sendMessage(msg);
                }
                catch (Exception e) {
                    LOG.error((Object)("error in sending message with id = " + msg.getId()), (Throwable)e);
                }
            } else {
                LOG.warn((Object)String.format("The email %s is not valid for sending notification", msg.getTo()));
            }
            if (stats) {
                this.notificationContextFactory.getStatisticsCollector().createMessageInfoCount(msg.getPluginId());
            }
        }
    }
}

