/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.management.annotations.ManagedBy;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageService;
import org.exoplatform.portal.mop.page.PageState;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.space.SpacesAdministrationService;
import org.exoplatform.social.core.space.impl.SpacesAdministrationServiceManagerBean;
import org.picocontainer.Startable;

@ManagedBy(value=SpacesAdministrationServiceManagerBean.class)
public class SpacesAdministrationServiceImpl
implements Startable,
SpacesAdministrationService {
    private static final Log LOG = ExoLogger.getLogger(SpacesAdministrationServiceImpl.class);
    private static final String SPACES_ADMINISTRATORS_PARAM = "social.spaces.administrators";
    private static final String SPACES_CREATORS_PARAM = "social.spaces.creators";
    private static final String SPACES_ADMINISTRATORS_SETTING_KEY = "social.spaces.administrators";
    private static final String SPACES_CREATORS_SETTING_KEY = "social.spaces.creators";
    public static final String SPACES_ADMINISTRATION_PAGE_KEY = "group::/platform/users::spacesAdministration";
    private SettingService settingService;
    private IdentityRegistry identityRegistry;
    private OrganizationService organizationService;
    private UserACL userACL;
    private List<MembershipEntry> spacesAdministratorsMemberships = new ArrayList<MembershipEntry>();
    private List<MembershipEntry> spaceCreatorsMemberships = new ArrayList<MembershipEntry>();

    public SpacesAdministrationServiceImpl(InitParams initParams, SettingService settingService, IdentityRegistry identityRegistry, OrganizationService organizationService, UserACL userACL) {
        this.settingService = settingService;
        this.identityRegistry = identityRegistry;
        this.organizationService = organizationService;
        this.userACL = userACL;
        this.loadSettings(initParams);
    }

    public void start() {
        PortalContainer.addInitTask((ServletContext)PortalContainer.getInstance().getPortalContext(), (RootContainer.PortalContainerInitTask)new RootContainer.PortalContainerPostInitTask(){

            public void execute(ServletContext context, PortalContainer portalContainer) {
                List<MembershipEntry> superManagersMemberships = SpacesAdministrationServiceImpl.this.getSpacesAdministratorsMemberships();
                SpacesAdministrationServiceImpl.this.updateSpacesAdministrationPagePermissions(superManagersMemberships);
            }
        });
    }

    public void stop() {
    }

    @Override
    public void updateSpacesAdministratorsMemberships(List<MembershipEntry> permissionsExpressions) {
        if (permissionsExpressions == null) {
            throw new IllegalArgumentException("Permission expressions list couldn't be null");
        }
        this.spacesAdministratorsMemberships = permissionsExpressions;
        this.settingService.set(Context.GLOBAL, Scope.GLOBAL, "social.spaces.administrators", SettingValue.create((String)StringUtils.join(this.spacesAdministratorsMemberships, (String)",")));
        this.updateSpacesAdministrationPagePermissions(this.spacesAdministratorsMemberships);
    }

    @Override
    public List<MembershipEntry> getSpacesAdministratorsMemberships() {
        return Collections.unmodifiableList(this.spacesAdministratorsMemberships);
    }

    @Override
    public List<MembershipEntry> getSpacesCreatorsMemberships() {
        return Collections.unmodifiableList(this.spaceCreatorsMemberships);
    }

    @Override
    public void updateSpacesCreatorsMemberships(List<MembershipEntry> permissionsExpressions) {
        if (permissionsExpressions == null) {
            throw new IllegalArgumentException("Permission expressions list couldn't be null");
        }
        this.spaceCreatorsMemberships = permissionsExpressions;
        this.settingService.set(Context.GLOBAL, Scope.GLOBAL, "social.spaces.creators", SettingValue.create((String)StringUtils.join(this.spaceCreatorsMemberships, (String)",")));
        this.updateSpacesAdministrationPagePermissions(this.spaceCreatorsMemberships);
    }

    protected void loadSettings(InitParams initParams) {
        String spacesCreatorsMemberships;
        ValueParam spacesCreatorsParam;
        String spacesAdministratorsMemberships;
        ValueParam spacesAdministratorsParam;
        SettingValue administrators = this.settingService.get(Context.GLOBAL, Scope.GLOBAL, "social.spaces.administrators");
        if (administrators != null && !StringUtils.isBlank((CharSequence)((CharSequence)administrators.getValue()))) {
            String[] administratorsArray = ((String)administrators.getValue()).split(",");
            this.addSpacesAdministratorsMemberships(administratorsArray);
        } else if (initParams != null && (spacesAdministratorsParam = initParams.getValueParam("social.spaces.administrators")) != null && StringUtils.isNotBlank((CharSequence)(spacesAdministratorsMemberships = spacesAdministratorsParam.getValue()))) {
            String[] spacesAdministratorsMembershipsArray = spacesAdministratorsMemberships.split(",");
            this.addSpacesAdministratorsMemberships(spacesAdministratorsMembershipsArray);
        }
        SettingValue creators = this.settingService.get(Context.GLOBAL, Scope.GLOBAL, "social.spaces.creators");
        if (creators != null && !StringUtils.isBlank((CharSequence)((CharSequence)creators.getValue()))) {
            String[] creatorsArray = ((String)creators.getValue()).split(",");
            this.addSpacesCreatorsMemberships(creatorsArray);
        } else if (initParams != null && (spacesCreatorsParam = initParams.getValueParam("social.spaces.creators")) != null && StringUtils.isNotBlank((CharSequence)(spacesCreatorsMemberships = spacesCreatorsParam.getValue()))) {
            String[] spacesCreatorsMembershipsArray = spacesCreatorsMemberships.split(",");
            this.addSpacesCreatorsMemberships(spacesCreatorsMembershipsArray);
        }
    }

    private void addSpacesCreatorsMemberships(String[] creatorsArray) {
        for (String creatorArray : creatorsArray) {
            if (StringUtils.isBlank((CharSequence)creatorArray)) continue;
            if (!creatorArray.contains(":/")) {
                this.spaceCreatorsMemberships.add(new MembershipEntry(creatorArray));
                continue;
            }
            String[] membershipParts = creatorArray.split(":");
            this.spaceCreatorsMemberships.add(new MembershipEntry(membershipParts[1], membershipParts[0]));
        }
    }

    private void addSpacesAdministratorsMemberships(String[] administratorsArray) {
        for (String administrator : administratorsArray) {
            if (StringUtils.isBlank((CharSequence)administrator)) continue;
            if (!administrator.contains(":/")) {
                this.spacesAdministratorsMemberships.add(new MembershipEntry(administrator));
                continue;
            }
            String[] membershipParts = administrator.split(":");
            this.spacesAdministratorsMemberships.add(new MembershipEntry(membershipParts[1], membershipParts[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSpacesAdministrationPagePermissions(List<MembershipEntry> superManagersMemberships) {
        if (superManagersMemberships != null) {
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            try {
                PageService pageService = (PageService)CommonsUtils.getService(PageService.class);
                PageKey pageKey = PageKey.parse((String)SPACES_ADMINISTRATION_PAGE_KEY);
                PageContext pageContext = pageService.loadPage(pageKey);
                if (pageContext != null) {
                    PageState page = pageContext.getState();
                    PageState pageState = new PageState(page.getDisplayName(), page.getDescription(), page.getShowMaxWindow(), page.getFactoryId(), superManagersMemberships.stream().map(membership -> membership.getMembershipType() + ":" + membership.getGroup()).collect(Collectors.toList()), page.getEditPermission(), page.getMoveAppsPermissions(), page.getMoveContainersPermissions());
                    pageService.savePage(new PageContext(pageKey, pageState));
                }
            }
            finally {
                RequestLifeCycle.end();
            }
        }
    }

    @Override
    public boolean canCreateSpace(String userId) {
        List<MembershipEntry> spacesCreatorsMemberships;
        if (StringUtils.isBlank((CharSequence)userId) || IdentityConstants.ANONIM.equals(userId) || IdentityConstants.SYSTEM.equals(userId)) {
            return false;
        }
        if (userId.equals(this.userACL.getSuperUser())) {
            return true;
        }
        Identity identity = this.identityRegistry.getIdentity(userId);
        if (identity == null) {
            Collection memberships;
            try {
                memberships = this.organizationService.getMembershipHandler().findMembershipsByUser(userId);
            }
            catch (Exception e) {
                throw new RuntimeException("Can't get user '" + userId + "' memberships", e);
            }
            ArrayList<MembershipEntry> entries = new ArrayList<MembershipEntry>();
            for (Membership membership : memberships) {
                entries.add(new MembershipEntry(membership.getGroupId(), membership.getMembershipType()));
            }
            identity = new Identity(userId, entries);
        }
        if ((spacesCreatorsMemberships = this.getSpacesCreatorsMemberships()) != null && !spacesCreatorsMemberships.isEmpty()) {
            for (MembershipEntry spacesCreatorMembership : spacesCreatorsMemberships) {
                if ((!spacesCreatorMembership.getMembershipType().equals("*") || !identity.isMemberOf(spacesCreatorMembership.getGroup())) && !identity.isMemberOf(spacesCreatorMembership)) continue;
                return true;
            }
        }
        return false;
    }
}

