/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.RequestNavigationData;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageService;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.router.ExoRouter;
import org.exoplatform.social.core.model.BannerAttachment;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceTemplate;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.space.spi.SpaceTemplateService;
import org.exoplatform.social.webui.UIBannerAvatarUploader;
import org.exoplatform.social.webui.UIBannerUploader;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="war:/groovy/social/webui/space/UISpaceMenu.gtmpl", events={@EventConfig(listeners={RemoveBannerActionListener.class}), @EventConfig(name="RenameSpaceAppName", listeners={RenameSpaceAppNameActionListener.class})})
public class UISpaceMenu
extends UIContainer {
    private static final String NEW_SPACE_APPLICATION_NAME = "newSpaceAppName";
    private static final String INVALID_APPLICATION_NAME_MSG = "UISpaceMenuPortlet.msg.invalidAppName";
    private static final String EXISTING_APPLICATION_NAME_MSG = "UISpaceMenuPortlet.msg.existingAppName";
    private static final String SPACE_HOME_APP_NAME = "UISpaceMenu.label.Home";
    private static final String SPACE_SETTINGS = "settings";
    public static final String HIDDEN = "HIDDEN";
    private static final String DEFAULT_APP_ID = "DefaultAppId";
    private static final String APP_NAME = "appName";
    private static final Log LOG = ExoLogger.getLogger(UISpaceMenu.class);
    private SpaceService spaceService = this.getSpaceService();
    private SpaceTemplateService spaceTemplateService = this.getSpaceTemplateService();
    private ConfigurationManager configurationManager = this.getConfigurationManager();
    private Space space = Utils.getSpaceByContext();
    private UIBannerUploader uiBanner = (UIBannerUploader)this.createUIComponent(UIBannerUploader.class, null, null);
    private UIBannerAvatarUploader uiAvatarBanner;

    public UISpaceMenu() throws Exception {
        this.addChild((UIComponent)this.uiBanner);
        this.uiAvatarBanner = (UIBannerAvatarUploader)this.createUIComponent(UIBannerAvatarUploader.class, null, null);
        this.addChild((UIComponent)this.uiAvatarBanner);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        boolean canEditBanner = this.hasSettingPermission();
        this.uiBanner.setRendered(canEditBanner);
        this.uiAvatarBanner.setRenderUpload(canEditBanner);
        String selectedApp = this.getAppSelected();
        UserNode selectedNode = this.getApps().stream().filter(app -> {
            try {
                return app.getName().equals(selectedApp);
            }
            catch (Exception e) {
                return false;
            }
        }).findFirst().orElse(null);
        String selectedNodeLabel = this.getResolvedNodeTitle(selectedNode, context);
        if (selectedNodeLabel != null) {
            Util.getPortalRequestContext().setPageTitle(this.getSpace().getDisplayName() + " - " + selectedNodeLabel);
        }
        super.processRender(context);
    }

    public List<UserNode> getApps() throws Exception {
        if (this.space == null) {
            return new ArrayList<UserNode>(0);
        }
        ArrayList<UserNode> userNodeArraySorted = new ArrayList<UserNode>();
        try {
            UserNodeFilterConfig.Builder filterConfigBuilder = UserNodeFilterConfig.builder();
            filterConfigBuilder.withVisibility(Visibility.DISPLAYED, new Visibility[]{Visibility.TEMPORAL});
            filterConfigBuilder.withTemporalCheck();
            UserNodeFilterConfig filter = filterConfigBuilder.build();
            UserNode spaceUserNode = SpaceUtils.getSpaceUserNode((Space)this.space, (UserNodeFilterConfig)filter);
            UserNode hiddenNode = spaceUserNode.getChild(SPACE_SETTINGS);
            if (!this.hasSettingPermission() && hiddenNode != null) {
                spaceUserNode.removeChild(hiddenNode.getName());
            }
            userNodeArraySorted.addAll(spaceUserNode.getChildren());
            this.removeNonePageNodes(userNodeArraySorted);
        }
        catch (Exception e) {
            LOG.warn((Object)"Get UserNode of Space failed.");
        }
        return userNodeArraySorted;
    }

    protected String getAppIdByAppName(String appName) {
        String[] appInfos;
        for (String appInfo : appInfos = this.space.getApp().split(",")) {
            String[] appInfoParts = appInfo.split(":");
            if (!appInfoParts[0].equals(appName) && !appInfoParts[1].equals(appName)) continue;
            return appInfoParts[0];
        }
        return DEFAULT_APP_ID;
    }

    private void removeSpaceBanner() {
        Space space = this.getSpace();
        String templateName = space.getTemplate();
        SpaceTemplate spaceTemplate = this.spaceTemplateService.getSpaceTemplateByName(templateName);
        String bannerPath = spaceTemplate.getBannerPath();
        if (StringUtils.isNotBlank((String)bannerPath)) {
            try {
                InputStream bannerStream = this.configurationManager.getInputStream(bannerPath);
                if (bannerStream != null) {
                    BannerAttachment bannerAttachment = new BannerAttachment(null, "banner", "png", bannerStream, null, System.currentTimeMillis());
                    space.setBannerAttachment(bannerAttachment);
                }
            }
            catch (Exception e) {
                LOG.warn("No file found for space banner at path {}", new Object[]{bannerPath});
                space.setBannerAttachment(null);
            }
        } else {
            space.setBannerAttachment(null);
        }
        space.setEditor(Utils.getViewerRemoteId());
        this.spaceService.updateSpace(space);
        this.spaceService.updateSpaceBanner(space);
    }

    public String getSpaceName() throws Exception {
        this.space = this.getSpace();
        if (this.space == null) {
            return null;
        }
        return this.space.getDisplayName();
    }

    public String getAppSelected() throws Exception {
        PortalRequestContext plcontext = Util.getPortalRequestContext();
        String requestPath = plcontext.getControllerContext().getParameter(RequestNavigationData.REQUEST_PATH);
        ExoRouter.Route route = ExoRouter.route((String)requestPath);
        if (route == null) {
            return null;
        }
        return (String)route.localArgs.get(APP_NAME);
    }

    public String getResolvedNodeTitle(UserNode selectedNode, WebuiRequestContext context) throws Exception {
        if (selectedNode != null) {
            String labelName = Utils.appRes(selectedNode.getPageRef().getName() + ".label.name");
            return StringUtils.isNotBlank((String)labelName) ? labelName : selectedNode.getName();
        }
        if (context != null) {
            return context.getApplicationResourceBundle().getString("UISpaceMenu.label.SpaceHomePage");
        }
        return null;
    }

    protected String getImageSource() {
        Space space = this.getSpace();
        if (space != null) {
            return space.getAvatarUrl();
        }
        return "";
    }

    protected String getBanner() {
        Space space = this.getSpace();
        if (space != null) {
            return space.getBannerUrl();
        }
        return "";
    }

    protected boolean hasSettingPermission() throws SpaceException {
        this.spaceService = this.getSpaceService();
        String userId = Util.getPortalRequestContext().getRemoteUser();
        Space space = this.getSpace();
        return this.spaceService.hasSettingPermission(space, userId);
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        }
        return this.spaceService;
    }

    private SpaceTemplateService getSpaceTemplateService() {
        if (this.spaceTemplateService == null) {
            this.spaceTemplateService = (SpaceTemplateService)this.getApplicationComponent(SpaceTemplateService.class);
        }
        return this.spaceTemplateService;
    }

    private ConfigurationManager getConfigurationManager() {
        if (this.configurationManager == null) {
            this.configurationManager = (ConfigurationManager)this.getApplicationComponent(ConfigurationManager.class);
        }
        return this.configurationManager;
    }

    private Space getSpace() {
        this.space = Utils.getSpaceByContext();
        return this.space;
    }

    private boolean isAppNameExisted(UserNode homeNode, String nodeName) throws Exception {
        Collection nodes = homeNode.getChildren();
        for (UserNode node : nodes) {
            if (!node.getName().equals(nodeName)) continue;
            return true;
        }
        String spaceHomeAppName = WebuiRequestContext.getCurrentInstance().getApplicationResourceBundle().getString(SPACE_HOME_APP_NAME);
        return nodeName.equals(spaceHomeAppName);
    }

    private boolean isValidAppName(String appName) {
        if ((appName = appName.trim()) == null || appName.length() < 1) {
            return false;
        }
        if (Character.isDigit(appName.charAt(0)) || appName.charAt(0) == '-') {
            return false;
        }
        for (int i = 0; i < appName.length(); ++i) {
            char c = appName.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c) || c == '_' || c == '-' || Character.isSpaceChar(c)) continue;
            return false;
        }
        return true;
    }

    protected Space getSpace(String spaceUrl) {
        return this.getSpaceService().getSpaceByUrl(spaceUrl);
    }

    private void removeNonePageNodes(List<UserNode> nodes) {
        ArrayList<UserNode> nonePageNodes = new ArrayList<UserNode>();
        UserACL userACL = SpaceUtils.getUserACL();
        for (UserNode node : nodes) {
            PageKey currentPage = node.getPageRef();
            if (currentPage == null) {
                nonePageNodes.add(node);
                continue;
            }
            PageContext currentPageContext = ((PageService)this.getApplicationComponent(PageService.class)).loadPage(currentPage);
            if (currentPageContext != null && userACL.hasPermission(currentPageContext)) continue;
            nonePageNodes.add(node);
        }
        nodes.removeAll(nonePageNodes);
    }

    public static class RenameSpaceAppNameActionListener
    extends EventListener<UISpaceMenu> {
        public void execute(Event<UISpaceMenu> event) throws Exception {
            String newUri;
            String spaceUrl;
            Space space;
            UISpaceMenu spaceMenu = (UISpaceMenu)((Object)event.getSource());
            WebuiRequestContext context = event.getRequestContext();
            String newSpaceAppName = context.getRequestParameter(UISpaceMenu.NEW_SPACE_APPLICATION_NAME);
            UIPortal uiPortal = Util.getUIPortal();
            PortalRequestContext prContext = Util.getPortalRequestContext();
            SpaceService spaceService = (SpaceService)spaceMenu.getApplicationComponent(SpaceService.class);
            if (!spaceService.isManager(space = spaceService.getSpaceByUrl(spaceUrl = Utils.getSpaceUrlByContext()), prContext.getRemoteUser()) && !spaceService.isSuperManager(prContext.getRemoteUser())) {
                return;
            }
            UserNode selectedNode = uiPortal.getSelectedUserNode();
            String pageRef = selectedNode.getPageRef().format();
            String appName = pageRef.substring(pageRef.lastIndexOf("::") + 2);
            UserNode homeNode = null;
            homeNode = SpaceUtils.getSpaceUserNode((Space)space);
            if (homeNode == null) {
                throw new Exception("homeNode is null!");
            }
            String oldName = selectedNode.getName();
            if (selectedNode.getResolvedLabel().equals(newSpaceAppName)) {
                prContext.getResponse().sendRedirect(Utils.getSpaceURL(selectedNode));
                return;
            }
            UIApplication uiApp = context.getUIApplication();
            if (!spaceMenu.isValidAppName(newSpaceAppName)) {
                uiApp.addMessage(new ApplicationMessage(UISpaceMenu.INVALID_APPLICATION_NAME_MSG, null, 1));
                prContext.getResponse().sendRedirect(Utils.getSpaceURL(selectedNode));
                return;
            }
            String newNodeName = newSpaceAppName.trim().replace(' ', '_');
            if (spaceMenu.isAppNameExisted(homeNode, newNodeName)) {
                uiApp.addMessage(new ApplicationMessage(UISpaceMenu.EXISTING_APPLICATION_NAME_MSG, null, 2));
                prContext.getResponse().sendRedirect(Utils.getSpaceURL(selectedNode));
                return;
            }
            UserNode renamedNode = homeNode.getChild(oldName);
            renamedNode.setName(newNodeName);
            renamedNode.setLabel(newSpaceAppName);
            DataStorage dataService = (DataStorage)spaceMenu.getApplicationComponent(DataStorage.class);
            Page page = dataService.getPage(renamedNode.getPageRef().format());
            if (page != null) {
                page.setTitle(newNodeName);
                dataService.save(page);
            }
            UserPortal userPortal = Util.getUIPortalApplication().getUserPortalConfig().getUserPortal();
            userPortal.saveNode(homeNode, null);
            String installedApps = space.getApp();
            String[] apps = installedApps.split(",");
            String[] appParts = null;
            String editedApp = null;
            String newInstalledApps = null;
            for (String app : apps) {
                if (app.length() == 0 || !(appParts = app.split(":"))[0].equals(appName)) continue;
                editedApp = appParts[0] + ":" + newSpaceAppName + ":" + appParts[2] + ":" + appParts[3];
                newInstalledApps = installedApps.replaceAll(app, editedApp);
                space.setApp(newInstalledApps);
                spaceService.updateSpace(space);
                break;
            }
            if ((newUri = renamedNode.getURI()) != null) {
                prContext.getResponse().sendRedirect(Utils.getSpaceURL(renamedNode));
            }
        }
    }

    public static class RemoveBannerActionListener
    extends EventListener<UISpaceMenu> {
        public void execute(Event<UISpaceMenu> event) throws Exception {
            UISpaceMenu uiSpaceMenu = (UISpaceMenu)((Object)event.getSource());
            uiSpaceMenu.removeSpaceBanner();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSpaceMenu);
        }
    }
}

