/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.identity.provider;

import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.IdentityProvider;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class SpaceIdentityProvider
extends IdentityProvider<Space> {
    private static final Log LOG = ExoLogger.getExoLogger(SpaceIdentityProvider.class);
    public static final String NAME = "space";
    private SpaceService spaceService;

    public SpaceIdentityProvider(SpaceService spaceService) {
        this.spaceService = spaceService;
    }

    @Override
    public Space findByRemoteId(String spacePrettyName) {
        Space space = null;
        try {
            space = this.spaceService.getSpaceByPrettyName(spacePrettyName);
            if (space == null) {
                space = this.spaceService.getSpaceById(spacePrettyName);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Could not find space " + spacePrettyName), (Throwable)e);
        }
        return space;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Identity createIdentity(Space space) {
        Identity identity = new Identity(NAME, space.getPrettyName());
        return identity;
    }

    @Override
    public void populateProfile(Profile profile, Space space) {
        profile.setAvatarUrl(space.getAvatarUrl());
        profile.setUrl(space.getUrl());
    }
}

