/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.impl.model;

import java.util.List;
import org.exoplatform.forum.service.DataStorage;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.impl.model.AbstractListAccess;
import org.exoplatform.forum.service.impl.model.TopicFilter;

public class TopicListAccess
extends AbstractListAccess<Topic> {
    private TopicFilter filter;
    private DataStorage storage;
    private Type type;

    public TopicListAccess(Type type, DataStorage storage, TopicFilter filter) {
        this.filter = filter;
        this.storage = storage;
        this.type = type;
    }

    public Topic[] load(int index, int length) throws Exception, IllegalArgumentException {
        List<Topic> got = null;
        switch (this.type) {
            case TOPICS: {
                got = this.storage.getTopics(this.filter, index, length);
                break;
            }
            case BY_DATE: {
                got = this.storage.getTopicsByDate(this.filter.date(), this.filter.forumPath(), length, index);
                break;
            }
        }
        this.reCalculate(index, length);
        if (got == null) {
            return new Topic[0];
        }
        return got.toArray(new Topic[got.size()]);
    }

    public int getSize() throws Exception {
        switch (this.type) {
            case TOPICS: {
                this.size = this.storage.getTopicsCount(this.filter);
                break;
            }
            case BY_DATE: {
                this.size = (int)this.storage.getTotalTopicOld(this.filter.date(), this.filter.forumPath());
                break;
            }
        }
        return this.size;
    }

    public Topic[] load(int pageSelect) throws Exception, IllegalArgumentException {
        int offset = this.getOffset(pageSelect);
        int limit = this.getPageSize();
        return this.load(offset, limit);
    }

    public static enum Type {
        TOPICS,
        BY_DATE,
        BY_USER;

    }
}

