/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.search;

import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.exoplatform.commons.api.search.SearchServiceConnector;
import org.exoplatform.commons.api.search.data.SearchContext;
import org.exoplatform.commons.api.search.data.SearchResult;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.service.DataStorage;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumSearchResult;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.service.search.PostId;
import org.exoplatform.forum.service.search.UnifiedSearchResult;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class DiscussionSearchConnector
extends SearchServiceConnector {
    private static final Log LOG = ExoLogger.getLogger(DiscussionSearchConnector.class);
    private DataStorage storage;
    private SpaceService spaceService;
    private String FIX_ICON = "/eXoSkin/skin/images/themes/default/Icons/AppIcons/uiIconAppDefault.png";
    public static final String SPACES_GROUP = "spaces";
    public static final String CATEGORY = "category";
    private static final String FORUM_PAGE_NAGVIGATION = "forum";
    private static final String FORUM_PORTLET_NAME = "ForumPortlet";
    private static final String FORMAT_DATE = "EEEEE, MMMMMMMM d, yyyy K:mm a";

    public DiscussionSearchConnector(InitParams initParams, DataStorage storage, SpaceService spaceService) {
        super(initParams);
        this.storage = storage;
        this.spaceService = spaceService;
    }

    public Collection<SearchResult> search(SearchContext context, String query, Collection<String> sites, int offset, int limit, String sort, String order) {
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        if (CommonUtils.isEmpty((String)query)) {
            return results;
        }
        ExoContainerContext eXoContext = (ExoContainerContext)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ExoContainerContext.class);
        String portalName = eXoContext.getPortalContainerName();
        String currentUser = this.getCurrentUserName();
        try {
            List<ForumSearchResult> searchResults = this.storage.getUnifiedSearch(query, currentUser, offset, limit, sort, order);
            for (ForumSearchResult searchResult : searchResults) {
                PostId id = new PostId(searchResult.getPath());
                Forum forum = this.storage.getForum(id.getCategoryId(), id.getForumId());
                Topic topic = this.storage.getTopicByPath(id.getTopicPath(), false);
                StringBuilder sb = new StringBuilder();
                sb.append(forum.getForumName());
                sb.append(" - " + topic.getPostCount() + " replies");
                SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_DATE);
                sb.append(" - " + sdf.format(searchResult.getCreatedDate()));
                String uri = this.buildLink(context, portalName, id.getCategoryId(), id.getForumId(), id.getTopicId(), topic.getLink());
                String postUri = searchResult.getType().equals(Utils.POST) ? "/" + searchResult.getId() : "";
                UnifiedSearchResult result = new UnifiedSearchResult(uri + postUri, searchResult.getName(), StringEscapeUtils.unescapeHtml((String)searchResult.getExcerpt()), sb.toString(), this.FIX_ICON, searchResult.getCreatedDate().getTime(), searchResult.getRelevancy(), topic.getVoteRating());
                results.add(result);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed in searching.", (Throwable)e);
        }
        return results;
    }

    private String buildLink(SearchContext context, String portalName, String categoryId, String forumId, String topicId, String defaultLink) {
        try {
            String forumURI = null;
            if (categoryId.indexOf(SPACES_GROUP) > 0) {
                forumURI = this.makeURIForSpaceContext(context, portalName, forumId);
                forumURI = URLDecoder.decode(forumURI, "UTF-8");
            } else {
                forumURI = this.makeURIForPortalContext(context, portalName);
            }
            if (!CommonUtils.isEmpty((String)forumURI)) {
                return String.format("%s/%s/%s", forumURI, Utils.TOPIC, topicId);
            }
            return defaultLink;
        }
        catch (Exception ex) {
            return "";
        }
    }

    private String makeURIForPortalContext(SearchContext context, String portalName) throws Exception {
        String path = "";
        String siteType = "";
        String siteName = "";
        List<String> allSites = this.getAllPortalSites();
        for (String siteName_ : allSites) {
            SiteKey siteKey = SiteKey.portal((String)siteName_);
            siteType = SiteType.PORTAL.getName();
            path = this.getSiteName(siteKey);
            if (CommonUtils.isEmpty((String)path)) continue;
            siteName = siteKey.getName();
            break;
        }
        if (Utils.isEmpty(path)) {
            return "";
        }
        String forumURI = context.handler(portalName).lang("").siteName(siteName).siteType(siteType).path(path).renderLink();
        return String.format("/%s%s", portalName, forumURI);
    }

    private String makeURIForSpaceContext(SearchContext context, String portalName, String forumId) throws Exception {
        Space space;
        String path = "";
        String siteType = "";
        String prefixId = Utils.FORUM_SPACE_ID_PREFIX;
        String groupId = forumId.replaceFirst(prefixId, "");
        String spaceGroupId = String.format("/%s/%s", SPACES_GROUP, groupId);
        SiteKey siteKey = SiteKey.group((String)spaceGroupId);
        String siteName = spaceGroupId.replaceAll("/", ":");
        siteType = SiteType.GROUP.getName();
        String forumNavName = this.getSiteName(siteKey);
        if (Utils.isEmpty(forumNavName)) {
            return "";
        }
        if (this.spaceService != null && (space = this.spaceService.getSpaceByGroupId(spaceGroupId)) != null) {
            groupId = space.getPrettyName();
        }
        path = groupId + "/" + forumNavName;
        String forumURI = context.handler(portalName).lang("").siteName(siteName).siteType(siteType).path(path).renderLink();
        return String.format("/%s%s", portalName, forumURI);
    }

    private List<String> getAllPortalSites() {
        UserPortalConfigService dataStorage = (UserPortalConfigService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(UserPortalConfigService.class);
        try {
            return dataStorage.getAllPortalNames();
        }
        catch (Exception e) {
            return new ArrayList<String>();
        }
    }

    private String getSiteName(SiteKey siteKey) {
        try {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            NavigationService navService = (NavigationService)container.getComponentInstance(NavigationService.class);
            NavigationContext nav = navService.loadNavigation(siteKey);
            NodeContext parentNodeCtx = navService.loadNode(NodeModel.SELF_MODEL, nav, Scope.ALL, null);
            Collection children = parentNodeCtx.getNodes();
            if (siteKey.getType() == SiteType.GROUP) {
                children = ((NodeContext)parentNodeCtx.get(0)).getNodes();
            }
            Iterator it = children.iterator();
            NodeContext child = null;
            while (it.hasNext()) {
                child = (NodeContext)it.next();
                if (!FORUM_PAGE_NAGVIGATION.equals(child.getName()) && child.getName().indexOf(FORUM_PORTLET_NAME) < 0) continue;
                return child.getName();
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    private String getCurrentUserName() {
        return ConversationState.getCurrent().getIdentity().getUserId();
    }
}

